/**
 * Copyright gameegg ( http://wonderfl.net/user/gameegg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/84Ok
 */

package {
    import flash.geom.ColorTransform;
    import flash.geom.Point;;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.events.MouseEvent;
    import flash.events.Event;
    import flash.display.Sprite;
    //dna = [[머리w, 머리h, 머리색],[몸통w,몸통h,몸통색]...];
    public class WormBox extends Sprite {
        private var wormbox:Array = [];

        private var breadBox:Array = new Array();
        private var bread:Sprite = new Sprite();
        private var ibread:Boolean = false;
        
        private var bloodBoardData:BitmapData = new BitmapData(465,465,true,0x00ffffff);
        private var bloodBoard:Bitmap = new Bitmap(bloodBoardData);
        private var blood:Sprite = new Sprite();
        private var colorTransForm:ColorTransform = new ColorTransform(1,1,1,0.9);
        
        public function WormBox() {
            
            addChild(bloodBoard);
            addChild(bread);
            
            for(var i:int = 0; i<10; ++i){
                
                var dna_tmp:Array = [[5+Math.random(),5+Math.random(),int(Math.random()*0xffffff)],
                [5+Math.random(),5+Math.random(),int(Math.random()*0xffffff)],
                [4.5+Math.random(),4.5+Math.random(),int(Math.random()*0xffffff)],
                [4+Math.random(),4+Math.random(),int(Math.random()*0xffffff)]]
                
                var worm_tmp:WormHead = createWorm(dna_tmp);
                worm_tmp.x = Math.random()*400+30;
                worm_tmp.y = Math.random()*400+30;
                worm_tmp.rotation = Math.random()*360;
                addChild(worm_tmp);
                wormbox.push(worm_tmp)
            }            createBread(Math.random()*465,Math.random()*465);
            
            stage.addEventListener(Event.ENTER_FRAME,update);
            stage.addEventListener(MouseEvent.MOUSE_DOWN,mouseDown);
        }
        
        private function update(e:Event):void {
            for(var n:int = 0; n<wormbox.length; ++n){
                wormbox[n].update();
                wormbox[n].breadPoint.x = bread.x;
                wormbox[n].breadPoint.y = bread.y;
                if((wormbox[n].x-bread.x)*(wormbox[n].x-bread.x)+(wormbox[n].y-bread.y)*(wormbox[n].y-bread.y)
                < 25){
                    bread.graphics.clear();
                    ibread = false;
                    createBread(Math.random()*465,Math.random()*465);
                    
                    var worm_tmp:WormHead;
                    var childDNA_tmp:Array = [];
                    
                    childDNA_tmp = wormbox[n].makeChild();
                    
                    worm_tmp = createWorm(childDNA_tmp);
                    
                    worm_tmp.x = wormbox[n].x+Math.random()*10 -5;
                    worm_tmp.y = wormbox[n].y+Math.random()*10 -5;
                    worm_tmp.rotation = wormbox[n].rotation+Math.random()*60 -30;
                    addChild(worm_tmp);
                    wormbox.push(worm_tmp);
                    break;
                }
                for(var m:int = 0; m<wormbox.length; ++m){
                    if((wormbox[n].x-wormbox[m].x)*(wormbox[n].x-wormbox[m].x) + 
                    (wormbox[n].y-wormbox[m].y)*(wormbox[n].y-wormbox[m].y) < 9 &&
                    Math.abs(wormbox[n].dna[0][2] -wormbox[m].dna[0][2]) > 1 ) {
                        
                        if(wormbox[n].dna[0][0] > wormbox[m].dna[0][0]){
                            killingWorm(wormbox[m],m);
                        }
                        else {
                            //killingWorm(wormbox[n],n);
                        }


                    }

                }

            }
            bloodBoardData.colorTransform(bloodBoardData.rect,colorTransForm);
            //if(!ibread){
            //    createBread(Math.random()*465,Math.random()*465);
            //}

        }

        
        private function createWorm(idna:Array):WormHead {
            var worm:WormHead;
            var bodies:Array = [];
            for(var wb:int = idna.length-1; wb > 0; --wb){
                var body_tmp:Sprite = new Sprite;
                body_tmp.graphics.lineStyle(1,0x0);
                body_tmp.graphics.beginFill(idna[0][2]);
                body_tmp.graphics.drawRect(-idna[wb][0]/2,-idna[wb][1]/2,idna[wb][0],idna[wb][1]);
                addChild(body_tmp);

                bodies.unshift(body_tmp);
            }
            worm = new WormHead(idna,bodies);
            worm.bodies.unshift(worm);
            return worm;
        }
        
        public function createBread(ix:Number, iy:Number):void{
            
            bread.graphics.beginFill(0xaa7700);
            bread.graphics.drawCircle(0,0,8);
            bread.x = ix;
            bread.y = iy;
            
            ibread = true;
        }

        
        
        
        private function mouseDown(e:MouseEvent):void {
            for(var n:int = 0; n<wormbox.length; ++n){
                if((wormbox[n].x-mouseX)*(wormbox[n].x-mouseX)+(wormbox[n].y-mouseY)*(wormbox[n].y-mouseY)
                < 25){
                    killingWorm(wormbox[n],n);
                }
            }
        }
        
        private function killingWorm(target:WormHead,targetNumber:Number):void {
            
            blood.graphics.beginFill(0xaa0000);
            blood.graphics.drawCircle(target.x,target.y,target.dna[0][0]+target.dna[0][1]);
            bloodBoardData.draw(blood);
            blood.graphics.clear();
            while(target.bodies.length > 0){
                removeChild(target.bodies.pop());
            }
            wormbox.splice(targetNumber,1);
        }
        
        public function pit(p1:Point,p2:Point):Number{
            return Math.sqrt((p1.x-p2.x)*(p1.x-p2.x)+(p1.y-p2.y)*(p1.y-p2.y));
        }


    }
}
import flash.geom.Point;












import flash.display.Sprite;
import flash.utils.ByteArray;

internal class WormHead extends Sprite {
     
    public var dna:Array = [];
    public var childDNA:Array = [];
    public var bodies:Array = [];
    public var headMoving:Boolean = false;
    public var gab:Number;
    public var r:Number = 0;
    public var currentR:Number = 0;
    public var finalR:Number = 0;
    public var life:Number;
    public var breadPoint:Point = new Point(0,0);
    //public var bread:Boolean = false;
    public var rotate:Boolean = false;
    
    
    public function WormHead(idna:Array,ibodies:Array) {
        
        dna = idna;
        bodies = ibodies;
        life = dna[0][0]*2;
        
        graphics.lineStyle(1,0x0);
        graphics.beginFill(dna[0][2]);
        graphics.drawRect(-dna[0][0]/2,-dna[0][1]/2,dna[0][0],dna[0][1]);
        graphics.beginFill(0xAA0000);
        graphics.drawCircle(-dna[0][0]/2,-0.7,2);
        graphics.drawCircle(dna[0][0]/2,-0.7,2);
        
        gab = dna[0][1];
        
    }
    
    public function makeChild():* {
        
        //childDNA = [];
        /*
        for(var k:int = 0; k<dna.length; ++k){
            childDNA[k] = [];
            for(var k2:int = 0; k2<dna[k].length; ++k2){
                childDNA[k][k2] = new Number(dna[k][k2]);
            }
        }*/
        
        var ba:ByteArray = new ByteArray();
        ba.writeObject(dna);
        ba.position = 0;
        childDNA = ba.readObject()
        
        
        for(var i:int = 0; i<childDNA.length; ++i) {
            
            for(var j:int = 0; j<childDNA[i].length; ++j){
                childDNA[i][j] += Math.random()-0.5;
            }
            if(Math.random()<0.5){
                if(Math.random()>0.5){
                    childDNA.push(childDNA[childDNA.length-1]);
                }
                else if(childDNA.length >=3){
                    childDNA.pop();
                }

            }

        }
        ba.writeObject(childDNA);
        ba.position = 0;
        
        return (ba.readObject());
    }
    
    public function update():void {
        

        //if(bodies[0].rotation*Math.PI/180 != Math.atan2(breadPoint.y-bodies[0].y,breadPoint.x-bodies[0].x) ){
            //bodies[0].rotation = 90 + (180/Math.PI)*Math.atan2(breadPoint.y-bodies[0].y,breadPoint.x-bodies[0].x)
             
                finalR = (90 + (180/Math.PI)*Math.atan2(breadPoint.y-bodies[0].y,breadPoint.x-bodies[0].x));
                if(finalR > 180) finalR -= 360;
                else if(finalR < -180) finalR += 360;
        //}     
        //currentR = bodies[0].rotation
        
        var check:Number = Math.abs(-finalR + bodies[0].rotation);
        
        
        if(!headMoving){
            if(!rotate){
                gab -= dna[0][1]/40;
                if(gab < dna[0][1]/2 ){
                    headMoving = true;
                    if(check >= 20) rotate = true;
                }
            }
            else{
                gab = dna[0][1]/1.75
                if(r > 0) r --;
                else r ++;
                if(Math.abs(r)<2){
                     headMoving = true;
                }

            }

        }
        else {
            if(!rotate){
                gab += dna[0][1]/40;
                if(gab > dna[0][1]/1.5){
                    headMoving = false;
                }
            }
            else{
                gab = dna[0][1]/1.75
                
                if(Math.abs(finalR-bodies[0].rotation - 1) < Math.abs(finalR-bodies[0].rotation + 1)){
                    r--;
                }
                else {
                    r++;
                }
                if(Math.abs(r)>20 || check < 20){
                    headMoving = false;
                }
                    
                    if(check < 20) rotate = false;
                

            }

        }
        
        
        
        
        if(!headMoving){
            for(var i:int = 0; i<bodies.length-1; ++i){
                //if(r == 0){
                    bodies[i+1].x = bodies[i].x + Math.cos((bodies[i].rotation+90)*Math.PI/180)*gab;
                    bodies[i+1].y = bodies[i].y + Math.sin((bodies[i].rotation+90)*Math.PI/180)*gab;
                //}
                 bodies[i+1].rotation = r + bodies[i].rotation;
            }
            
        }
        else {
            for(var j:int = bodies.length -1; j>0; --j){
                bodies[j-1].rotation = bodies[j].rotation-r;
                //if(r == 0){
                bodies[j-1].x = bodies[j].x - Math.cos((bodies[j-1].rotation+90)*Math.PI/180)*gab;
                bodies[j-1].y = bodies[j].y - Math.sin((bodies[j-1].rotation+90)*Math.PI/180)*gab;
                //}
            }
        }
        if(check < 20){
            r=0
        }
    }


}
