/**
 * Copyright Thy ( http://wonderfl.net/user/Thy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/842p
 */

// forked from Thy's flash on 2011-10-8
package 
{
    import flash.display.Graphics;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    /**
     * ...
     * @author Thy
     */
    public class Main extends Sprite 
    {
        
        private var s:Shape;
        private var s2:Shape;
        private var g:Graphics;
        private var g2:Graphics;
        private var dimension:Number;
        private var x1:Number, y1:Number;
        private var x2:Number, y2:Number;
        private var teta:Number = 0;
        private var r:Number = 0;
        private var r1:Number = 0;
        private var r2:Number = 0;
        private var r3:Number = 0;
        
        
        public function Main():void 
        {
            stage.frameRate = 100;
            s = new Shape();
            s2 = new Shape();
            g = s.graphics;
            g2 = s2.graphics;
            this.addChild(s);
            s.rotation += 180;
            s2.rotation += 180;
            s.scaleX *= -1;
            s2.scaleX *= -1;
            g.lineStyle(2, 0x2366D5);
            g2.lineStyle(1, 0xAAAAAA, .5);
            s.x = stage.stageWidth / 2;
            s2.x = stage.stageWidth / 2;
            s.y = stage.stageHeight / 2;
            s2.y = stage.stageHeight / 2;
            teta = 0;
            r = fr(teta);
            x1 = fx(r, teta);
            y1 = fy(r, teta);
            g.moveTo(x1, y1);
            dimension = Math.sqrt(s.x * s.x + s.y * s.y);
            
            stage.addEventListener(MouseEvent.CLICK, click);
            
            // consturindo
            this.addEventListener(Event.ENTER_FRAME, ef);
            this.addChild(s2);
            
            r2 = 200;
            r1 = r3 = 10;
        }
        
        private var op:int = 0;
        private function click(e:MouseEvent):void 
        {
            if (++op > 5)
                op = 0;
                
            g.clear();
            g.lineStyle(2, 0x2366D5);
            r = fr(teta);
            x1 = fx(r, teta);
            y1 = fy(r, teta);
            
            
            if (op == 0)
            {
                this.addEventListener(Event.ENTER_FRAME, ef);
                this.addChild(s2);
                
                // ease
                this.removeEventListener(Event.ENTER_FRAME, ef2);
                return;
            } else if (op == 3)
            {
                this.removeEventListener(Event.ENTER_FRAME, ef);
                this.removeChild(s2);
                
                // ease
                this.addEventListener(Event.ENTER_FRAME, ef2);
                r2 = 200;
                r1 = r3 = 10;
                return;
            } else if (op == 4)
            {
                r2 = 100;
                r1 = r3 = 10;
            } else if (op == 5)
            {
                r2 = 200;
                r1 = r3 = 10;
            }
        }
        
        private function fr(teta:Number):Number
        {
            if(op==0)
                return 100;
            if(op==1)
                return Math.sin (8 * teta / 5) * 100;
            if(op==2)
                return Math.sin (teta) * 100 + 100;
            return 0;
        }
        private function fr2(teta:Number, r1:Number):Number
        {
            if(op==3)
                return r1;
            if(op==4)
                return Math.sin (teta) * r1 + 50;
            if(op==5)
                return Math.sin (teta) * r1 + 170 - r1;
            return 0;
        }
        
        
        private function ef(e:Event):void 
        {
            teta += 1 * Math.PI / 180;
            
            g.moveTo(x1, y1);
            g2.clear();
            g2.lineStyle(1, 0xAAAAAA, .5);
            g2.moveTo(0, 0);
            g2.lineTo(dimension * Math.cos(teta), dimension * Math.sin(teta));
            g2.lineStyle(1, 0xAAAAAA, .1);
            g2.moveTo(0, 0);
            g2.lineTo(-dimension * Math.cos(teta), -dimension * Math.sin(teta));
            r = fr(teta);
            x1 = fx(r, teta);
            y1 = fy(r, teta);
            g.lineTo(x1, y1);
        }
        
        private function ef2(e:Event):void 
        {
            r1 += fr1(r1, r2);
            if ( Math.abs(r1 - r2) < 1)
            {
                r2 = r3;
                r3 = r1;
            }
            
            g.clear();
            g.lineStyle(2, 0x2366D5);
            
            r = fr2(teta, r1);
            x1 = fx(r, teta);
            y1 = fy(r, teta);
            var i:int = -1;
            while (++i < 360)
            {
                teta -= Math.PI / 180;
                
                g.moveTo(x1, y1);
                r = fr2(teta, r1);
                x1 = fx(r, teta);
                y1 = fy(r, teta);
                g.lineTo(x1, y1);
            }
        }
        private function fx(r:Number, teta:Number):Number
        {
            return r * Math.cos(teta);
        }
        private function fy(r:Number, teta:Number):Number
        {
            return r * Math.sin(teta);
        }
        private function fr1(r1:Number, r2:Number):Number
        {
            return (r2 - r1) * .05;
        }
        
    }
    
}