/**
 * Copyright jong ( http://wonderfl.net/user/jong )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/83kz
 */

// forked from simultechnology's 塗りつぶした星をまわす。
package
{
    import flash.geom.Rectangle;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.display.StageScaleMode;
    import flash.filters.BlurFilter;
    import flash.display.BitmapData;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.display.BlendMode;
    import flash.display.Bitmap;
    
    public class BitMapStar extends Sprite
    {
        private var _starList:Array = new Array();
        private var _rotationList:Array = new Array();
        private var blur:BlurFilter;
        private var bitmapData:BitmapData;
        private var rect:Rectangle;
        private var container:Sprite;
        private var bitmap:Bitmap;
        private static var point:Point = new Point();
        
        public function BitMapStar()
        {
            this.addEventListener(Event.ADDED_TO_STAGE, init, false, 0, true);

        }
        
        private function init(e:Event):void
        {
            this.removeEventListener(Event.ADDED_TO_STAGE, init, false);
            stage.scaleMode = StageScaleMode.EXACT_FIT;
            graphics.beginFill(0x0);
            graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            graphics.endFill();
            
            blur = new BlurFilter(10,10,25);
            rect = new Rectangle(0,0,stage.stageWidth, stage.stageHeight);
            bitmap = new Bitmap(bitmapData);
            addChild(bitmap);

            //if (stage.stageWidth < stage.stageHeight) i = stage.stageWidth / 8; else i = stage.stageHeight / 8;
            
            var i:uint;
            i = stage.stageWidth / 6 ;
            
            createStar(stage.stageWidth / 2 , stage.stageHeight / 2 , stage.stageHeight / 4 );
            createStar(i*0.5, stage.stageHeight -  i, i / 2);
            createStar(i*1.5, stage.stageHeight -  i, i / 2);
            createStar(i*2.5, stage.stageHeight -  i, i / 2);
            createStar(i*3.5, stage.stageHeight -  i, i / 2);
            createStar(i*4.5, stage.stageHeight -  i, i / 2);
            createStar(i*5.5, stage.stageHeight -  i, i / 2);
            
            //this.stage.addEventListener(MouseEvent.CLICK, goToCreateStar, false, 0, true);
           
            addChild(container);
            addEventListener(Event.ENTER_FRAME, rotate, false, 0, true);
        }
        
        private function goToCreateStar(e:MouseEvent):void
        {
            createStar(mouseX, mouseY, 100 * (Math.random() * 0.9 + 0.1));
        }
        
        private function createStar(x:int, y:int, radius:int):void
        {    
            //var r:Number = Math.random();
            //
            //{
            //     case ;   
            //};
            var color:uint = 0x000080; // = (Math.random() * 0.9 + 0.1) * 0xFFFFFF;
            var color2:uint = (Math.random() * 0.9 + 0.1) * 0xFFFFFF;
            var star:Shape = new Shape();
            //var bmd:BitmapData = new BitmapData(100, 100, true, 0x50FFFFFF);
            //var bm:Bitmap = new Bitmap(bmd);
            //star.graphics.beginBitmapFill(bmd);
            star.graphics.beginFill(color2);
            //star.graphics.beginFill(0);
            var i:int;
            star.graphics.lineStyle(3, color);
            star.x = x;
            star.y = y;
            
            star.graphics.moveTo(radius * Math.cos(72 * Math.PI / 180), radius * Math.sin(72 * Math.PI / 180));
            for (i = 1; i < 6; i ++)
            {
                star.graphics.lineTo(radius * Math.cos((72 + 144 * i) * Math.PI / 180 ), radius * Math.sin((72 + 144 * i) * Math.PI / 180));
            }

            star.graphics.moveTo(radius * Math.cos((36 + 72*i) * Math.PI / 180 ) / 3, radius * Math.sin((36 + 72*i) * Math.PI / 180) / 3);
            for (i = 1; i < 6; i ++)
            {
                star.graphics.lineTo(radius * Math.cos((36 + 72*i) * Math.PI / 180 ) / 3, radius * Math.sin((36 + 72*i) * Math.PI / 180) / 3);
            }
            this._rotationList.push(Math.random() >= 0.5 ? (Math.random() * 0.9 + 0.1) * 5 : (Math.random() * -0.9 - 0.1) * 5);
            _starList.push(star);
            
            //this.stage.addChild(star);
            container.addChild(star);
        }
        
        private function rotate(e:Event):void
        {
            var len:int = this._starList.length;
            for (var i:int = 0; i < len; i++) {
                this._starList[i].rotation += this._rotationList[i];
            }
            bitmapData.lock();
            bitmapData.draw(container, null, null, BlendMode.SCREEN, null, true);
            bitmapData.applyFilter(bitmapData, rect, point, blur);
            bitmapData.unlock();        
        }
    }
}