/**
 * Copyright toastie ( http://wonderfl.net/user/toastie )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/83a4
 */

// forked from toastie's forked from: forked from: forked from: forked from: forked from: forked from: forked from: forked from: forked from: forked from: forked from: flash on 2009-12-3
// forked from scarybug's forked from: forked from: forked from: forked from: forked from: forked from: forked from: forked from: forked from: forked from: flash on 2009-12-3
// forked from toastie's forked from: forked from: forked from: forked from: forked from: forked from: forked from: forked from: forked from: flash on 2009-12-3
// forked from scarybug's forked from: forked from: forked from: forked from: forked from: forked from: forked from: forked from: flash on 2009-12-3
// forked from toastie's forked from: forked from: forked from: forked from: forked from: forked from: forked from: flash on 2009-12-3
// forked from scarybug's forked from: forked from: forked from: forked from: forked from: forked from: flash on 2009-12-3
// forked from toastie's forked from: forked from: forked from: forked from: forked from: flash on 2009-12-3
// forked from toastie's forked from: forked from: forked from: forked from: flash on 2009-12-3
// forked from fucrate's forked from: forked from: forked from: flash on 2009-12-3
// forked from toastie's forked from: forked from: flash on 2009-12-3
// forked from scarybug's forked from: flash on 2009-12-3
// forked from toastie's flash on 2009-12-3
// TIGSource collaborative game expriment #1

package {
    import flash.display.Sprite;
    import flash.events.KeyboardEvent;
    import flash.events.Event;
    
     [SWF(width=465, height=465, frameRate=60)]
    public class FlashTest extends Sprite {
        
        private var player:Player;
        private var enemies:Array;
        private var inputArray:Array;
        private var drawing_area:Sprite;
        
        private var updateList:Array;
                
        public function FlashTest() {
             initInput();
             initGame();  
        }
        
        private function initInput() : void {
            
            inputArray = new Array();
            for(var i:uint =0;i < 256; i++) {
                 inputArray.push(false);   
            }
            
            stage.addEventListener(KeyboardEvent.KEY_DOWN,onKeyDown);
            stage.addEventListener(KeyboardEvent.KEY_UP,onKeyUp);
            this.addEventListener(Event.ENTER_FRAME, updateGame);
        }
        
        public function onKeyDown(e:KeyboardEvent) : void {
            inputArray[e.keyCode] = true;        
        }

        public  function onKeyUp(e:KeyboardEvent) : void {
            inputArray[e.keyCode] = false;        
        }
        
        public function collision():void{
            for each(var enemy:Enemy in enemies)
            {
                if(enemy.hitTestPoint(player.x, player.y))
                {
                    enemy.flag();
                }
            }
        }
        
        public  function updateGame(e:Event) : void {
            
            updateGameEntities();
            updateEnemies();
            collision();
            
            if(inputArray[37]) {
                   player.rotation -= 4;
            }

            if(inputArray[39]) {
                   player.rotation += 4;
            }       
                 
            if(inputArray[38]) {                    
                player.move();
                player.speed = Math.abs(player.speed);
            }

            if(inputArray[40]) {                    
                player.move();
                player.speed = -1 * Math.abs(player.speed);
            }

                 
             if(inputArray[37] || inputArray[38] || inputArray[39] || inputArray[40]){
                drawing_area.graphics.beginFill(0x00ff00);
                drawing_area.graphics.drawCircle(player.x,player.y,2);
                drawing_area.graphics.endFill();
            }                     
                 
        }
        
        private function updateGameEntities() : void {
         for(var i:uint=0; i < updateList .length; i++) {
             updateList[i].update();
         }    
        }
        
        private function updateEnemies() : void {
            var all_flagged:Boolean = true;
            for(var i:uint=0; i < enemies.length; i++) {
                  if(!enemies[i].is_flagged){
                      all_flagged = false;
                  }
                   if(enemies[i].y > 470)
                       enemies[i].y = -10;
                       
                   if(enemies[i].y < -10)
                       enemies[i].y = 470;

                   if(enemies[i].x > 470)
                       enemies[i].x = -10;
                       
                   if(enemies[i].x < -10)
                       enemies[i].x = 470;
                       
            }    
            if(all_flagged){
                unflagAll();    
            }
        }
        
        private function unflagAll():void{
         //   player.speed += 1;
           drawing_area.graphics.clear();
            for(var i:uint=0; i < enemies.length; i++) {
                  enemies[i].unflag(); 
           }
        }
        
        private function addGameEntity(entity:GameEntity) : void {
             updateList.push(entity);
             addChild(entity);   
        }
        
        private function initGame() : void {
            
           updateList = new Array();
            
           player = new Player();
           player.speed = 3;
           drawing_area = new Sprite();
           addChild(drawing_area);
            addGameEntity(player);
            
            player.x = 465/2;
            player.y = 465/2;
            player.rotation = 180;
            
            enemies = new Array();
            for(var i:uint=0; i < 15; i++) {
                var newEnemy:Enemy = new Enemy();
                enemies.push(newEnemy);
                newEnemy.x = Math.random() * 465;
                newEnemy.y = Math.random() * 465;    
                newEnemy.rotation = Math.random() * 360;    
                addGameEntity(newEnemy);        
            }           
        }

    }
}

import flash.display.Sprite;
internal class GameEntity extends Sprite {

        //x and y velocities
        public var vx:Number=0;
        public var vy:Number=0;
        public var speed:Number = 1;        
                  
        public function GameEntity (){
             
                   
        }
        
        public function update() : void {
            
        }
        
        public function updateVelocities():void{
                vx = Math.sin(Math.PI -this.rotation*0.0174532925);
                vy = Math.cos(Math.PI -this.rotation*0.0174532925);
        }
        
        public function move():void{
            updateVelocities();
            x -= (vx *speed);
            y -= (vy*speed);
        }

}

internal class Player extends GameEntity {
          
        public function Player(){
          graphics.beginFill(0x00ff00);
           graphics.drawCircle(0,0,10);           
           graphics.endFill();   
              
          graphics.beginFill(0x0000ff);
           graphics.drawRect(-1,0,2,10);           
           graphics.endFill();               
                   
        }
}


internal class Enemy extends GameEntity {

        public var is_flagged:Boolean = false;
        public var turnDeviation:Number = 0;
            
        public function Enemy (){
             super();
            speed =  1; 
           graphics.beginFill(0xff0000);
           graphics.drawCircle(0,0,15);           
           graphics.endFill();    
            
           graphics.beginFill(0x0000ff);
           graphics.drawRect(-1,0,2,10);           
           graphics.endFill();                 
             
        }
        
        public override function update() : void {
            turnDeviation += (-1 + (Math.random() * 2));
            if(turnDeviation > 4)
                turnDeviation = 4;
            if(turnDeviation < -4)
                turnDeviation = -4;
            rotation += turnDeviation;
            move();
                        
        }

        
        public function flag() : void {
            if(!is_flagged){
               is_flagged = true;
               graphics.beginFill(0x0000ff);
               graphics.drawCircle(0,0,15);           
               graphics.endFill();    
               this.scaleX -=0.1;
                this.scaleY -=0.1;
               graphics.beginFill(0x00ff00);
               graphics.drawRect(-1,0,2,10);           
               graphics.endFill();           
            }  
        }
        public function unflag() : void {
            if(is_flagged){
                 speed +=  1; 
               is_flagged = false
                graphics.beginFill(0xff0000);
                 graphics.drawCircle(0,0,15);           
                graphics.endFill();    
            
                 graphics.beginFill(0x0000ff);
                graphics.drawRect(-1,0,2,10);           
                graphics.endFill();           
            }  
        }
 }