/**
 * Copyright ton ( http://wonderfl.net/user/ton )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/838I
 */

/*
http://blog.jactionscripters.com/2009/05/31/smart-gradient-api/
このGradientAPIの適用例
*/

package {
    import flash.display.Sprite;
	import flash.geom.Point;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            var mc1:SpriteEx = new SpriteEx();
            mc1.x = mc1.y = stage.stageWidth / 4;
            mc1.beginLinearGradientFill([0x000000, 0xfffffff], [1, 1], [0, 255], new Point(), new Point(100,100));  		
            mc1.graphics.drawCircle(0, 0, 100);
            addChild(mc1);
			
            var mc2:SpriteEx = new SpriteEx();
            mc2.x = mc2.y = stage.stageWidth *3/ 4;
            mc2.beginRadialGradientFill([0x000000,0xffffff],[1.0,1.0],[0,255], new Point(0,0), 150);  
            mc2.graphics.drawCircle(0, 0, 100);
            addChild(mc2);			
        }
    }
}

import flash.display.GradientType;
import flash.display.Sprite;
import flash.geom.Matrix;
import flash.geom.Point;
class SpriteEx extends Sprite{
    public function beginRadialGradientFill(	colors:Array,
	alphas:Array,
	ratios:Array,
	centerPoint:Point,
	radius:Number,
	spreadMethod:String="pad",
	interpolationMethod:String="rgb"):void{

        var mat:Matrix = new Matrix();
        mat.createGradientBox(radius*2,radius*2,0,centerPoint.x-radius,centerPoint.y-radius);
        graphics.beginGradientFill(GradientType.RADIAL, colors, alphas, ratios, mat, spreadMethod, interpolationMethod)
    }

    public function beginLinearGradientFill(	colors:Array,
	alphas:Array,
	ratios:Array,
	startPoint:Point,
	endPoint:Point,
	spreadMethod:String="pad",
	interpolationMethod:String="rgb"):void{
        var dx:Number = endPoint.x-startPoint.x;
        var dy:Number = endPoint.y-startPoint.y;
        var dist:Number = Math.sqrt(dx*dx+dy*dy);
        var rad:Number = Math.atan2(dy,dx);
        var offsetX:Number = -(dist - Math.cos(rad)*dist)*0.5 + startPoint.x;
        var offsetY:Number = -(dist - Math.sin(rad)*dist)*0.5 + startPoint.y;
        
        var mat:Matrix = new Matrix();
        mat.createGradientBox(dist,dist,rad,offsetX,offsetY);
        graphics.beginGradientFill(GradientType.LINEAR, colors, alphas, ratios, mat, spreadMethod, interpolationMethod)
    }
}