/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/832M
 */

package {
    import flash.ui.Keyboard;
    import flash.events.KeyboardEvent;
    import flash.display.Graphics;
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {

          //scaleX = scaleY = 0.1;

                
          initEmpty(128, 128);
          var i:int;
          for (i=0;i<640;i+=1)
          {
            setTile(Math.random()*mw, Math.random()*mh, 70);    
          }
        
          stage.addEventListener(KeyboardEvent.KEY_DOWN, onKdown);
          stage.addEventListener(KeyboardEvent.KEY_UP, onKup);
          stage.addEventListener(Event.ENTER_FRAME, onEnter);      
        }//ctor
        
        public var vecKey:Vector.<Boolean> = new Vector.<Boolean>(512,false);
        public function isKeyDown(k:int):Boolean { return vecKey[k]==true; }
        public function onKdown(e:KeyboardEvent):void { vecKey[e.keyCode] = true; }
        public function onKup(e:KeyboardEvent):void { vecKey[e.keyCode] = false; }

        
        
        public var cx:Number = 256;
        public var cy:Number = 16;
        public var cz:Number = 256;
        
        
        public function onEnter(e:Event):void
        {
            
            var mx:Number; var my:Number;
            mx = stage.mouseX; my = stage.mouseY;

            var wmx:Number; var wmy:Number; var wmz:Number;           
            var ax:Number; var ay:Number; var az:Number;
                ay = (2*my - (mx-rendw)) * 0.5 ;
                ax = (mx-rendw) + ay ;
                ax+=camx; ay+=camz;
                wmx = ax; wmz = ay; wmy = 0;

            
            
            graphics.clear();
            graphics.lineStyle(2, 0);
            
            drawBox3(0,0,0, 512,-8,512);
            drawBox3(0,0,0, mw*cw,32,mh*ch);
            
            
 
            drawMap();           
            
            var ms:Number;
            var kx:Number; var ky:Number;
            kx=0;ky=0;
            ms = 8;
              if (isKeyDown(Keyboard.UP))    { ky-=ms; kx-=ms; }
              if (isKeyDown(Keyboard.DOWN))  { ky+=ms; kx+=ms; }
              if (isKeyDown(Keyboard.LEFT))  { kx-=ms; ky+=ms; }
              if (isKeyDown(Keyboard.RIGHT)) { kx+=ms; ky-=ms; } 
              
              
         //     cx+=kx; cz+=ky;
            
            if (isWall(cx+kx,cz)) {kx= 0;} cx+=kx; 
            if (isWall(cx,cz+ky)) {ky = 0;}cz+=ky; 
            
            drawBox2(cx,cy,cz, 16,16,16);
            
            //var ax:Number; var az:Number;
            
            ax = cx-256;
            az = cz-256;
            
            camx += (ax-camx)*0.1;
            camz += (az-camz)*0.1;
     
           drawBox2(wmx,wmy,wmz, 4,1,4);
            
            
        }//onenter
        
        
        public function isWall(ax:Number, ay:Number):Boolean
        { return isWall2(Math.floor(ax/cw), Math.floor(ay/ch));  }
        
        public function isWall2(ax:int, ay:int):Boolean
        { if (ax<0||ax>=mw||ay<0||ay>=mh) {return true;} return (getTile(ax,ay) >0);  }
        
        
        public function drawMap():void
        {
          var i:int; var k:int; var yt:int; var h:int;
          var ax:int; var ay:int;
          var ex:int; var ey:int;
                
           ax = 0; ay = 0;
           ax = camx/cw -3;           ay = camz/ch -3;
           if (ax<0) { ax=0; }           if (ay<0) { ay=0; }
           
           ex = ax+16+6; ey = ay+16+6;
           if (ex>mw) {ex=mw;}           if (ey>mh) {ey=mh;}
           
           for(i=ay;i<ey;i+=1)
           { yt = i*mw;
             for (k=ax;k<ex;k+=1)
             {
               h = vecGrid[yt+k]; if (h<4){continue;}
               drawBox3(k*cw,0,i*ch, cw, h, ch);            
             }//nextk
           }//nexti  
            
            
        }//drawmap
        
        
        
         
        public var mw:int = 0;
        public var mh:int = 0;
        public var cw:Number = 32;
        public var ch:Number = 32;
        
        public var vecGrid:Vector.<int>; 
        
               
        public function initEmpty(aw:int, ah:int):void
        { mw=aw; mh=ah; vecGrid = new Vector.<int>(aw*ah, false); }

        public function setTile(ax:int, ay:int, t:int):void
        { if (ax<0||ax>=mw||ay<0||ay>=mh) {return;} vecGrid[ay*mw+ax]=t; }

        public function getTile(ax:int, ay:int ):int
        { if (ax<0||ax>=mw||ay<0||ay>=mh) {return 0;}  return vecGrid[ay*mw+ax]; }
 
        
        public var camx:Number = 0;        public var camy:Number = 0;        public var camz:Number = 0; 
        public var rendw:Number = 465 * 0.5;        public var rendh:Number = 465 * 0.5; 
        public function drawLine(ax:Number, ay:Number, az:Number,
        bx:Number, by:Number, bz:Number):void
        {
           var sx:Number; var sy:Number;     
           ax -= camx; ay -= camy; az -= camz;
           bx -= camx; by -= camy; bz -= camz;
            sx = ax - az + rendw;     sy = (ax * 0.5) + (az * 0.5) - ay;
            graphics.moveTo(sx,sy);
            sx = bx - bz + rendw;     sy = (bx * 0.5) + (bz * 0.5) - by;
            graphics.lineTo(sx, sy);
        }//drawline 

        public function drawBox3(ax:Number,ay:Number,az:Number,
        aw:Number,ah:Number,ad:Number):void
        { drawBox(ax,ay,az, ax+aw,ay+ah,az+ad); }
        
        public function drawBox2(ax:Number,ay:Number,az:Number,
        rx:Number,ry:Number,rz:Number):void
        { drawBox(ax-rx,ay-ry,az-rz,ax+rx,ay+ry,az+rz); }
           
         public function drawBox(ax:Number, ay:Number, az:Number,
          bx:Number, by:Number, bz:Number):void
        {
          drawLine(ax, ay, az,   bx, ay, az);
          drawLine(ax, by, az,   bx, by, az);
          drawLine(ax, ay, bz,   bx, ay, bz);
          drawLine(ax, by, bz,   bx, by, bz);
          
          drawLine(ax, ay, az,   ax, by, az);
          drawLine(bx, ay, az,   bx, by, az);
          drawLine(ax, ay, bz,   ax, by, bz);
          drawLine(bx, ay, bz,   bx, by, bz);
          
          drawLine(ax, ay, az,   ax, ay, bz);
          drawLine(bx, ay, az,   bx, ay, bz);
          drawLine(ax, by, az,   ax, by, bz);
          drawLine(bx, by, az,   bx, by, bz);
        }//drawbox    
        
        
    }//classend 
}