/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/82vc
 */

// forked from muta244's [最適化 Tips] Array, Vector 走査時に加算を行う際の処理速度の違い
package {

import flash.display.*;
import flash.geom.*;
import flash.events.*;
import flash.text.*;
import flash.utils.*;

public class Main extends Sprite
{
    static private const _NUM_TIMES:uint = 1000000;
    
    private function _init():void
    {
        _debug(
            "各テスト " + _NUM_TIMES + " 回処理させた計算結果 [単位 ： ミリ秒]\n" +
            "(誤差は多少生じます)\n"
        );
        
        var array:Array = [];
        var vector1:Vector.<int> = new Vector.<int>(0, false);
        var vector2:Vector.<int> = new Vector.<int>(_NUM_TIMES, false);
        var vector3:Vector.<int> = new Vector.<int>(_NUM_TIMES, true);
        var unit : SLLUnit = new SLLUnit(0);
        
        for (var i:uint = 0; i < _NUM_TIMES; i++) {
            array[i] = 0;
            vector1[i] = 0;
            unit = new SLLUnit(0, unit);
        }
        
        _measure("ループのみ", function ():void
        {
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                
            }
        });
        
        _measure("Array の要素に加算処理", function ():void
        {
            var e:uint;
            for (var i:uint = 0, l:uint = array.length; i < l; i++) {
                array[i]++;
            }
        });
        
        _measure("Vector.<int>(0, false) の要素に加算処理", function ():void
        {
            var e:uint;
            for (var i:uint = 0, l:uint = vector1.length; i < l; i++) {
                vector1[i]++;
            }
        });
        
        _measure("Vector.<int>(" + _NUM_TIMES + ", false) の要素に加算処理", function ():void
        {
            var e:uint;
            for (var i:uint = 0, l:uint = vector2.length; i < l; i++) {
                vector2[i]++;
            }
        });
        
        _measure("Vector.<int>(" + _NUM_TIMES + ", true) の要素に加算処理", function ():void
        {
            var e:uint;
            for (var i:uint = 0, l:uint = vector3.length; i < l; i++) {
                vector3[i]++;
            }
        });
        
        // 直接参照なら高速だけど、間接にすると目も当てられなく・・
        _measure("SLL(" + _NUM_TIMES + ") の要素に加算処理", function ():void
        {
            var u : SLLUnit = unit;
            while(u = u._next){
                u._value++;
            }
        });
        
        _debug("\n結果については言及しませんので, 各自ご判断ください.");
    }
    
    private var _field:TextField;
    private var _time:uint;
    
    public function Main():void
    {
        _setup();
        _init();
    }
    
    private function _measure(title:String, func:Function, ...params):void
    {
        _time = getTimer();
        func.apply(null, params);
        _time = getTimer() - _time;
        
        _debug("[ " + title + " ] --> " + _time + " ms");
    }
    
    private function _debug(log:String):void
    {
        _field.appendText(log + "\n");
    }
    
    private function _setup():void
    {
        _field = new TextField();
        _field.width = stage.stageWidth - 40;
        _field.height = stage.stageHeight - 60;
        _field.x = 20;
        _field.y = 60;
        _field.multiline = true;
        _field.wordWrap = true;
        
        var format:TextFormat = _field.defaultTextFormat;
        format.font = "_sans";
        _field.defaultTextFormat = format;
        
        addChild(_field);
        
        var button:Sprite = new Sprite();
        button.graphics.lineStyle(1, 0xBBBBBB);
        button.graphics.beginFill(0xEEEEEE);
        button.graphics.drawRoundRect(0, 0, 100, 20, 5, 5);
        button.graphics.endFill();
        
        addChild(button);
        
        button.x = 20;
        button.y = 20;
        button.mouseChildren = false;
        button.buttonMode = true;
        
        var field:TextField = new TextField();
        field.width = 100;
        field.height = 20;
        field.htmlText = "<p align='center'><font face='_sans'>再計算</span></p>";
        
        button.addChild(field);
        
        button.addEventListener(MouseEvent.CLICK, function ():void
        {
            _field.text = "";
            _init();
        });
    }
}

}

class SLLUnit
{
    public var _next : SLLUnit;
    public var _value : int;
    
    public function SLLUnit(v : int, n : SLLUnit = null) : void { _next = n; _value = v; }
    public function get next() : SLLUnit { return _next; }
    public function set next(n : SLLUnit) : void { _next = n; }
    
    public function get value() : int{ return _value; }
    public function set value(v : int) : void { _value = v;}
    
}
