/**
 * Copyright greentec ( http://wonderfl.net/user/greentec )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/82iQ
 */

package {
    import flash.display.Bitmap;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.display.BitmapData;
    import com.bit101.components.*;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import frocessing.color.ColorHSV;
    
    /**
     * ...
     * @author ypc
     */
    
    [SWF(width=465, height=465, backgroundColor=0x000000)]
    public class FlashTest extends Sprite {
        
        public var blocks:Array = [];
        public var blocksCenter:Array = [0, 4, 8, 15];
        public var block:BitmapData;
        public var blocksize:int = 8;
    
        public var blockX:int = 465 / (blocksize * 3 + 5);
        public var blockY:int = 465 / (blocksize * 3 + 5) - 1;
        
        public var colorlist:Array = [];
        
        public var patterndata:Array = [];
        public var patternView:BitmapData;

        public var regenButton:PushButton;
        
        public var foregroundColor:uint = 0xff000000;
        public var foregroundColor_block:uint = 0x000000;
        public var backgroundColor:uint = 0x00ffffff;

        public function FlashTest() {
            // write as3 code here..
            
            //Style.setStyle(Style.DARK);
      

            regenButton = new PushButton(this, stage.stageWidth / 2, stage.stageHeight, "regen", onRegen);
            regenButton.x -= regenButton.width / 2;
            regenButton.y -= regenButton.height;
          

            initBlock();
            
            makePattern();
            
            drawPattern();
            
        }
        
        private function initBlock():void

        {

            var tempblock:Sprite = new Sprite;

            

            block = new BitmapData(blocksize, blocksize, true, backgroundColor);

            

            block.lock();

            

            //make block 0

            block.fillRect(block.rect, foregroundColor);

            blocks.push(block);

            

            

            block = new BitmapData(blocksize, blocksize, true, backgroundColor);

            //make block 1

            //block.fillRect(block.rect, backgroundColor);

            tempblock.graphics.beginFill(foregroundColor_block);

            tempblock.graphics.moveTo(0, 0);

            tempblock.graphics.lineTo(0, blocksize);

            tempblock.graphics.lineTo(blocksize, 0);

            tempblock.graphics.lineTo(0, 0);

            tempblock.graphics.endFill();

            block.draw(tempblock);

            blocks.push(block);

            

            

            block = new BitmapData(blocksize, blocksize, true, backgroundColor);

            //make block 2

            //block.fillRect(block.rect, backgroundColor);

            tempblock.graphics.clear();

            tempblock.graphics.beginFill(foregroundColor_block);

            tempblock.graphics.moveTo(int(blocksize/2), 0);

            tempblock.graphics.lineTo(0, blocksize);

            tempblock.graphics.lineTo(blocksize, blocksize);

            tempblock.graphics.lineTo(int(blocksize/2), 0);

            tempblock.graphics.endFill();

            block.draw(tempblock);

            blocks.push(block);

            

            

            block = new BitmapData(blocksize, blocksize, true, backgroundColor);

            //make block 3

            //block.fillRect(block.rect, backgroundColor);

            block.fillRect(new Rectangle(0, 0, blocksize / 2, blocksize), foregroundColor);

            blocks.push(block);

            

            

            block = new BitmapData(blocksize, blocksize, true, backgroundColor);

            //make block 4

            //block.fillRect(block.rect, backgroundColor);

            tempblock.graphics.clear();

            tempblock.graphics.beginFill(foregroundColor_block);

            tempblock.graphics.moveTo(int(blocksize/2), 0);

            tempblock.graphics.lineTo(0, int(blocksize/2));

            tempblock.graphics.lineTo(int(blocksize/2), blocksize);

            tempblock.graphics.lineTo(blocksize, int(blocksize/2));

            tempblock.graphics.lineTo(int(blocksize / 2), 0);

            tempblock.graphics.endFill();

            block.draw(tempblock);

            blocks.push(block);

            

            

            block = new BitmapData(blocksize, blocksize, true, backgroundColor);

            //make block 5

            //block.fillRect(block.rect, backgroundColor);

            tempblock.graphics.clear();

            tempblock.graphics.beginFill(foregroundColor_block);

            tempblock.graphics.moveTo(0, 0);

            tempblock.graphics.lineTo(blocksize, int(blocksize/2));

            tempblock.graphics.lineTo(blocksize, blocksize);

            tempblock.graphics.lineTo(int(blocksize/2), blocksize);

            tempblock.graphics.lineTo(0, 0);

            tempblock.graphics.endFill();

            block.draw(tempblock);

            blocks.push(block);

            

            

            block = new BitmapData(blocksize, blocksize, true, backgroundColor);

            //make block 6

            //block.fillRect(block.rect, backgroundColor);

            tempblock.graphics.clear();

            tempblock.graphics.beginFill(foregroundColor_block);

            tempblock.graphics.moveTo(int(blocksize/2), 0);

            tempblock.graphics.lineTo(int(blocksize/4), int(blocksize/2));

            tempblock.graphics.lineTo(int(blocksize/4*3), int(blocksize/2));

            tempblock.graphics.lineTo(int(blocksize/2), 0);

            tempblock.graphics.moveTo(int(blocksize/4), int(blocksize/2));

            tempblock.graphics.lineTo(0, blocksize);

            tempblock.graphics.lineTo(int(blocksize/2), blocksize);

            tempblock.graphics.lineTo(int(blocksize / 4), int(blocksize / 2));

            tempblock.graphics.moveTo(int(blocksize/4*3), int(blocksize/2));

            tempblock.graphics.lineTo(int(blocksize/2), blocksize);

            tempblock.graphics.lineTo(blocksize, blocksize);

            tempblock.graphics.lineTo(int(blocksize/4*3), int(blocksize/2));

            tempblock.graphics.endFill();

            block.draw(tempblock);

            blocks.push(block);

            

            

            block = new BitmapData(blocksize, blocksize, true, backgroundColor);

            //make block 7

            //block.fillRect(block.rect, backgroundColor);

            tempblock.graphics.clear();

            tempblock.graphics.beginFill(foregroundColor_block);

            tempblock.graphics.moveTo(0, 0);

            tempblock.graphics.lineTo(blocksize, int(blocksize/2));

            tempblock.graphics.lineTo(int(blocksize/2), blocksize);

            tempblock.graphics.lineTo(0, 0);

            tempblock.graphics.endFill();

            block.draw(tempblock);

            blocks.push(block);

            

            

            block = new BitmapData(blocksize, blocksize, true, backgroundColor);

            //make block 8

            //block.fillRect(block.rect, backgroundColor);

            block.fillRect(new Rectangle(int(blocksize / 4), int(blocksize / 4), int(blocksize / 2), int(blocksize / 2)), foregroundColor);

            blocks.push(block);

            

            

            block = new BitmapData(blocksize, blocksize, true, backgroundColor);

            //make block 9

            //block.fillRect(block.rect, backgroundColor);

            tempblock.graphics.clear();

            tempblock.graphics.beginFill(foregroundColor_block);

            tempblock.graphics.moveTo(int(blocksize / 2), 0);

            tempblock.graphics.lineTo(blocksize, 0);

            tempblock.graphics.lineTo(int(blocksize / 2), int(blocksize / 2));

            tempblock.graphics.lineTo(int(blocksize / 2), 0);

            tempblock.graphics.moveTo(0, int(blocksize / 2));

            tempblock.graphics.lineTo(0, blocksize);

            tempblock.graphics.lineTo(int(blocksize / 2), int(blocksize / 2));

            tempblock.graphics.lineTo(0, int(blocksize / 2));

            tempblock.graphics.endFill();

            block.draw(tempblock);

            blocks.push(block);

            

            

            block = new BitmapData(blocksize, blocksize, true, backgroundColor);

            //make block 10

            //block.fillRect(block.rect, backgroundColor);

            block.fillRect(new Rectangle(0, 0, int(blocksize / 2), int(blocksize / 2)), foregroundColor);

            blocks.push(block);

            

            

            block = new BitmapData(blocksize, blocksize, true, backgroundColor);

            //make block 11

            //block.fillRect(block.rect, backgroundColor);

            tempblock.graphics.clear();

            tempblock.graphics.beginFill(foregroundColor_block);

            tempblock.graphics.moveTo(0, int(blocksize / 2));

            tempblock.graphics.lineTo(blocksize, int(blocksize / 2));

            tempblock.graphics.lineTo(int(blocksize / 2), blocksize);

            tempblock.graphics.lineTo(0, int(blocksize / 2));

            tempblock.graphics.endFill();

            block.draw(tempblock);

            blocks.push(block);

            

            

            block = new BitmapData(blocksize, blocksize, true, backgroundColor);

            //make block 12

            //block.fillRect(block.rect, backgroundColor);

            tempblock.graphics.clear();

            tempblock.graphics.beginFill(foregroundColor_block);

            tempblock.graphics.moveTo(0, 0);

            tempblock.graphics.lineTo(blocksize, 0);

            tempblock.graphics.lineTo(int(blocksize / 2), int(blocksize / 2));

            tempblock.graphics.lineTo(0, 0);

            tempblock.graphics.endFill();

            block.draw(tempblock);

            blocks.push(block);

            

            

            block = new BitmapData(blocksize, blocksize, true, backgroundColor);

            //make block 13

            //block.fillRect(block.rect, backgroundColor);

            tempblock.graphics.clear();

            tempblock.graphics.beginFill(foregroundColor_block);

            tempblock.graphics.moveTo(int(blocksize / 2), 0);

            tempblock.graphics.lineTo(int(blocksize / 2), int(blocksize / 2));

            tempblock.graphics.lineTo(0, int(blocksize / 2));

            tempblock.graphics.lineTo(int(blocksize / 2), 0);

            tempblock.graphics.endFill();

            block.draw(tempblock);

            blocks.push(block);

            

            

            block = new BitmapData(blocksize, blocksize, true, backgroundColor);

            //make block 14

            //block.fillRect(block.rect, backgroundColor);

            tempblock.graphics.clear();

            tempblock.graphics.beginFill(foregroundColor_block);

            tempblock.graphics.moveTo(0, 0);

            tempblock.graphics.lineTo(int(blocksize / 2), 0);

            tempblock.graphics.lineTo(0, int(blocksize / 2));

            tempblock.graphics.lineTo(0, 0);

            tempblock.graphics.endFill();

            block.draw(tempblock);

            blocks.push(block);

            

            

            block = new BitmapData(blocksize, blocksize, true, backgroundColor);

            //make block 15

            //block.fillRect(block.rect, backgroundColor);

            blocks.push(block);

            

            

            //addChild(new Bitmap(block));

            

            block.unlock();

            //block.dispose();

        }

        

        private function makePattern():void

        {

            //data type : String = "centerblock oneblock rotation twoblock rotation"

            //  o t o

            //  t c t

            //  o t o

            

            

            var centerblock:int;

            var oneblock:int;

            var twoblock:int;

            var onepatterndata:String;

            

            //make one pattern

            for (var i :int = 0; i < blockY * blockX; i += 1)

            {
                

                
                
                do
                {
                    centerblock = blocksCenter[int(Math.random() * blocksCenter.length)];
                    
                    oneblock = int(Math.random() * blocks.length);

                    twoblock = int(Math.random() * blocks.length);
                } while((centerblock == 15 && oneblock == 15 && twoblock == 15) || (centerblock == 0 && oneblock == 0 && twoblock == 0))

                onepatterndata = String(centerblock) + " " + String(oneblock) + " " + String(int(Math.random()*4)) + " " + String(twoblock) + " " + String(int(Math.random()*4));

                

                patterndata.push(onepatterndata);

            }

        }

        

        private function drawPattern():void

        {

            //patternView = new BitmapData(465, 5 + (blocksize * 3 + 5) * (blockY), false, backgroundColor);

            patternView = new BitmapData(465, 5 + (blocksize * 3 + 5) * (blockY), true, 0xff000000);

            addChild(new Bitmap(patternView));

            //trace(patterndata);

            

            var pattern:Array;

            var oneblock:BitmapData;

            var wingblock:BitmapData;

            var mat:Matrix;

            var color:ColorHSV = new ColorHSV(int(Math.random() * 360), 0.3, 1, 1);;

            var colT:ColorTransform = new ColorTransform(1, 1, 1, 1, color.r, color.g, color.b, color.a);;

            

            //var color:ColorHSV = new ColorHSV(int(Math.random() * 360), 0.3);

            //foregroundColor = color.value;

            //trace(foregroundColor);

            

            for (var j :int = 0; j < blockY; j += 1)

            {

                for (var i:int = 0; i < blockX; i += 1)

                {

                    if (Math.random() < 0.1)

                    {

                        

                        color = new ColorHSV(int(Math.random() * 360), 0.3, 1, 1);

                        colT = new ColorTransform(0, 0, 0, 1, color.r, color.g, color.b, color.a);

                    }

                    

                    

                    //foregroundColor = color.value;

                    

                    

                    pattern = patterndata[ j * blockX + i ].split(" ");

                    //trace(pattern);

                    

                    oneblock = new BitmapData(blocksize * 3, blocksize * 3, true, color.value);

                    wingblock = new BitmapData(blocksize, blocksize * 2, true, color.value);

                    

                    //draw centerblock

                    mat = new Matrix();

                    mat.translate(blocksize, blocksize);

                    oneblock.draw(blocks[int(pattern[0])], mat);

                    //trace(int(pattern[0]));

                    

                    //draw wingblock

                    mat = new Matrix();

                    mat.rotate(pattern[2] * 90 * Math.PI / 180);

                    wingblock.draw(blocks[int(pattern[1])], mat);

                    mat = new Matrix();

                    mat.rotate(pattern[4] * 90 * Math.PI / 180);

                    mat.translate(0, blocksize);

                    wingblock.draw(blocks[int(pattern[3])], mat);

                    

                    //draw wingblocks 4 times

                    oneblock.draw(wingblock);

                    mat = new Matrix();

                    mat.rotate(90 * Math.PI / 180);

                    mat.translate(blocksize * 3, 0);

                    oneblock.draw(wingblock, mat);

                    mat = new Matrix();

                    mat.rotate(Math.PI);

                    mat.translate(blocksize * 3, blocksize * 3);

                    oneblock.draw(wingblock, mat);

                    mat = new Matrix();

                    mat.rotate(270 * Math.PI / 180);

                    mat.translate(0, blocksize * 3);

                    oneblock.draw(wingblock, mat);

                    

                    

                    mat = new Matrix();

                    mat.translate(5 + (blocksize * 3 + 5) * i, 5 + (blocksize * 3 + 5) * j); 

                    patternView.draw(oneblock, mat, colT);

                    

                }

                

                

            }

            

            //for test Matrix

            /*

            wingblock = new BitmapData(blocksize, blocksize * 2, false, backgroundColor);

            

            mat = new Matrix();

            //mat.rotate(90 * Math.PI / 180);

            mat.rotate(90 * Math.PI / 180);

            mat.rotate(90 * Math.PI / 180);

            mat.translate(200, 200);

            patternView.draw(wingblock, mat);

            

            mat = new Matrix();

            mat.translate(200, 200);

            patternView.draw(wingblock, mat);

            */

            

            

        }

        

        private function onRegen(e:*= null):void

        {

            patterndata = [];

            

            makePattern();

            

            drawPattern();

        }


    }
}