/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/82U8
 */






package
{
    import flash.display.*
    import flash.events.*
    import flash.geom.*
    import flash.ui.*
    import net.hires.debug.*
    
    [SWF(width="465", height="465", frameRate="30", backgroundColor="#FFFFFF")]
    
    public class Atomic extends Sprite
    { 
        public static const W:uint = 465  // stage.stageHeight;
        public static const H:uint = 465  // stage.stageWidth;
        public static const D:uint = 1000 // stage.stageWidth;
        public static const C:uint = 10   // 50;
        
        public function Atomic()
        {
            super();
            
            for(var i:uint = 0; i < C; i++)
                addChild(new Particle(
                    Math.random() * W,
                    Math.random() * H,
                    Math.random() * D,
                    Math.random() * Particle.MAX_RADIUS + 1
                ));
            
            stage.addEventListener(Event.ENTER_FRAME, enterFrame);
        }
        
        private function enterFrame(event:Event):void
        {
            graphics.clear();
            
            var i:uint, j:uint;
            var l:uint = Particle.list.length;
            var p1:Particle, p2:Particle;
            var d:Number, dx:Number, dy:Number, dz:Number;
            
            for(i = 0; i < l; i++)
            for(j = i + 1; j < l; j++)
            {
                p1 = Particle.list[i];
                p2 = Particle.list[j];
                dx = p1.x - p2.x;
                dy = p1.y - p2.y;
                dz = p1.z - p2.z;
                //d = dx * dx + dy * dy;
                d = (dx*dx) + (dy*dy) + (dz*dz);
                
                if(d < 2000)
                {
                    graphics.lineStyle(1, 0x000000, 1 / d * 100,true);
                    graphics.moveTo(p1.x, p1.y);
                    graphics.lineTo(p2.x, p2.y);
                    //graphics.moveTo(p1.x, p1.y);
                    //graphics.lineTo(p2.x, p2.y);
                    
                }
            }
        }
    }
}


import __AS3__.vec.Vector;
import flash.display.Shape;
import flash.events.Event;
import flash.events.TimerEvent;
import flash.utils.Timer;

internal class Particle extends Shape
{
    public static var list:Vector.<Particle> = new Vector.<Particle>();
    public var radius:Number = 0;
    
    private static const MAX_SPEED:Number = 1;
    private static const ACCELERATION:Number = 0.95;
    public static const MAX_RADIUS:Number = 5;
    
    private var speedX:Number = 0;
    private var speedY:Number = 0;
    private var speedZ:Number = 0;
    
    public function Particle( x:Number,y:Number,z:Number,radius:Number ):void
    {
        this.x = x;
        this.y = y;
        this.z = z;
        this.radius = radius;
         
        graphics.beginFill(0, 1);
        graphics.drawCircle(0, 0, radius);
        graphics.endFill();
        
        list.push(this);
        addEventListener(Event.ENTER_FRAME, enterFrame);
        
        speedX = Math.random() * MAX_SPEED * 2 - MAX_SPEED;
        speedY = Math.random() * MAX_SPEED * 2 - MAX_SPEED;
        speedZ = Math.random() * MAX_SPEED * 2 - MAX_SPEED;
    }
    
    private function enterFrame(event:Event):void
    {
        var dx:Number, dy:Number, dz:Number, c:Number;
        for each(var particle:Particle in list)
        if(particle != this)
        {
            c = Atomic.C / particle.radius / particle.radius;
            speedX += calc(x, particle.x) / c;
            speedY += calc(y, particle.y) / c;
            speedZ += calc(z, particle.z) / c;
        }
        
        //speedX += calc(x, Atomic.W) + calc(x);
        //speedY += calc(y, Atomic.H) + calc(y);
         
        speedX *= ACCELERATION;
        speedY *= ACCELERATION; 
        speedZ *= ACCELERATION; 
        x += speedX;
        y += speedY;
        z += speedY;
        
        if(x > Atomic.W)
            x -= Atomic.W;
        if(x < 0)
            x += Atomic.W;
        if(y > Atomic.H)
            y -= Atomic.H;
        if(y < 0)
            y += Atomic.H;
        if(z > Atomic.H)
            z -= Atomic.H;
        if(z < 0)
            z += Atomic.H;
    }
    
    private function calc(x1:Number, x2:Number = 0):Number
    {
        var d:Number = x1 - x2;
        return d ? 1 / d : 0;
    }
}
