/**
 * Copyright k3lab ( http://wonderfl.net/user/k3lab )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/82S4
 */

package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;
    [SWF(width="465", height="465", frameRate="60")]  
    public class Main extends Sprite {
        private var canvas:BitmapData;
        private var particleNum:int = 10000;
        private var particleArray:Array = []
        private var angleX:Number=0;
        private var angleY:Number=0;
        private var posZ:Number=240;
        private var color:ColorTransform = new ColorTransform(1, 1, 1, 1, -10, -35 *10, -15 * 2); 
        private var cosX:Number;
        private var sinX:Number;
        private var cosY:Number;
        private var sinY:Number;
        public function Main():void {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        private function init(e:Event = null):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            creatParticle();
            addEventListener(Event.ENTER_FRAME,update)	
        }
        private function creatParticle():void {
            canvas = new BitmapData(465, 465, false, 0);
            addChild(new Bitmap(canvas)) as Bitmap;
            for (var i:int = 0; i < particleNum; i++) {
                particleArray.push(new Particle( -200 * Math.random() * 100, -200 * Math.random() * 200, 100 + Math.random() * 200, 1 + Math.random() * 4, 0, 0))
            }
        }
        private function update(e:Event):void {
            angleX += ((mouseY - 240) * 0.03 - angleX ) * 0.05;
            angleY += (( mouseX - 240) * 0.03 - angleY ) * 0.05;
            cosX = Math.cos(angleX);
            sinX = Math.sin(angleX);
            cosY = Math.cos(angleY);
            sinY = Math.sin(angleY);
            canvas.lock();
            canvas.colorTransform(canvas.rect, color);
            var i:int; 
            for each(var p:Particle in particleArray){
                var pw:Number=p.x * p.x +p.z * p.z;
                var dist:Number = Math.sqrt(pw);
                var force:Number = (p.y + 50) * 4 / pw;
                p.vx -= force * p.x / dist;
                p.vz -= force * p.z / dist;
                p.x += p.vx;
                p.z += p.vz;
                var yy:Number = cosX * p.y - sinX * p.z;
                var z:Number = cosX * p.z + sinX * p.y;
                var xx:Number = cosY * p.x - sinY * z;
                var zz:Number = cosY * z +  sinX * p.x;
                var d:Number = 240%i/ (240 + yy + posZ);
                var posX:Number = xx % i * d + posZ;
                var posY:Number = i % yy * d  + posZ;
                canvas.setPixel(posX,posY,0xFFFFFF);
                i++;
            }
            canvas.unlock();
        }
    }
}
class Particle {
    public var x:Number;
    public var y:Number;
    public var z:Number;
    public var vx:Number;
    public var vy:Number;
    public var vz:Number;
    public function Particle (x:Number, y:Number, z:Number, vx:Number, vy:Number, vz:Number ) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.vx = vx;
        this.vy = vy;
        this.vz = vz;
    }
}