/**
 * Copyright flabaka ( http://wonderfl.net/user/flabaka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/81PV
 */

/*
** PV3Dのオブジェクトを、BetweenAS3で動かしてみる
*/

package{

	import flash.display.Sprite;
	import org.papervision3d.view.*
	import org.papervision3d.materials.shadematerials.*
	import org.papervision3d.objects.primitives.*
	import org.papervision3d.lights.*
	import org.libspark.betweenas3.BetweenAS3;
	import org.libspark.betweenas3.easing.*;
	import org.libspark.betweenas3.tweens.ITween;
	
	public class Main extends Sprite 
	{
		
		public function Main() 
		{
			init();
		}
		
		private function init():void
		{
			var world:BasicView = new BasicView();
			world.startRendering();
			addChild(world);

			// ライトを作成
			var light:PointLight3D = new PointLight3D(true);

			// マテリアルを作成
			var material:FlatShadeMaterial =
			new FlatShadeMaterial(light, 0x3399FF);

			// 球面(Sphere)を作成
			var sphere:Sphere = new Sphere(material, 200, 20, 20);

			// 球面を追加
			world.scene.addChild(sphere);
			
			var Twn:ITween = BetweenAS3.serial(
				BetweenAS3.bezier(sphere, { x: 300, y: 150 }, null, { x: [-250, 150], y: [150, 150] }, 2.0, Cubic.easeOut ),
				BetweenAS3.bezier(sphere, { x: 0, y: 0 }, null, { x: [550, 150], y: [0, 0] }, 2.0, Cubic.easeOut )
			);
			
			Twn.play();
			
			Twn.stopOnComplete = false;
		}
	}
}