/**
 * Copyright narutohyper ( http://wonderfl.net/user/narutohyper )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7zfk
 */

package  
{
	import flash.display.Sprite;
	import flash.display.Loader;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.BlendMode;
	import flash.text.*;
	import flash.events.MouseEvent;
	import flash.events.TimerEvent;
	import flash.events.Event;
	import flash.utils.Timer;
	import flash.system.LoaderContext;
	import flash.geom.Point;
	import flash.geom.Rectangle;

	import flash.net.*;
	import flash.utils.escapeMultiByte;
	import flash.system.Security;
	import flash.net.URLRequest; 

	/** 
	* ちょっと前に伊藤家の食卓やってた「後だしじゃんけん」です。
	* じゃんけんぽん・ぽんのタイミングで、後だしして
	* 必ず「負け」てください。
	* 「勝つかあいこ」でゲームオーバーです
	* 
	* ちなみにDS脳とれにも入っていたそうなので、脳のトレーニングになる？かもです
	*/
	
	[SWF(backgroundColor = 0xffffff, frameRate = 40, width = 465, height = 465)]
	public class main extends Sprite
	{
		public var img:Loader;

		private var text1:Sprite
		private var text2:Sprite
		private var text3:Sprite
		private var text4:Sprite
		private var spEn:Array
		private var spMy:Array

		public function main() {
			img=new Loader();
			img.load(new URLRequest('http://assets.wonderfl.net/images/related_images/3/32/3234/32342af13f8a39ccd57db593c896e2d7bd6512c0m'), new LoaderContext(true)); 
			img.contentLoaderInfo.addEventListener(Event.COMPLETE, imgComplete);

		}

		private function imgComplete(e:Event):void {

			//じゃんけん画像の切り出し
			var baseBmd:BitmapData = new BitmapData(200,200,false,0xFFFFFFFF)
			baseBmd.draw(img);

			spEn=[]
			spMy=[]

			spEn[0]=makeCard(baseBmd,465/2, 80,  0,  0,100,100,180)
			spEn[1]=makeCard(baseBmd,465/2, 80,100,  0,100,100,180)
			spEn[2]=makeCard(baseBmd,465/2, 80,  0,100,100,100,180)

			spMy[0]=makeCard(baseBmd,465/2-120,350,  0,  0,100,100)
			spMy[1]=makeCard(baseBmd,465/2,    350,100,  0,100,100)
			spMy[2]=makeCard(baseBmd,465/2+120,350,  0,100,100,100)

			text1=makeCard(baseBmd,465/2-10, 465/2-50,100,100,100,25)
			text1.rotation=-10
			text2=makeCard(baseBmd,465/2+30, 465/2-20,100,125,100,25)
			text2.rotation=20
			text3=makeCard(baseBmd,120,   140,100,150,100,25)
			text3.rotation=10
			text3.scaleX=1*1.5
			text3.scaleY=1.5*1.5
			text4=makeCard(baseBmd,485-120, 200,100,175,100,25)
			text4.rotation=-10
			text4.scaleX=1*1.5
			text4.scaleY=1.5*1.5

			var format:TextFormat=new TextFormat();
			format.color=0x000000
			format.size=13;
			format.font='_等幅';
			format.leading = 10;
			format.align = "center"
			format.bold=true;
			var guide:TextField=setTextField(format,(464-100)/2,100,100,18)
			guide.appendText('ちょっと前に伊藤家の食卓やってた\n「後出しじゃんけん」です。\n')
			guide.appendText('じゃんけんぽん・ぽんのタイミングで、後出しして\n')
			guide.appendText('必ず「負け」てください。\n')
			guide.appendText('「勝ち、あいこ」でゲームオーバーです\n')
			addChild(guide);

			format.size=14;
			format.align = "left"
			var guide2:TextField=setTextField(format,30,50,100,100,1)
			guide2.text=''
			addChild(guide2);

			format.align = "center"
			var guide3:TextField=setTextField(format,(464-100)/2,200,100,100)
			guide3.text=''
			addChild(guide3);
			guide3.visible=false


			var bt:Button = new Button('START',150)
			bt.x = stage.stageWidth/2 - bt.width/2;
			bt.y = 250;
			bt.addEventListener(MouseEvent.CLICK, init);
			addChild(bt);

			var bt2:Button = new Button('もう一度',150)
			bt2.x = stage.stageWidth/2 - bt.width/2 +100;
			bt2.y = 380;
			bt2.addEventListener(MouseEvent.CLICK, init);
			addChild(bt2);
			bt2.visible=false

			var bt3:Button = new Button('結果をTwitterに投稿する',150)
			bt3.x = stage.stageWidth/2 - bt.width/2 -100;
			bt3.y = 380;
			bt3.addEventListener(MouseEvent.CLICK, post);
			addChild(bt3);
			bt3.visible=false

			var timer:Timer=new Timer(600, 6)
			timer.addEventListener(TimerEvent.TIMER, timerHandler);
			var result:uint=0;
			var counter:uint;
			var enType:uint;
			var myType:uint;
			

			function init():void {
				bt2.visible=false
				bt3.visible=false
				guide3.visible=false
				result=0;
				gameStart()
			}


			function gameStart():void {
				guide.visible=false
				bt.visible=false
				timer.start()
				counter=0;

				text1.visible=false
				text2.visible=false
				text3.visible=false
				text4.visible=false

				for(var i:uint=0;i<3;i++) {
					spEn[i].visible=false
					spMy[i].visible=true
					spMy[i].y=350
					spMy[i].alpha=0.5
					spMy[i].addEventListener(MouseEvent.MOUSE_OVER, mouseHandler);
					spMy[i].addEventListener(MouseEvent.MOUSE_OUT, mouseHandler);
					spMy[i].addEventListener(MouseEvent.CLICK, mouseHandler);
				}
			}

			function timerHandler(e:TimerEvent):void{
				counter++;
				if(counter==1) {
					//じゃん
					text1.visible=true
				} else if(counter==2) {
					//けん
					text2.visible=true
				} else if(counter==3) {
					//ぽん
					text3.visible=true
					enType=Math.floor(Math.random()*3)
					spEn[enType].visible=true
				} else if(counter==4) {
					//ぽん
					text4.visible=true
				} else if(counter==5) {
				} else {
					myType=3
					for(var i:uint=0;i<3;i++) {
						if (spMy[i].y==300) {
							myType=i
						}
						spMy[i].removeEventListener(MouseEvent.MOUSE_OVER, mouseHandler);
						spMy[i].removeEventListener(MouseEvent.MOUSE_OUT, mouseHandler);
						spMy[i].removeEventListener(MouseEvent.CLICK, mouseHandler);
					}
					//判定
					timer.stop()
					timer.reset()
					if ((enType==0&&myType==1)||(enType==1&&myType==2)||(enType==2&&myType==0)) {
						result++
						guide2.text='ただいま\n'+result+'連敗中'
						gameStart()
					} else {
						endGame()
					}
				}
			}

			function endGame():void{

				if ((enType==myType)||(enType==myType)||(enType==myType)) {
					guide3.text='あいこですので、GameOverです'
				} else if(myType==3) {
					guide3.text='時間切れですので、GameOverです'
				} else {
					guide3.text='あなたが勝ちましたので、GameOverです'
				}

				text1.visible=false
				text2.visible=false
				text3.visible=false
				text4.visible=false

				guide3.visible=true

				bt2.visible=true
				bt3.visible=true
			}


			function mouseHandler(e:MouseEvent):void {
				if (e.type==MouseEvent.MOUSE_OVER) {
						e.target.alpha=1
				} else if (e.type==MouseEvent.MOUSE_OUT) {
						e.target.alpha=0.5
				} else if (e.type==MouseEvent.CLICK) {
						//e.target.alpha=50
					e.target.alpha=1
					e.target.y=300

					for(var i:uint=0;i<3;i++) {
						spMy[i].removeEventListener(MouseEvent.MOUSE_OVER, mouseHandler);
						spMy[i].removeEventListener(MouseEvent.MOUSE_OUT, mouseHandler);
						spMy[i].removeEventListener(MouseEvent.CLICK, mouseHandler);
					}
				}
			}



			function post(evt:MouseEvent):void {
				var st:String;
				var thisURL:String = " http://bit.ly/9ALcM1 %23wonderfl";
				if (result) {
					st = "http://twitter.com/home?status="+escapeMultiByte(result+"敗で終了。「後だしじゃんけん、負けるが勝ちよ！」") + thisURL;
				} else {
					st = "http://twitter.com/home?status="+escapeMultiByte("一度も負け無いで終了。「後だしじゃんけん、負けるが勝ちよ！」") + thisURL;
				}
				navigateToURL(new URLRequest(st));
			}



		}


		private function makeCard(bmd:BitmapData,_x:Number,_y:Number,_nx:Number,_ny:Number,_w:Number,_h:Number,_round:uint=0):Sprite {
			var tempBmd:BitmapData=new BitmapData(_w,_h,false,0xFFFFFFFF)
			var tempBm:Bitmap=new Bitmap(tempBmd,'auto',true)
			var tempSp:Sprite=new Sprite()

			tempBmd.copyPixels(bmd,new Rectangle(_nx,_ny,_w,_h),new Point(0,0))
			tempSp.addChild(tempBm)
			tempBm.scaleY=1.4
			tempBm.x=-tempBm.width/2
			tempBm.y=-tempBm.height/2
			tempSp.x=_x
			tempSp.y=_y
			tempSp.blendMode=BlendMode.MULTIPLY

			tempSp.rotation=_round
			addChild(tempSp)
			tempSp.visible=false

			return tempSp
		}


		private function setTextField(_format:TextFormat,_x:uint=0,_y:uint=0,_w:uint=100,_h:uint=40,_type:uint=0):TextField {

			var tbox:TextField=new TextField()
			tbox.x=_x;
			tbox.y=_y;
			tbox.width=_w;
			tbox.height=_h;
		
			if (_type) {
				tbox.autoSize=TextFieldAutoSize.LEFT
			} else {
				tbox.autoSize=TextFieldAutoSize.CENTER
			}
				tbox.selectable=false;
				tbox.mouseEnabled=false;
				_format.color=0x000000


			tbox.defaultTextFormat=_format

			return tbox;
		}


	}


}


import flash.display.*;
import flash.text.*;
class Button extends SimpleButton
{

	public function Button(label:String, width:int = 0):void
	{
		var up:Sprite = _buildImage(label, 0xCCCCCC, width);
		var over:Sprite = _buildImage(label, 0xFFCCCC, width);
		var down:Sprite = _buildImage(label, 0xCC9999, width);
		down.y = 1;
		super(up, over, down, up);
	}

	private static function _buildImage(label:String, color:int, width:int = 0):Sprite
	{
		var text:TextField = new TextField();
		text.defaultTextFormat = new TextFormat('Verdana', 10, 0x000000, true, null, null, null, null, TextFormatAlign.CENTER);
		text.autoSize = TextFieldAutoSize.CENTER;
		text.selectable = false;
		text.text = label;
		text.x = (width - text.width) >> 1;
		text.y = 5;
		var base:Shape = new Shape();
		var g:Graphics = base.graphics;
		g.beginFill(color);
		g.drawRect(0, 0, width, text.height + 10);
		g.endFill();
		var sp:Sprite = new Sprite();
		sp.addChild(base);
		sp.addChild(text);
		return sp;
	}
}

