/**
 * Copyright Nyarineko ( http://wonderfl.net/user/Nyarineko )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7zSW
 */

//PV3D | ３面回転スクリーン鏡面付き
//MCの中何入れよう
package {
    import flash.display.Sprite;
    import flash.display.MovieClip;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.filters.BlurFilter;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import org.papervision3d.view.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.core.effects.view.ReflectionView;
    import org.papervision3d.objects.*;
    import caurina.transitions.*;
    import flash.geom.ColorTransform;
    import flash.geom.Rectangle;
    import flash.geom.Point;
 
    [SWF(width = "465", height = "465", backgroundColor = "0", fps = "30")]
    
    public class Main extends ReflectionView {
        private var plane:Plane;
        private var animateFlg:Boolean = true;
        private var rootNode  : DisplayObject3D;
 
        private const N:uint = 1300;
        private const W:uint = 300;
        private const H:uint = 300;
        private const W1_2:uint = uint(W / 2);
        private const H1_2:uint = uint(H / 2);
        private const RECT:Rectangle = new Rectangle(0, 0, W, H);
        private const ZEROS:Point = new Point(0, 0);
        private var _head:Particle;
        private var _canvas:BitmapData;
        private var _buffer:BitmapData;
        private var _blurFilter:BlurFilter;
        private var _colorTransForm:ColorTransform;
        
        public function Main() {
            surfaceHeight = -300;
            viewportReflection.filters = [new BlurFilter(2, 2, 1)];
            setReflectionColor(0.5, 0.5, 0.7);
            rootNode = scene.addChild( new DisplayObject3D( "rootNode" ) );
            camera.x = 0;
            camera.y = 100;
            camera.z = -450;
            addEventListener(Event.ENTER_FRAME,handler);
            
            var mc1:MovieClip =  new MovieClip();
            var mct:TextField = new TextField();
            var fmt:TextFormat = new TextFormat();
            fmt.size = 20;
            fmt.font = "A-OTF 新ゴ Pro M";
            mct.defaultTextFormat = fmt;
            mct.text = "please click here!";
            mct.textColor =0xffffff;
            mct.x = 50;
            mct.width=200;
            mct.y = 140;
            var bmp1:Bitmap = new Bitmap(new BitmapData(300, 300, false, 0x0000AA));
            mc1.addChild(bmp1);
            mc1.addChild(mct);
            var mc2:MovieClip =  new MovieClip();
            mc2.addChild(new Bitmap(_canvas = new BitmapData(W, H, false, 0x000066)));
            _buffer = _canvas.clone();
            _blurFilter = new BlurFilter(16, 16, 1);
            _colorTransForm = new ColorTransform(0.95, 0.95, 0.95);
            var p:Particle = _head = new Particle();
            for (var j:uint = 0; j < N; ++j){
                p = p.next = new Particle();
            }
            addEventListener(Event.ENTER_FRAME, _update); 
            addEventListener(MouseEvent.CLICK, _reset);
            _reset();
            
            var mc3:MovieClip =  new MovieClip();
            var bmp3:Bitmap = new Bitmap(new BitmapData(300, 300, false, 0x6600AA));
            mc3.addChild(bmp3);
            
            var material1:MovieMaterial = new MovieMaterial(mc1,true,true );
            var material2:MovieMaterial = new MovieMaterial(mc2,true,true );
            var material3:MovieMaterial = new MovieMaterial(mc3,true,true );
            
            var myPlane1:Plane = new Plane(material1,300,300,12,12);
            var myPlane2:Plane = new Plane(material2,300,300,12,12);
            var myPlane3:Plane = new Plane(material3,300,300,12,12);
            for each(var i:* in myPlane1.geometry.vertices){
              i.z-=86;
            }
            for each(i in myPlane2.geometry.vertices){
              i.z-=86;
            }
            for each(i in myPlane3.geometry.vertices){
              i.z-=86;
            }
            myPlane2.rotationY+=120;
            myPlane3.rotationY+=240;
            rootNode.addChild( myPlane1 );
            rootNode.addChild( myPlane2 );
            rootNode.addChild( myPlane3 );
            rootNode.rotationY+=20;
            rootNode.x+=50;
 
            addEventListener(MouseEvent.MOUSE_DOWN,evMouseDown);
            animateFlg = false;
            Tweener.addTween(rootNode,{rotationY:rootNode.rotationY+360,time:3,
                transition:"easeInOutBack",onComplete:setAnimateFlag});
         
 
        }
        public function handler(event:Event):void
        {
            singleRender();
        }
        public function evMouseDown(event:MouseEvent):void{
            if(animateFlg){
                animateFlg = false;
                Tweener.addTween(rootNode,{rotationY:rootNode.rotationY+120,time:2,
                transition:"easeOutElastic",onComplete:setAnimateFlag});
            }
        }
        public function setAnimateFlag():void
        {
             animateFlg = true;
        }
        private function _reset(e:MouseEvent = null):void{
            var p:Particle = _head;
            var c:Number = 1;
            do {
                p.x = c;
                p.y = c;
                p.s = c % 100 * 0.1;
                p.radius = c % 2000 / 9;
                p.angle = 0;
                c ++;
            } while (p = p.next);
        }
        private function _update(e:Event):void{
            var p:Particle = _head;
            _buffer.lock();
            _buffer.fillRect(RECT, 0x000000);
            do {
                p.angle = p.angle + p.s;
                var radian:Number = p.angle * Math.PI / 180;
                p.x = W1_2 + p.radius * Math.cos(radian);
                p.y = H1_2 + p.radius * Math.sin(radian);
                _buffer.setPixel(p.x,p.y, 0x00AAFF);
            } while (p = p.next);
            _buffer.unlock();
            _canvas.lock();
            _canvas.colorTransform(RECT, _colorTransForm);
            _canvas.applyFilter(_canvas, RECT, ZEROS, _blurFilter);
            _canvas.draw(_buffer, null, null, BlendMode.ADD);
            _canvas.unlock();
        }
    }
}
internal class Particle {
    public var radius:Number;
    public var angle:Number;
    public var x:Number;
    public var y:Number;
    public var s:Number;
    public var next:Particle;
}