/**
 * Copyright siouxcitizen ( http://wonderfl.net/user/siouxcitizen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7z3j
 */

// forked from clockmaker's [PV3D] Fireworks
//視点変更の機能を追加させてもらいました
//
//自分が3D花火をいろいろな角度から見てみたかったため作成しました
//
//A、Dボタン：　カメラ視点の左右回転
//W、Sボタン：　カメラ視点の上下移動
//Fボタン：　カメラ距離の変更
//Rボタン：　カメラ視点をデフォルト視点に戻す
//
//視点変更機能追加のため、以下の自分の昔のコードを参考
//Spring01:　春をめざして。。。
//http://wonderfl.net/c/uXLa
//
package
{
    import flash.display.*;
    import flash.events.*;
    import flash.utils.*;
    import flash.geom.*;
    import flash.filters.*;
    
    import org.papervision3d.cameras.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.objects.*;
    import org.papervision3d.objects.primitives.*
    import org.papervision3d.view.*;
    import org.papervision3d.view.layer.*;
    import org.papervision3d.core.render.filter.*;
    import org.papervision3d.core.effects.*;
    import org.papervision3d.core.effects.utils.*;
    
    import caurina.transitions.Tweener;
    
    [SWF(width = "465", height = "465", frameRate = "60", backgroundColor = "#001020")]
    
    public class Main extends BasicView
    {    
        private var bfx:BitmapEffectLayer;
        
        private var cameraViewpoint : Plane //dummy Plane object for camera viewpoint setting
        private var cameraPitch: int = 90; //for camera view calculation
        private var cameraYaw : int = 270; //for camera view calculation　
        private var cameraDistStat: int = 1; //camera distance status　0～2

        /**
         * Constructor
         */
        public function Main()
        {
            // init
            super(0, 0, true, false, CameraType.FREE);
            
            // create the effect layer
            bfx = new BitmapEffectLayer(viewport, 465, 465, true, 0, BitmapClearMode.CLEAR_PRE);
            bfx.addEffect(new BitmapLayerEffect( new BlurFilter(2, 2, 1)));
            bfx.addEffect(new BitmapColorEffect(1.2, 1.15, 1.1, .95));
            bfx.drawCommand = new BitmapDrawCommand(null, new ColorTransform(1, 1, 1, 0.5), BlendMode.ADD);
            bfx.drawLayer.blendMode = BlendMode.ADD;
            viewport.containerSprite.addLayer(bfx);
            
            // update
            var timer:Timer = new Timer(2000);
            timer.addEventListener(TimerEvent.TIMER, timerHandler);
            timer.start();
            
            // create the Field
            var field:Plane = new Plane(new WireframeMaterial(0xFFFFFF, .25), 5000, 5000, 5, 5);
            field.rotationX = 90;
            scene.addChild(field);
            
            //init camera
            //camera.focus = 400;
            //camera.zoom = 1;

            //create Plane object for camera viewpoint setting
            cameraViewpoint = new Plane(new WireframeMaterial(0x000000, 0), 5, 5, 1, 1);
            cameraViewpoint.x = 0; 
            cameraViewpoint.y = 200;
            cameraViewpoint.z = 0;
            scene.addChild(cameraViewpoint, "cameraViewpoint");

            //change angle
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
            stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        /**
         * Key Press Event Handler - For each key press event, set data for Camera View calculation
         * @param    event
         */
        private function onKeyDown(event:KeyboardEvent):void{
            //A Button rotate camera position
            if (event.keyCode == 65) {
                cameraYaw = cameraYaw - 4;
                if(cameraYaw < 0) {cameraYaw = 360;}
            //D Button rotate camera position
            } else if (event.keyCode == 68) {
                cameraYaw = cameraYaw + 4;
                if(cameraYaw > 360) {cameraYaw = 0;}
            //W Button up camera position
            } else if (event.keyCode == 87) {        
                if(cameraPitch > 50) {cameraPitch = cameraPitch - 10;}
            //S Button down camera position
            } else if (event.keyCode == 83) {           
                if(cameraPitch < 90) {cameraPitch = cameraPitch + 10;}
            //F Button　change camera distance
            } else if (event.keyCode == 70) {
                cameraDistStat -= 1;
                if(cameraDistStat < 0) {cameraDistStat = 2;}
            //R Button　set camera view to dafault
            } else if (event.keyCode == 82) {
                cameraDistStat = 1;
                cameraPitch = 90; 
                cameraYaw = 270; 
            }
        }

        /**
         * EnterFrame Event Handler 
         * @param    event
         */
        private function onEnterFrame(event:Event):void{
            setFireworksCameraView(); //set camera viewpoint
            renderer.renderScene(scene, camera, viewport);
        }

        /**
         * Camera View Setter  - Calculate and Set Camera View for Fireworks
         */
        private function setFireworksCameraView():void{
            var cameraDist : int = -2100; //default distance, satatus = 1
            if (cameraDistStat == 0) {
                cameraDist = -700;
            } else if (cameraDistStat == 1) {
                cameraDist = -1400;
            } else if (cameraDistStat == 2) {
                cameraDist = -2100;
            }

            camera.x=cameraDist*Math.cos((90-cameraViewpoint.rotationY)*Math.PI/180)+cameraViewpoint.x;  
            camera.z=cameraDist*Math.sin((90-cameraViewpoint.rotationY)*Math.PI/180)+cameraViewpoint.z;
            //camera.target.x=arrow.x;
            //camera.target.y=arrow.y;
            //camera.target.z=arrow.z;
            camera.orbit(cameraPitch, cameraYaw, true, cameraViewpoint);
        }

        /**
         * Timer Handler - Give Fireworks
         * @param    event
         */
        private function timerHandler(event:TimerEvent):void
        {
            var fireworks:DisplayObject3D = createFireworks();
            fireworks.x = Math.random() * 500 - 250;
            fireworks.z = Math.random() * 500 - 250;
            fireworks.y = Math.random() * 250 + 750;
            
            scene.addChild(fireworks);
            
            Tweener.addTween(fireworks,
            {
                y          : fireworks.y  - 200,
                time       : 4,
                transition : "easeInSine"
            });
        }
        
        /**
         * Create Fireworks
         * @return Fireworks(DisplayObject3D)
         */
        private function createFireworks():DisplayObject3D
        {
            var fireworks :DisplayObject3D = new DisplayObject3D();
            
            var points:Array = getSpherePoints(300, 10);
            
            var color:uint = Math.random() * 0xFFFFFF;
            
            for (var i:int = 0; i < points.length; i++ )
            {
                var mat:ColorMaterial = new ColorMaterial(color);
                mat.doubleSided = true;
                
                var particle:Plane = new Plane(mat, 5, 5, 1, 1);
                
                fireworks.addChild(particle);
                
                bfx.addDisplayObject3D(particle);
                
                Tweener.addTween(particle,
                {
                    x     : points[i].x,
                    y     : points[i].y,
                    z     : points[i].z,
                    time  : 3 + Math.random() * .5,
                    transition : "easeOutCubic",
                    onCompleteParams : [particle],
                    onComplete : function(p:Plane):void
                    {
                        fireworks.removeChild(p);
                        bfx.removeDisplayObject3D(p);
                    }
                });
            }
            
            return fireworks;
        }
        
        /**
         * Get Points of sphere
         * @param    size
         * @param    segment
         * @return  point of shphere
         */
        private function getSpherePoints(size:int, segment:int):Array
        {
            var points:Array = [];
            
            var sphere:Sphere = new Sphere(new WireframeMaterial(), size, segment, segment);
            
            for each(var i:* in sphere.geometry.vertices)
                points.push( { x:i.x, y:i.y, z:i.z } );
            
            return points;
        }

    }
}