/**
 * Copyright gam-22 ( http://wonderfl.net/user/gam-22 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7ypA
 */

// forked from ooharabucyou's flash on 2009-12-10
package {
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import net.hires.debug.Stats;
    import flash.utils.Timer;
    
    [SWF(width=465,height=465,backgroundColor=0x000000,frameRate=30)]


    public class FlashTest extends Sprite {
        private var mx:int = 0;
        private var my:int = 0;
        private var mcnt:int = 0;
        
        private var h:Number;
        private var s:Number;
        private var v:Number;
        
    
        public function FlashTest() {
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        } 
        
        public function onEnterFrame(e: Event): void{
            
                var item:Sprite = new Sprite();

                var xpos : int = stage.mouseX;
                var ypos : int = stage.mouseY;
                var size : int = 20;

                var fillType:String = GradientType.RADIAL;
                
                h = mcnt%360;
                s = v = 1;
                var colors:Array = [ toRGB() , 0x000000];
                var alphas:Array = [100, 100];
                var ratios:Array = [0x00, 0xFF];
                var mtr:Matrix = new Matrix();
                mtr.createGradientBox(size * 2, size * 2, 0, -size, -size);
                var spreadMethod:String = SpreadMethod.PAD;

                item.graphics.beginGradientFill(fillType, colors, alphas, ratios, mtr, spreadMethod);
                item.graphics.drawCircle(0, 0, size);
                item.graphics.endFill();
                item.x = xpos;
                item.y = ypos;
                item.scaleX = item.scaleY = 1;

                item.blendMode = "add";

                addChild(item);
                
                var timer:Timer = new Timer(10, 200);
                timer.start();
                timer.addEventListener("timer", function(event:Event):void {
                    var ratio:Number = timer.currentCount / timer.repeatCount;
                    item.alpha = 1 - ratio;
                });
                timer.addEventListener("timerComplete", function(event:Event):void {
                    removeChild(item);
                });
                
                
                
                
                mx += 5;
                my += 5;
                mcnt ++;
        }
        
        public function toRGB ():uint {
        /*
            http://kawa.at.webry.info/200905/article_11.html
        */
            var rgb:uint = 0;
            var hi:uint = Math.floor(h / 60.0) % 6;
            var f:Number = h / 60.0 - hi;
            var vv:uint = Math.round(255 * v);
            var pp:uint = Math.round(255 * v * ( 1 - s ));
            var qq:uint = Math.round(255 * v * ( 1 - f * s ));
            var tt:uint = Math.round(255 * v * ( 1 - (1 - f) * s ));
            if ( vv > 255 ) vv = 255;
            if ( pp > 255 ) pp = 255;
            if ( qq > 255 ) qq = 255;
            if ( tt > 255 ) tt = 255;
            switch (hi) {
                case 0: rgb = (vv << 16) | (tt << 8) | pp; break;
                case 1: rgb = (qq << 16) | (vv << 8) | pp; break;
                case 2: rgb = (pp << 16) | (vv << 8) | tt; break;
                case 3: rgb = (pp << 16) | (qq << 8) | vv; break;
                case 4: rgb = (tt << 16) | (pp << 8) | vv; break;
                case 5: rgb = (vv << 16) | (pp << 8) | qq; break;
            }
            return rgb;
        }
    }
}
