/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7yMb
 */

package
{
    import flash.display.*;
    import flash.events.*;
    
    [SWF(frameRate=10, width=465, height=465)]
    public class Main extends Sprite
    {
        private var console :Console = new Console("> Featherweight Console\n-----------------------------------");
        private var sortArray :Array = [326.1, 404.1, 407.1, 328.1, 326.2, 326.3, 406.1, 405.1, 406.2, 406.3];
        private var newArray :Array = [];
        
        public function Main()
        {
            addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        }
        
        public function addedToStage($e:*) :void
        {
            removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
            addChild(console);
        
            init();
            
            addEventListener(Event.ENTER_FRAME, consoleTick);
        }
    
        public function init() :void
        {
            graphics.clear();
            
            graphics.beginFill(0x333333);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            
            graphics.lineStyle(4, 0x999999);
            graphics.drawRect(1, 1, 463, 463);
        }
        
        public function consoleTick($e:*) :void
        {
            var $temp :Number = 0;
            var $index :int = -1;
            
            $temp = Math.max.apply(null, sortArray);
            $index = sortArray.indexOf($temp);
            sortArray.splice($index, 1);
            newArray.push($temp);
            
            if (newArray.length == 10)
            {
                for (var $:int = 0; $<newArray.length; $++)
                {
                    console.content = newArray[$];
                    removeEventListener(Event.ENTER_FRAME, consoleTick);
                }               
            }
        }
    }
}

import flash.text.*;
import flash.events.*;

class Console extends TextField
{
    private var textFormat :TextFormat;
        
    protected var _x :Number;
    protected var _y :Number;
    protected var _font :String;
    protected var _content :String;
        
    public function Console($content:String, $x:Number = 3, $y:Number = 1, $font:String = "Helvetica")
    {
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
            
        _x = $x;
        _y = $y;
        _font = $font;
        _content = $content;
            
        multiline = true;
        autoSize = "left";
        selectable = mouseEnabled = false;
        antiAliasType = AntiAliasType.ADVANCED;
    }
        
    public function _init() :void
    {
        x = _x;
        y = _y;
        text = _content;
            
        textFormat = new TextFormat(_font, null, 0xFFFFFF);
        setTextFormat(textFormat);
    }
        
    public function addedToStage($e:Event) :void
    {
        removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
            
        _init(); 
    }
        
    public function get font() :String
    { return _font }
    public function get nWidth() :Number
    { return width }
        
    public function set font($:String) :void
    { _font = $; _init() }
    public function set content($:String) :void
    { _content += ("\n> " + $); _init() }
}