/**
 * Copyright bkzen ( http://wonderfl.net/user/bkzen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7uyg
 */

package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.TimerEvent;
    import flash.geom.ColorTransform;
    import flash.geom.Rectangle;
    import flash.utils.Timer;
    
    /**
     * Click でなんかなる。
     * @author jc at bk-zen.com
     */
    [SWF(width="465", height="465", backgroundColor="0x0", frameRate="30")]
    public class Test9 extends Sprite
    {
        private const W: int = 465;
        private const H: int = 465;
        private const W2: int = 232;
        private const H2: int = 232;
        private var TEAM: int = (Math.random() > 0.5 ? 18 : 32);
        private const TEAM_NUM: int = 30;
        private var particles: Array = [];
        private var particleV: Array = [];
        private var bmpData:BitmapData;
        private var view: Bitmap;
        private var line: Graphics;
        private var sh: Shape;
        private var cnt: int;
        private var rect:Rectangle;
        private var colorTf:ColorTransform;
        private var timer:Timer;
        
        public function Test9()
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e: Event = null): void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            //
            bmpData = new BitmapData(W, H, false, 0x0);
            view = new Bitmap(bmpData);
            var i: int, j: int, p: Particle, arr: Array, t: Number;
            while (++i <= TEAM)
            {
                j = 0;
                arr = [];
                while (++ j <= TEAM_NUM)
                {
                    p = new Particle();
                    p.x = W2;
                    p.y = H2;
                    t = i * 2 * Math.PI / TEAM + (0.128 * j * ((i % 6) * 0.2 + 0.25));
                    p.vx = Math.cos(t) * (0.5 + (TEAM_NUM - j) / TEAM_NUM * 0.5);
                    p.vy = Math.sin(t) * (0.5 + (TEAM_NUM - j) / TEAM_NUM * 0.5);
                    arr.push(p);
                }
                particles.push(arr);
            }
            sh = new Shape();
            line = sh.graphics;
            addChild(view);
            rect = bmpData.rect;
            colorTf = new ColorTransform(1, 1, 1, 1, -32, -64, -64);
            addEventListener(Event.ENTER_FRAME, onEnter);
            stage.addEventListener(MouseEvent.CLICK, onClick);
            timer = new Timer(8000);
            timer.addEventListener(TimerEvent.TIMER, onTimer);
            timer.start();
        }
        
        private function onTimer(e:TimerEvent):void 
        {
            reset();
            timer.delay = Math.random() * 3000 + 5000;
        }
        
        private function onClick(e:MouseEvent):void 
        {
            reset();
        }
        
        private function reset():void
        {
            if (cnt > 0) return;
            cnt = TEAM_NUM;
        }
        
        private function onEnter(e: Event): void 
        {
            bmpData.lock();
            bmpData.colorTransform(rect, colorTf);
            var i: int, j: int, p: Particle, arr: Array, vx: Number, vy: Number;
            line.clear();
            line.lineStyle(1, 0xFFFFFF);
            while (i < TEAM)
            {
                arr = particles[i];
                j = 0;
                p = Particle(arr[j]);
                p.x += p.vx;
                p.y += p.vy;
                line.moveTo(p.x, p.y);
                while (++j < TEAM_NUM)
                {
                    p = Particle(arr[j]);
                    p.x += p.vx;
                    p.y += p.vy;
                    line.lineTo(p.x, p.y);
                }
                if (cnt > 0) 
                {
                    p = arr.shift();
                    p.x = W2;
                    p.y = H2;
                    p.vx *= -1;
                    p.vy *= -1;
                    arr.push(p);
                }
                i++;
            }
            if (cnt > 0) cnt--;
            bmpData.draw(sh);
            bmpData.unlock();
        }
    }
}

class Particle
{
    public var x: Number = 0;
    public var y: Number = 0;
    public var vx: Number = 0;
    public var vy: Number = 0;
}