/**
 * Copyright WeRelax ( http://wonderfl.net/user/WeRelax )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7ul3
 */

package {
    import flash.display.Sprite;
    import flash.utils.Timer;
    import flash.events.TimerEvent;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    import flash.display.Stage;
    import flash.display.StageDisplayState;
    import flash.accessibility.Accessibility;

	import com.bit101.components.HSlider;
	import com.bit101.components.Label;
	import com.bit101.components.CheckBox;

    [SWF(frameRate="30")]
    public class FlashTest extends Sprite {
    		private var bolita:Bolita;
    		private var t:Timer;
    		private var t2:Timer;
    		private var velocidad:int;
    		private var n_pasos_h:Number;
    		private var n_pasos_v:Number;
    		private var paso_h:Number;
    		private var paso_v:Number;
    		private var dir_horizontal:int = 1;
    		private var dir_vertical:int = 1;
    		
    
		private var ancho:int;
		private var alto:int;
		
		private var controles:ControlBar;

        public function FlashTest() {

	    // Pantalla Completa
            stage.displayState = StageDisplayState.NORMAL;
            stage.scaleMode = "noScale";
            stage.align = "TL";
            

            // fondo
            x = 0;
            y = 0;
            ancho = stage.stageWidth;
            alto  = stage.stageHeight;
			pintarFondo();
            
            // bolita
            var r_bolita:int = 50;
            bolita = new Bolita(r_bolita);
            addChild(bolita);
            
            // salida debug
            
            // controles
			controles = new ControlBar(sliderChange_callback, slider2Change_callback, fullscreen_callback);
			controles.y = alto-20;
			addChild(controles);
			
            // animacion
            moverBolita();
        }
        
        private function pintarFondo():void
        {
			graphics.beginFill(0x000000);
			graphics.drawRect(0,0,ancho,alto);
			graphics.endFill();
		}
        
        private function sliderChange_callback(e:Event):void
        {
        		var slider:HSlider = e.currentTarget as HSlider;
        		// n_pasos_h = (slider.maximum + slider.minimum) - slider.value;
        		// paso_h = (ancho-bolita.width) / n_pasos_h;
        		paso_h = slider.value;
        	}
        	
        private function slider2Change_callback(e:Event):void
        {
        		var slider2:HSlider = e.currentTarget as HSlider;
        		bolita.redimensionar(slider2.value);
        		n_pasos_v = alto / bolita.height;
        		paso_v = (alto-bolita.height) / n_pasos_v;
        	}
        	
        	private function fullscreen_callback(e:Event):void
        	{
        		if (stage.displayState == StageDisplayState.NORMAL)
        		{
        			stage.displayState = StageDisplayState.FULL_SCREEN;
        		}
        		else
        		{
        			stage.displayState = StageDisplayState.NORMAL;
        		}
        		ancho = stage.stageWidth;
        		alto  = stage.stageHeight;
        		pintarFondo();
			controles.y = alto - 20;

        	}
        
        private function moverBolita():void
        {
        		velocidad = 1;
        		n_pasos_h = 500;
        		n_pasos_v = alto / bolita.height;
        		//paso_h = (ancho-bolita.width) / n_pasos_h;
        		paso_h = 5;
        		paso_v = (ancho-bolita.height) / n_pasos_v;
                        this.addEventListener(Event.ENTER_FRAME, moverBolita_callback);
        	}
        	
        	private function moverBolita_callback(e:Event):void
        	{
        		bolita.x += paso_h * dir_horizontal;
        		
        		if ((bolita.x + bolita.width) >= ancho && dir_horizontal == 1)
        		{
        			dir_horizontal = -1;
        		}
        		else if (bolita.x <= 0 && dir_horizontal == -1)
        		{
        			bolita.x = 0;
        			dir_horizontal = 1;
        			// bolita.y += paso_v * dir_vertical;
        			bajarBolita();
        		}
        		
        		if ((bolita.y + 2*bolita.height) > alto && dir_vertical == 1)
        		{
        			dir_vertical = -1;
        		}
        		else if (bolita.y <= 0 && dir_vertical == -1)
        		{
        			bolita.y = 0;
        			dir_vertical = 1;
        		}
        		
        	}
        	
        	private function bajarBolita():void
        	{
        		this.removeEventListener(Event.ENTER_FRAME, moverBolita_callback);
        		var paso:Number = paso_v / 9;
        		t2 = new Timer(10,1);
        		t2.addEventListener(TimerEvent.TIMER, function(e:TimerEvent):void {bajarBolita_callback(10, paso);});
        		t2.start();
        	}
        	
        	private function bajarBolita_callback(contador:int, paso:Number):void
        	{
        		bolita.y += paso*dir_vertical;
        		if (contador > 0)
        		{       			
        			t2 = new Timer(10,1);
        			t2.addEventListener(TimerEvent.TIMER, function(e:TimerEvent):void {bajarBolita_callback(--contador, paso);});
        			t2.start();
        		}
        		else
        		{
        			this.addEventListener(Event.ENTER_FRAME, moverBolita_callback);
        		}
        	}
        		
	}
}


import flash.display.Sprite;
import com.bit101.components.HSlider;
import com.bit101.components.Label;
import com.bit101.components.CheckBox;

class Bolita extends Sprite {
	public function Bolita(radio:int)
	{
		graphics.beginFill(0xFFFFFF);
		graphics.drawCircle(radio,radio,radio);
	}
	
	public function redimensionar(radio:int):void
	{
		graphics.clear();
		graphics.beginFill(0xFFFFFF);
		graphics.drawCircle(radio,radio,radio);
	}
}

class ControlBar extends Sprite
{
	private var slider:HSlider;
	private var slider2:HSlider;
	private var slider3:HSlider;
	private var etiqueta:Label;
	private var etiqueta2:Label;
	private var check:CheckBox;
	
	public function ControlBar(sliderChange_callback:Function, slider2Change_callback:Function, fullscreen_callback:Function)
	{
		
			check = new CheckBox(this, 0, 5, "Pantalla Completa", fullscreen_callback);	
			
		    slider = new HSlider(this, 195, 5, sliderChange_callback);
            slider.setSliderParams(0.5,20,5);
            etiqueta = new Label(this, 150, 0);
            etiqueta.text = "Velocidad: ";
         	        	
            slider2 = new HSlider(this, 360, 5, slider2Change_callback);
            slider2.setSliderParams(5,90,50);
            etiqueta2 = new Label(this, 320, 0);
            etiqueta2.text = "Tamaño: ";
	}
}