/**
 * Copyright yinaak ( http://wonderfl.net/user/yinaak )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7uYL
 */

// forked from daniwell's Line Art
package {
    import flash.display.Sprite;
    import flash.events.Event;
    
    [SWF(backgroundColor = "0x000000", frameRate = "30", width = "465", height = "465")]
    public class LineArt extends Sprite {
        
        private var _lines :/*Line*/Array = [];
        
        public function LineArt() { addEventListener(Event.ENTER_FRAME, _enterFrame); }
        
        /* ENTER FRAME */
        private function _enterFrame ( evt :Event ) :void {
            
            // クリア & 背景描画
            graphics.clear();
            graphics.beginFill(0x0); graphics.drawRect(0, 0, 465, 465); graphics.endFill();
            
            // Line 生成
            _lines.push(new Line());
            
            // Line 更新
            for (var i :int = 0; _lines[i]; i++) if (_lines[i].update(graphics)) _lines.shift();
        }
    }
}
import flash.display.Graphics;
import flash.utils.getTimer;

class Line {
    /* 分割数 */
    private const SEP :int = 12;
    
    private var _nstart :int;
    private var _nend   :int;
    
    private var _offsetY :int;
    
    private var _dw :Number;
    private var _dh :Number;
    private var _dd :Number;
    
    private var _thick  :int;
    private var _speed :int;
    
    private var _color:uint;
    
    public function Line () {
        _nstart = _nend = 0;
        _offsetY = Math.random()*465;
        
        _dw = 465 / SEP;
        _dh = Math.random() * 77 + 15;
        _dd = Math.random() * 0.3 + 0.1;
        
        _thick = Math.random() * 4;
        _speed = Math.random() * 200 + 300;
        
        //_color = int(Math.random() * 0xffffff); 
        //_color = hsv(((getTimer()*.01)),1.0,1.0);
        _color = hsv(_offsetY/465*360,1.0,1.0);
    }
    private static function h0(v:int,p:int,q:int,t:int):uint
    {
        return v << 16 | t << 8 | p;
    }
    private static function h1(v:int,p:int,q:int,t:int):uint
    {
        return q << 16 | v << 8 | p;
    }
    private static function h2(v:int,p:int,q:int,t:int):uint
    {
        return p << 16 | v << 8 | t;
    }
    private static function h3(v:int,p:int,q:int,t:int):uint
    {
        return p << 16 | q << 8 | v;
    }
    private static function h4(v:int,p:int,q:int,t:int):uint
    {
        return t << 16 | p << 8 | v;
    }
    private static function h5(v:int,p:int,q:int,t:int):uint
    {
        return v << 16 | p << 8 | q;
    }
    private static var DIC_H:Array = [h0,h1,h2,h3,h4,h5];
    public function hsv(hue:int, saturation:Number, value:Number):uint
    {
        var f:Number = hue / 60;
        var hi:int = f%6;
        f -=(f>>0);
        return DIC_H[hi](value *= 255,value * (1 - saturation),value * (1 - f * saturation),value * (1 - (1 - f) * saturation));
    }
    
    public function update ( g :Graphics ) :Boolean {
        
        if (_nend < SEP) _nend ++; else _nstart ++;        
        // 終了
        if (SEP == _nstart) return true;
       
        g.lineStyle(_thick, _color, 0.9);
        
        var px :int,py:int;
        var n:Number = getTimer() / _speed;
        for (var i :int = _nstart; i <= _nend; i ++) {
            px= 465 - _dw * i;
            py = Math.sin( n + i * _dd) * _dh + _offsetY;
             
            if (i != _nstart) g.lineTo(px, py); else g.moveTo(px, py);
        }
        return false;
    }
}