/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7u6m
 */

package {
    import flash.display.*;
    import flash.text.*;
    //[SWF(backgroundColor=0, width=465, height=465)]
    public class FlashTest extends Sprite {
        private var node1:node = new node();
        public var text1:TextField;
        public var wheel:Wheel = new Wheel();
        public function FlashTest() {
            
            // write as3 code here..
            
            text1 = new TextField();
            node1.map.addChild(text1);
            text1.x = 240;
            text1.y = 150;
            text1.text = "0";
            
            //ダイヤル設定
            wheel.x = 220;    wheel.y = 220;//　表示位置
            //wheel.scaleX = 2;
            node1.map.addChild(wheel);
            wheel.max = 100;
            //wheel.enabled = false;
            wheel.addEventListener(CompoEvent.CHANGE, change);
            
            //wheel.addEventListener(Event.ENTER_FRAME,change);
            // write as3 code here..
            addChild(node1);
            var s:Shape = new Shape();
            s.graphics.beginFill(0x00ffff);
            s.graphics.drawRect(0,0,50,50);
            s.graphics.endFill();
            node1.map.addChild(s);            
        }
        private function change(evt:CompoEvent):void {
            text1.text = String(wheel.turn);
            text1.appendText(" "+String(wheel.value));            
            
        }
    }
}
    import flash.geom.Point;
    import caurina.transitions.Tweener;
    import flash.display.*;
    import flash.text.*;
    import flash.events.*;
    import flash.ui.*;
    import flash.utils.*;
    import flash.net.navigateToURL;
    import flash.net.URLRequest;
    import flash.filters.*;
    import com.actionsnippet.qbox.*;

class node extends Sprite{
        
        private var scale:Number = 1;
        
        private var wheel:int;//ホイール回転量
        private var zoom:Number = 1.0;//拡大率
        public var map:Sprite;//フィールド
        
        private var mapFocusX:Number=0;
        private var mapFocusY:Number=0;
        private var scrFocusX:int=0; 
        private var scrFocusY:int=0; 
        private var mX:int=0; 
        private var mY:int=0; 
        
        private var scalingPanel:Sprite;
        private var base:Sprite;
              
        private var mapscale:int=0;
        
        private var obj:Sprite;//ノード
        
        private var onDrag:Boolean;//ドラッグフラグ
        
        private var dragPanel:Shape = new Shape();
        
       
        
        
        //コンストラクタ 
        public function node():void{
            
            //カーソル位置描画
            scalingPanel = new Sprite();//ズーム中心 
            scalingPanel.graphics.lineStyle(1,0x00ff00,1);
            scalingPanel.graphics.moveTo(-100,0);
            scalingPanel.graphics.lineTo(100,0);
            scalingPanel.graphics.moveTo(0,-100);
            scalingPanel.graphics.lineTo(0,100);
            addChild(scalingPanel);
            
            
            //マップ基準座標
            base = new Sprite();
            
            base.graphics.lineStyle(1,0xff0000,1);
            base.graphics.moveTo(-100,0);
            base.graphics.lineTo(100,0);
            base.graphics.moveTo(0,-100);
            base.graphics.lineTo(0,100);
            
            scalingPanel.addChild(base);
            
            //マップ上への配置
            map = new Sprite();
            map.addEventListener(MouseEvent.MOUSE_DOWN,down1);
            map.addEventListener(MouseEvent.MOUSE_UP,up1);

            //addEventListener(MouseEvent.MOUSE_UP, onMouseUp);//マウスアップ
            
            //addEventListener(FocusEvent.FOCUS_IN,onFocus);

            addEventListener(MouseEvent.MOUSE_WHEEL,on_wheel);//ホイール操作 
            addEventListener(Event.ENTER_FRAME, onFrame);//メインループ
 
            base.addChildAt(map,0); 
            map.addChild(dragPanel);
            
            aaaa();
        }
        
        private function onFocus(e:FocusEvent):void{
            addEventListener(FocusEvent.FOCUS_OUT,outFocus);
            removeEventListener(FocusEvent.FOCUS_IN,onFocus);
            map.addEventListener(MouseEvent.MOUSE_DOWN,down1);
            map.addEventListener(MouseEvent.MOUSE_UP,up1);
        }
        private function outFocus(e:FocusEvent):void{
            removeEventListener(FocusEvent.FOCUS_OUT,outFocus);
            addEventListener(FocusEvent.FOCUS_IN,onFocus);
            map.removeEventListener(MouseEvent.MOUSE_DOWN,down1);
            map.removeEventListener(MouseEvent.MOUSE_UP,up1);
        }


        
  
        //マップドラッグ
        private function down1(event:MouseEvent):void{
            wheel=0;
      　    event.currentTarget.startDrag();
      　    addEventListener(MouseEvent.MOUSE_MOVE,onMove);
      　    event.stopPropagation();//イベントの伝播を止める
        }
        private function up1(event:MouseEvent):void{
            event.currentTarget.stopDrag();
            removeEventListener(MouseEvent.MOUSE_MOVE,onMove);
            event.stopPropagation();//イベントの伝播を止める
        }
        
        private function onMove(e:MouseEvent):void{
            aaaa();

        }



        
        //ホイール操作
        private function on_wheel(event:MouseEvent):void{
            wheel += event.delta;    
        }
        

        
        //メインループ
        private function onFrame(e:Event):void {
    
            on_zoom();
            if(stage.displayState == StageDisplayState.FULL_SCREEN){
                if(stage.mouseY < 10)map.y -= (stage.mouseY-10)/zoom;
                else if(this.root.loaderInfo.height-10 < stage.mouseY){
                    map.y -= (10+stage.mouseY-this.root.loaderInfo.height)/zoom;                    
                }
                if(stage.mouseX < 10)map.x -= (stage.mouseX-10)/zoom/10;
                else if(this.root.loaderInfo.width-10 < stage.mouseX){
                    map.x -= (10+stage.mouseX-this.root.loaderInfo.width)/zoom/10;                    
                }

            }

     
        }
        
        
        //マップスクロール基準点の更新
        private function aaaa():void{
            if(0<=wheel){
                mX = mouseX; mY = mouseY;//カーソル位置
                //ズーム中心
                scalingPanel.x = mouseX; scalingPanel.y = mouseY; 
                //マップ位置
                base.x -= (mX-scrFocusX)/zoom; base.y -= (mY-scrFocusY)/zoom;
                //フォーカス位置
                scrFocusX = mX; scrFocusY = mY;
            }
            else{
                mX = this.root.loaderInfo.width/2; mY = this.root.loaderInfo.height/2;//カーソル位置
                //ズーム中心
                scalingPanel.x =this.root.loaderInfo.width/2; scalingPanel.y = this.root.loaderInfo.height/2; 
                //マップ位置
                base.x -= (mX-scrFocusX)/zoom; base.y -= (mY-scrFocusY)/zoom;
                //フォーカス位置
                scrFocusX = mX; scrFocusY = mY;
            }

            //フィールドドラッグ用
            dragPanel.graphics.clear();
            dragPanel.graphics.beginFill(0xff0000,0);
            dragPanel.graphics.drawCircle(-(map.x+map.parent.x)/map.scaleX,-(map.y+map.parent.y)/map.scaleY,600/map.scaleX);
            dragPanel.graphics.endFill();
        }

        
        
        private function on_zoom():void{
            if(wheel != 0){
                aaaa();//基準点更新
                
                if(wheel < 0){
                    zoom *= 1+(0.005*wheel);
                }
                else if(0 < wheel){
                    zoom *= 1+(0.005*wheel);
                }
                
                
                if(2 < zoom){

                    map.scaleX *= 2;
                    map.scaleY *= 2;
                    zoom /= 2;
                    map.x += map.x+base.x;
                    map.y += map.y+base.y;
                    
                    mapscale--;
                
                }
                else if(zoom < 1.0){
             
                    map.x -= (map.x+base.x)/2;
                    map.y -= (map.y+base.y)/2;
                    zoom *= 2;
                    map.scaleX /= 2;
                    map.scaleY /= 2;
                    
                    mapscale++;
                    
                }
                scalingPanel.scaleX = zoom;
                scalingPanel.scaleY = zoom;        
            }
          
        }
   

        //画面モード切り替え
        private function screenMode():void{
            if(stage.displayState == StageDisplayState.FULL_SCREEN){
                stage.displayState = StageDisplayState.NORMAL;//元に戻す
            }
            else{
                stage.displayState = StageDisplayState.FULL_SCREEN;//フルスクリーンモード
            }        
        }

        
    }
    
    
    
import flash.display.Sprite;
import flash.display.Shape;
import flash.filters.DropShadowFilter;
import flash.geom.ColorTransform;
import flash.events.Event;
import flash.events.MouseEvent;


//ホイールインターフェース
class Wheel extends Sprite {
    private var base:Sprite;
    private var thumb:Sprite;
    private var point:Shape;
    private var hit:Shape;
    private var zeroPos:Shape;
    //カラー設定
    public var bColor:uint = 0xFFFFFF;//ホイールの色
    private var cColor:uint = 0x999999;//つまみの色
    private var sColor:uint = 0x000000;//影の色
    private var pColor:uint = 0x666666;//つまみの色（ロールオーバー時）
    private var offColor:uint = 0xCCCCCC;//つまみの色（操作不可）
    private var cColorTrans:ColorTransform;
    private var pColorTrans:ColorTransform;
    private var offColorTrans:ColorTransform;
    //プロパティ
    
    private var zero:Number = 0;
    private var angle:Number = 0;//つまみの角度
    private var shade:DropShadowFilter;//影
    private var initValue:Number = 0;//値
    public var value:Number = 0;
    public var turn:int = 0;//回転数
    private var _enabled:Boolean = true;
    public var size:uint = 30;//描画サイズ
    public var max:Number = 100;//最大値
    public var dec:Boolean = false;//小数点以下を求める場合はtrue

    //コンストラクタ
    public function Wheel() {
        shade = new DropShadowFilter(1, 90, sColor, 0.4, 4, 4, 2, 3, false, false);
        cColorTrans = new ColorTransform();
        cColorTrans.color = cColor;
        pColorTrans = new ColorTransform();
        pColorTrans.color = pColor;
        offColorTrans = new ColorTransform();
        offColorTrans.color = offColor;
        
        base = new Sprite();
        thumb = new Sprite();
        point = new Shape();
        hit = new Shape();
        
        addChild(base);
        base.addChild(thumb);
        thumb.addChild(point);//ホイールのつまみ部分
        thumb.addChild(hit);
        addChild(thumb);

        draw();
    }

    //描画
    private function draw():void {
        //位置関係
        base.x = thumb.x = 0;
        base.y = thumb.y = 0;
        createDonut(base, size+size/3, size-size/3);//ホイール描画
        base.filters = [shade];
        point.x = size;
        createCircle(point, size/6, bColor, 1);//つまみの描画
        hit.x = size;
        createCircle(hit, size/3, bColor, 0);//操作エリア
        reset();
        _up();
        enabled = true;
        thumb.mouseChildren = false;//子に対してマウスイベント無効
    }
    
    //イベント：ロールオーバー
    private function rollOver(evt:MouseEvent):void {
        _over();
    }
    
    //イベント：ロールアウト
    private function rollOut(evt:MouseEvent):void {
        _up();
    }
    
    //イベント：マウスダウン
    private function press(evt:MouseEvent):void {
        _down();
        thumb.addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
        stage.addEventListener(MouseEvent.MOUSE_UP, releaseOutside, false, 0, true);
        stage.addEventListener(MouseEvent.MOUSE_MOVE, change, false, 0, true);
        stage.addEventListener(Event.MOUSE_LEAVE, leave, false, 0, true);
        evt.stopPropagation();
    }
    
    //イベント：マウスアップ
    private function release(evt:MouseEvent):void {
        _up();
        checkValue();
        var e:CompoEvent = new CompoEvent(CompoEvent.SELECT, value);
        dispatchEvent(e);
        thumb.removeEventListener(MouseEvent.MOUSE_UP, release);
        stage.removeEventListener(MouseEvent.MOUSE_UP, releaseOutside);
        stage.removeEventListener(MouseEvent.MOUSE_MOVE, change);
        stage.removeEventListener(Event.MOUSE_LEAVE, leave);
    }
    //エリア外でボタンリリース
    private function releaseOutside(evt:MouseEvent):void {
        _up();
        checkValue();
        var e:CompoEvent = new CompoEvent(CompoEvent.SELECT, value);
        dispatchEvent(e);
        thumb.removeEventListener(MouseEvent.MOUSE_UP, release);
        stage.removeEventListener(MouseEvent.MOUSE_UP, releaseOutside);
        stage.removeEventListener(MouseEvent.MOUSE_MOVE, change);
        stage.removeEventListener(Event.MOUSE_LEAVE, leave);
    }
    
    
    private function leave(evt:Event):void {
        _up();
        checkValue();
        var e:CompoEvent = new CompoEvent(CompoEvent.SELECT, value);
        dispatchEvent(e);
        thumb.removeEventListener(MouseEvent.MOUSE_UP, release);//リリースイベント解除
        stage.removeEventListener(MouseEvent.MOUSE_UP, releaseOutside);//エリア外リリースイベント解除
        stage.removeEventListener(MouseEvent.MOUSE_MOVE, change);//カーソル移動イベント解除
        stage.removeEventListener(Event.MOUSE_LEAVE, leave);//エリア外移動イベント解除
    }
    
    
    private function _up():void {
        point.transform.colorTransform = cColorTrans;
    }
    private function _over():void {
        point.transform.colorTransform = pColorTrans;
    }
    private function _down():void {
        point.transform.colorTransform = pColorTrans;
    }
    private function _off():void {
        point.transform.colorTransform = offColorTrans;
    }
    
    //ダイヤル操作
    private function change(evt:MouseEvent):void {
        _down();
        thumb.rotation = Math.atan2(base.mouseY, base.mouseX)/Math.PI*180;
        evt.updateAfterEvent();//画面更新
        checkValue();
        var e:CompoEvent = new CompoEvent(CompoEvent.CHANGE, value);
        dispatchEvent(e);//イベント発生
    }
    
    //ダイヤルの角度から値を決定
    private function checkValue():void {
        var prev:Number = value;
        value = (((thumb.rotation+450-angle)%360)/360)*max;
        //回転数
        if(prev < max/2){
            if(max - max/3 < value)turn--;
        }
        else{
            if(value < max/3)turn++;
        }

 
        if(dec == false)value = Math.round(value);//小数点以下の扱い
    }
    
    
    //操作受付の状態　true:可　false:不可
    public function get enabled():Boolean {
        return _enabled;
    }
    
    public function set enabled(param:Boolean):void {
        _enabled = param;
        if (!_enabled) _off();
        thumb.buttonMode = _enabled;
        thumb.mouseEnabled = _enabled;
        thumb.useHandCursor = _enabled;
        
        if (_enabled) {//操作可
            thumb.addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
            thumb.addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
            thumb.addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true);
        } else {//操作不可
            thumb.removeEventListener(MouseEvent.MOUSE_OVER, rollOver);
            thumb.removeEventListener(MouseEvent.MOUSE_OUT, rollOut);
            thumb.removeEventListener(MouseEvent.MOUSE_DOWN, press);
        }
    }
    
    //状態更新
    public function reset():void {
        value = initValue;
        thumb.rotation = value - 90 + zero;
    }
    
    //描画１
    private function createCircle(target:Shape, r:uint, color:uint, alpha:Number):void {
        target.graphics.beginFill(color, alpha);
        target.graphics.drawCircle(0, 0, r);
        target.graphics.endFill();
    }
    
    //描画２
    private function createDonut(target:Sprite, outer:uint, inner:uint):void {
        target.graphics.beginFill(bColor);
        target.graphics.drawCircle(0, 0, outer);//外縁
        target.graphics.drawCircle(0, 0, inner);//内縁
        target.graphics.endFill();
    }

}

//イベント
import flash.events.Event;
class CompoEvent extends Event {
    public static const SELECT:String = "select";
    public static const CHANGE:String = "change";
    public var value:*;

    public function CompoEvent(type:String, value:*) {
        super(type);
        this.value = value;
    }

    public override function clone():Event {
        return new CompoEvent(type, value);
    }

}