/**
 * Copyright hacker_zen0qr6h ( http://wonderfl.net/user/hacker_zen0qr6h )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7u5g
 */

// forked from kotobuki's Japanino Twitter Example
// D6ポートにドアスイッチをつないで、開いた回数をツイートします
// forked from kotobuki's Japanino Test
// 1. JapaninoPOVFirmataをJapaninoにアップロードする
// add D6ポートの接点の極性を逆にしておきます。
// 具体的には　ループ内で判定を　LOW → HIGH とします。　この部分→if (digitalRead(switchPin) == HIGH)　
// 2. Funnel Serverを起動してボードタイプとシリアルポートを選択する
//    （2回目以降はFunnel Serverを起動するだけでOKです）
// 3. 右側のボタンをクリックしてこのコンテンツを再生する
// 4. いきなりカウントダウンがスタートしますので、D6-GNDにはドアスイッチを先につないでおきます。
// 5. １０分間でタイムアウトしたら、Twitter投稿用のボタンが表示されます
// その後、カウントダウンが再開します
// 6. このサンプルからFORKして、もっと面白いコンテンツに発展させて
//    ください:-)
// 
// 参考：セットアップ方法の詳細に関しては、以下のページでの説明を
// 参照してください。
// 
// 大人の科学マガジンVol.27
// http://otonanokagaku.net/magazine/vol27/
// 
// wonderfl x japanino
// http://wonderfl.net/event/japanino/
// 
// 注意：光残像キットは、あまり激しく操作すると壊れてしまうことが
// ありますので注意してください。

package {
    import com.bit101.components.*;

    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.events.TimerEvent;
    import flash.utils.Timer;
    import com.bit101.components.*;
    import flash.display.*;
    import flash.events.*;
    import flash.net.*
    import flash.utils.*;

    import funnel.*;

    public class JapaninoTwitterExample extends Sprite {
        // 制限時間
        private static const TIME_LIMIT:int = 600;

        // Japanino
        private var _japanino:Arduino;

        // カウントを表示するためのテキストフィールド
        private var _countLabel:Label;

        // 残りの時間を表示するためのテキストフィールド
        private var _remainingTimeLabel:Label;

        // 光残像キットのハンドルを回転させた回数
        private var _count:int = 0;

        // 残り時間
        private var _remainingTime:int = TIME_LIMIT;

        // カウントダウン用のタイマ
        private var _countdownTimer:Timer;

        // Twitter投稿用ボタン
        //private var _twitterButton:TwitterButton;
        
        // for teitter use
        private var _text:String;
        private var _footer:String;
        private var post:String;
        private var linkURL:String;
        private var hashTag:String;



        public function JapaninoTwitterExample() {
            // Japaninoのインスタンスを生成
            _japanino = new Arduino(Arduino.FIRMATA);

            // カウントを表示するためのテキストフィールドを生成
            _countLabel = new Label(this, 100, 200);
            _countLabel.text = "Waiting...";
            _countLabel.scaleX = 2;
            _countLabel.scaleY = 2;
            addChild(_countLabel);

            // 残り時間を表示するためのテキストフィールドを生成
            _remainingTimeLabel = new Label(this, 100, 160);
            _remainingTimeLabel.scaleX = 2;
            _remainingTimeLabel.scaleY = 2;
            addChild(_remainingTimeLabel);

            // Japaninoの準備が完了した時に発生するイベントに対するイベントリスナをセット
            _japanino.addEventListener(FunnelEvent.READY, onReady);

            // Twitter投稿ボタンを作成し、最初は隠しておく
            //_twitterButton = new TwitterButton("http://wonderfl.net/c/7u5g/", 
            //                                   this, 100, 250, "", 
            //                                   "#wonderfl #japanino");
            //_twitterButton.visible = false;
        }

        // Japaninoの準備ができると呼ばれる
        private function onReady(event:FunnelEvent):void {
            // Japaninoの準備ができたら、10秒間をカウントダウンするタイマを生成してスタート
            // タイムアウトが発生した時にonTimeoutを呼び出す
            _countdownTimer = new Timer(1000, TIME_LIMIT);
            _countdownTimer.addEventListener(TimerEvent.TIMER, onTick);
            _countdownTimer.addEventListener(TimerEvent.TIMER_COMPLETE, onTimeout);
            _countdownTimer.start();

            // 転送するパターン（W x Jのつもりです）を用意する（15桁x7行）
            // ここでは二進数で記述しているがそれ以外の方法でも構わない
            var pattern:Array = [
                parseInt("1111111", 2),
                parseInt("0100000", 2),
                parseInt("0011000", 2),
                parseInt("0100000", 2),
                parseInt("1111111", 2),
                parseInt("0000000", 2),
                parseInt("1010000", 2),
                parseInt("0100000", 2),
                parseInt("1010000", 2),
                parseInt("0000000", 2),
                parseInt("0000001", 2),
                parseInt("1000001", 2),
                parseInt("1000001", 2),
                parseInt("0111111", 2),
                parseInt("0000001", 2),];

            // パターンをカスタムのメッセージとしてJapaninoに転送する
            _japanino.sendSysexMessage(0x10, pattern);

            // JapaninoのFIRMATA_STRINGイベントに対するイベントリスナをセット
            _japanino.addEventListener(FunnelEvent.FIRMATA_STRING, onMessage);

            // 残り時間の表示とカウンタの表示を更新する
            _remainingTimeLabel.text = "Remaining Time: " + TIME_LIMIT;
            _countLabel.text = "Open the door";
        }

        // Japaninoからメッセージを受信すると呼ばれる
        private function onMessage(event:FunnelEvent):void {
            // メッセージが"!"でかつ残り時間があれば
            if (event.message == "!" && (_remainingTime > 0)) {
                // カウントを増やしてテキストフィールドの表示を更新
                _count++;
                _countLabel.text = "Count: " + _count;
            }
        }

        // カウントダウン用のタイマでイベントが発生すると呼ばれる
        private function onTick(e:TimerEvent):void {
            // 残り時間を1つずつ減らして表示を更新する
            _remainingTime = _countdownTimer.repeatCount 
                             - _countdownTimer.currentCount;
            trace(_remainingTime);
            _remainingTimeLabel.text = "Remaining Time: " + _remainingTime;
        }

        private function onTimeout(e:TimerEvent):void {
            // Japaninoからのイベントを受取らないようにリスナを削除
            _japanino.removeEventListener(FunnelEvent.FIRMATA_STRING, onMessage);

            // 転送するパターン（OVERのつもりです）を用意する（15桁x7行）
            // ここでは二進数で記述しているがそれ以外の方法でも構わない
            var pattern:Array = [
                parseInt("0111110", 2),
                parseInt("1000001", 2),
                parseInt("0111110", 2),
                parseInt("0000000", 2),
                parseInt("0011111", 2),
                parseInt("1100000", 2),
                parseInt("0011111", 2),
                parseInt("0000000", 2),
                parseInt("1111111", 2),
                parseInt("1001001", 2),
                parseInt("1001001", 2),
                parseInt("0000000", 2),
                parseInt("1111111", 2),
                parseInt("0010001", 2),
                parseInt("1101110", 2),];

            // パターンをカスタムのメッセージとしてJapaninoに転送する
            _japanino.sendSysexMessage(0x10, pattern);

            // 投稿用ボタンの投稿用文字列を更新して表示する
            //_twitterButton.changeText("冷蔵庫を" + _count + "回開けました。");
            //_twitterButton.visible = true;
            linkURL = "http://wonderfl.net/c/7u5g/";
            hashTag = "#wonderfl #japanino";
            _text = "冷蔵庫を10分間に" + _count + "回開けました。";
            _footer = " " + linkURL + " " + hashTag;
            post = _text + _footer; // 投稿する文章
            navigateToURL(new URLRequest("http://twitter.com/home?status=" 
                                     + escapeMultiByte(post)), "_blank");
            // restart timer
           _countdownTimer.reset();
           _count = 0;
           _countLabel.text = "Count: " + _count;
           _remainingTime = TIME_LIMIT;
           //_countdownTimer.addEventListener(TimerEvent.TIMER, onTick);
           //_countdownTimer.addEventListener(TimerEvent.TIMER_COMPLETE, onTimeout);
           _countdownTimer.start();

        }
    }
}

