/**
 * Copyright nicoptere ( http://wonderfl.net/user/nicoptere )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7u5Z1
 */

package 
{
	import flash.display.Sprite;
	import flash.geom.Point;
	/**
	 * http://weblogs.java.net/blog/malenkov/archive/2009/02/triangular_tile.html
	 * https://malenkov.dev.java.net/20090225/triangle.java
	 * 
	 * @author Nicolas Barradeau
	 * http://en.nicoptere.net
	 */
	public class Triangular extends Sprite
	{
		
		static private var S:Number = 40;
		static private var H:Number = S * 1.5;
		static private var R:Number = S * Math.cos(Math.PI / 6.0);
		static private var W:Number = R * 2;
		static private var points:Vector.<Point>;
		
		public function Triangular(){}
			
		static public function distribute( size:Number = 25, width:Number = 250, height:Number = 250, jitter:Number = 0 ) : Vector.<Point>
		{
			
			S = size;
			H = S * 1.5;
			R = S * Math.cos(Math.PI / 6.0);
			W = R * 2;
				
			width += R;
			height += H;
			
			points = new Vector.<Point>();
			var i:int = 0;
			var j:int = 0;
			
			var y:Number = 0.0;
			while (y < height) 
			{
				
				var x:Number = i * R - R * j;
				while (x < width) 
				{
					var up:Boolean = (i & 1) == 1;
					points.push( 	new Point( (x - R), (up ? y : y + H) ),
									new Point(  x, 		(up ? y + H : y) ),
									new Point( (x + R), (up ? y : y + H) ) );
					
					x += R;
					i++;
				}
				y += H;
				j++;
				i = j - 1;
			}
			
			fRemoveDup( points );
			
			if( jitter != 0 ) jitterPoints( jitter );
			
			return points;
			
		}
		
		static private function fRemoveDup(ac: Vector.<Point>) : void
		{
			var i:int, j : int;
			for (i = 0; i < ac.length; i++)
			{
				for (j = i+1; j < ac.length; j++)
				{	
					if ( ac[i].equals( ac[j] ) )
					{
						ac.splice(j, 1);
					}
				}
			}
		}
		
		static private function jitterPoints( radius:Number ):void
		{
			var rad:Number;
			var angle:Number;
			for each( var p:Point in points )
			{
				
				rad = radius * Math.random();
				angle = ( 2 * Math.PI ) * Math.random();
				p.x += rad * Math.cos(angle);
				p.y += rad * Math.sin(angle);
				
			}
		}
		
		
	}

}