/**
 * Copyright hacker_szoe51ih ( http://wonderfl.net/user/hacker_szoe51ih )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7u5Z
 */

// forked from nutsu's BitmapDataSample1
package {
    
    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    
    [SWF(width=465,height=465,backgroundColor=0)]
    import flash.geom.Matrix;
    public class BitmapDataSample1 extends Sprite {
        
        private var bmpdata:BitmapData;
        private var sprite:Sprite;
        public var matrix:Matrix;
        
        public function BitmapDataSample1() {
            //BitmapDataを作成して表示リストに追加
            bmpdata = new BitmapData( 465, 465, false, 0 );
            addChild( new Bitmap(bmpdata) );
            //グラフィックの作成
            sprite = newFig( 232, 232, 300, 0xFFFFFF );
            //BitmapDataへ描画
            //addChild( sprite );
            matrix=new Matrix();
            matrix.scale(0.5,0.5);
            matrix.translate(100,100);
            bmpdata.draw(sprite,matrix);
            sprite.x=100;
            sprite.y=100;
        }
        
        private function newFig( cx:Number, cy:Number, size:Number, col:uint ):Sprite {
            //中心(cx,cy), 幅高さsize, 色col　のグラフィックを生成
            var shape:Sprite = new Sprite();
            shape.graphics.lineStyle( 0, 0x000000, 0.3 );
            shape.graphics.beginFill( col );
            shape.graphics.drawCircle( cx, cy, size*0.5 );
            //shape.graphics.drawCircle( cx, cy, size*0.4 );
            var w:Number = size/4;
            var h:Number = size/10;       
            shape.graphics.drawRect( cx-w/2, cy-h/2, w, h );
            shape.graphics.endFill();
            return shape;
        }
    }
}