/**
 * Copyright leichtgewicht ( http://wonderfl.net/user/leichtgewicht )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7tHe
 */

package {
    
    import flash.display.Sprite;
    import flash.events.Event;
    
    public class FlashTest extends Sprite {
        
        private var _circle: Circle;
        
        public function FlashTest() {
            addChild(_circle = new Circle());
            addEventListener(Event.ENTER_FRAME, renderStep);
        }
        
        private function renderStep(e:*):void {
            
        }

    }
}

import flash.display.*;

class MotionVector {
    
    public var tX: Number;
    public var tY: Number;
    private var _power: Number = 0;
    private var _angleRad: Number;
    
    public function MotionVector(power: Number, angleDeg: Number):void {
        this.angleDeg = angleDeg;
        this.power = power;
    }

    
    public function set angleDeg(angleDeg: Number):void {
        angleRad = angleDeg*Math.PI/180.0;
    }
    
    public function get angleDeg(): Number {
        return angleRad/Math.PI*180.0;
    }

    public function set angleRad(angleRad: Number): void {
        _angleRad = angleRad;
        updateTranslation();
    }
    
    public function get angleRad(): Number {
        return _angleRad;
    }
    
    public function set power(power: Number): void {
        _power = power;
        updateTranslation();
    }
    
    public function get power(): Number {
        return _power;
    }
    
    private function updateTranslation(): void {
        tX = Math.sin(_angleRad)*_power;
        tY = Math.cos(_angleRad)*_power;
    }


}


class Circle extends Shape {
    
    public var radius: Number = 12.0;
    public var rotatingSpeed: Number = Math.random()*24 - 12;
    public var motion: MotionVector = new MotionVector(-1, 0);
    
    public function Circle() {
        draw();
    }
    
    private function draw():void {
        graphics.beginFill(0x606060);
        graphics.drawCircle(0,0,radius);
        graphics.endFill();
        graphics.beginFill(0xAC0000);
        
        graphics.drawCircle(-radius/2,-radius/2,radius/4);
        graphics.endFill();
    }
}
