/**
 * Copyright onedayitwillmake ( http://wonderfl.net/user/onedayitwillmake )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7t1t
 */

// forked from onedayitwillmake's matrix transform point test
package  
{
	import flash.display.CapsStyle;
	import flash.display.Graphics;
	import flash.display.LineScaleMode;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.geom.ColorTransform;
	import flash.geom.Matrix
	import flash.geom.Point;
	import frocessing.color.ColorHSV; // Nutsu!
	
	/**
	 * @see Please see, Zevan Rosser post @ http://actionsnippet.com/?p=1778
	 * @author Mario Gonzalez
	 */
	[SWF(width =465, height = 465, frameRate=60, backgroundColor="#ffffff")]
	public class Matrixtransform extends Sprite
	{
		private var trans:Matrix = new Matrix();
		private var pnt:Point = new Point();
		private var hsv:ColorHSV = new ColorHSV(0, 1, 0.8);
		
		private var master:Shape;
		private var clones:Vector.<Shape> = new Vector.<Shape>;
		private var cloneCount:int = 36;
		private var rotationAmount:Number = 0;
		
		public function Matrixtransform() 
		{
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			
			var black:Sprite= new Sprite();
			    black.graphics.beginFill(0)
			    black.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
			    black.graphics.endFill();
			addChild(black);
			
			master = new Shape();
			master.blendMode = "add";
			master.x = stage.stageWidth / 2;
			master.y = stage.stageHeight / 2;
			addChild(master);
			createClones();
			
			
			
			addEventListener(Event.ENTER_FRAME, onLoop);
		}
		
		/**
		 * Create the clones
		 */
		private function createClones():void
		{
			for (var i:int = 0; i < cloneCount; i++)
			{
				hsv.h += 10;
				var color:ColorTransform = new ColorTransform();
					color.color = hsv.value;
				var clone:Shape = new Shape();
					clone.blendMode = "add";
					clone.rotation += 5 * i;
					clone.x = stage.stageWidth / 2;
					clone.y = stage.stageHeight / 2;	
					clone.transform.colorTransform = color;
				addChild(clone);
				clones.push(clone)
			}
		}
		
		public function onLoop(evt:Event):void 
		{
			drawMaster();
			rotationAmount -= 0.005
			for (var i:int = 0; i < clones.length; i++)
			{
				var clone:Shape = clones[i];
					clone.graphics.copyFrom(master.graphics);
			}
		}
		
		private function drawMaster():void
		{
			pnt.x = 0;
			pnt.y = 0;
			trans.identity();
			trans.translate(20, 20);
			trans.scale(0.99, 0.99);
			trans.rotate(rotationAmount);
			trans.rotate((stage.mouseX-232)  * Math.PI / 180);
			
			var iterations:int = 16;
			var g:Graphics = master.graphics;
			g.clear();
			g.lineStyle(1, hsv.value, 1, false, LineScaleMode.NONE, CapsStyle.SQUARE);
			g.moveTo(pnt.x, pnt.y);
			for (var i:int = 0; i < iterations; i++)
			{
				pnt = trans.transformPoint(pnt);
				g.lineTo(pnt.x, pnt.y);
			}
		}
	}
}
