/**
 * Copyright k3lab ( http://wonderfl.net/user/k3lab )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7soH
 */

// forked from k3lab's Black hole
// forked from checkmate's fladdict challenge for amateurs
/**
 * Every frame you get screen caputre of the stage.
 * Generate new frame image with using last frames screen capture.
 * This is a starting point of recursive generative art.
 */
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.utils.getTimer;
    public class Beginner extends Sprite {
        /**
         * Overwrite this update function.
         * Every frame the function is invoked with two bitmaps.
         * First one contains reference to the stage bitmap.
         * Second one contains static copy of stage.
         */
         
        public var canvas:BitmapData;
        public var drawHere:BitmapData;
        public var mat:Matrix;
         
        public function update():void{
            drawStep();
            transformStep();
            
            renderStep();
            fadeStep();
        }
        
        
        public function drawStep():void {
            //drawHere.setPixel(stage.mouseX, stage.mouseY, 0x11111111);
            drawHere.setPixel( Math.random()*480, Math.random()*480, 0xffffffff);
        }
    
        
        public function transformStep():void
        {
            var a:Number = getTimer() / 1000
            var b:Number = Math.sin(getTimer()/300)
            var r:Number=Math.sin(3600)-2*a
            mat = new Matrix();
            mat.translate(-240-b*b,-240);
            mat.scale(1.055*Math.sin(2),1.055*Math.cos(r));
            mat.rotate(r*11+b);
            mat.translate(240-b*b,240);
        }
        
        
        public function renderStep():void{
            canvas.draw(drawHere, mat, null,BlendMode.SCREEN);
        }
        
        
        public function fadeStep():void
        {
            var a:Number = getTimer() / 1000
            var r:Number = Math.sin(3600) - 2.3 *a
            canvas.pixelDissolve(drawHere, drawHere.rect, new Point(0, 0), Math.abs(10 * a), Math.abs(10 * r), 5)
            canvas.colorTransform(drawHere.rect, new ColorTransform(Math.random()*0.4-0.6,Math.random()*0.4+0.6,Math.random()*0.4+0.6,1,r,0,0,0));
        }
        
        
        /**
         * ---------------------------------------
         * DO NOT CHANGE FOLLOWING CODES
         * DO NOT ACCESS FOLLOWING PROPERTIES DIRECTLY
         * ---------------------------------------
        */
        
       
        private var bitmap:Bitmap;
        
        
        public function Beginner() {
            canvas = new BitmapData(480,480,false,0x000000);
            bitmap = new Bitmap(canvas);
            addChild(bitmap);
            addEventListener(Event.ENTER_FRAME, _update);
        }
        
        public function _update(e:Event):void{
            if(drawHere)
                drawHere.dispose();
            drawHere = canvas.clone();
            update();
        }
    }
}
