/**
 * Copyright romatica ( http://wonderfl.net/user/romatica )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7shx
 */

/**
 * copyright (c) 2012 www.romatica.com
 * @author itoz
 */
package
{
    import away3d.containers.View3D;
    import away3d.core.base.SubGeometry;
    import away3d.debug.AwayStats;
    import away3d.entities.Mesh;
    import away3d.events.AssetEvent;
    import away3d.library.assets.AssetType;
    import away3d.lights.DirectionalLight;
    import away3d.lights.PointLight;
    import away3d.loaders.Loader3D;
    import away3d.loaders.parsers.Parsers;
    import away3d.materials.ColorMaterial;
    import away3d.materials.lightpickers.StaticLightPicker;
    import away3d.materials.methods.FilteredShadowMapMethod;

    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.geom.Vector3D;
    import flash.net.URLRequest;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import flash.utils.getTimer;

    [SWF(backgroundColor="#FFFFFF", frameRate="60", width="465", height="465")]
    /**
     * Collada Test
     */
    public class ColladaTestHello2 extends View3D
    {
        private static const ZERO:Vector3D = new Vector3D(0, 0, 0);
        private const MAIN_COLOR:int = 0xffffff;
        private var _loader:Loader3D;
        private var light:DirectionalLight;
        private var light2:PointLight;
        private var _lightPicker:StaticLightPicker;
     
        private var _meshes:Array;
        private var _defsArray:Array;
        private var _angsArray:Array;
        private var _tf:TextField;
        
        private const DAE_URL:String = "http://www.romatica.com/dev/samples/away3d/collada_hello2/hello2.dae";
//        [Embed(source="../assets/hello2.dae",mimeType="application/octet-stream")]
//        public static var Model:Class;
        
        private var _capture:Bitmap;
 
        public function ColladaTestHello2()
        {
            // wonderfl capture
           Wonderfl.disable_capture();
           //_capture = addChild(new Bitmap(new BitmapData(465, 465, false, 0x000000))) as Bitmap ;

            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align=StageAlign.TOP_LEFT;
            antiAlias = 4;
            backgroundColor = 0x0;
            camera.lens.far = 2100;
            
            _tf = addChild(new TextField()) as TextField;
            _tf.defaultTextFormat = new TextFormat(null, 12, 0xffffff);
            _tf.autoSize = TextFieldAutoSize.LEFT;
            _tf.text = "Collada LOADING... ";
            _tf.x = int(stage.stageWidth * 0.5) - _tf.width * 0.5;
            _tf.y = int(stage.stageHeight * 0.5) - _tf.height * 0.5;
            
            // ----------------------------------
            // ライト
            // ----------------------------------
            light = scene.addChild(new DirectionalLight()) as DirectionalLight;
            light2 = scene.addChild(new PointLight()) as PointLight;
            light2.ambient = 0.2;
            light2.x = 300;
            light2.y = 800;
            light2.z = -300;
            _lightPicker = new StaticLightPicker([light, light2]);

            
            // ----------------------------------
            // モデル
            // ----------------------------------
            _meshes = [];
            _defsArray = [];
            _angsArray = [];
            
            
            Parsers.enableAllBundled();

            _loader = new Loader3D(true, null);
            _loader.scale(10);
            _loader.rotationY = 180;
            _loader.addEventListener(AssetEvent.ASSET_COMPLETE, onAssetComplete);
            // _loader.loadData(new Model());
           
            _loader.load(new URLRequest(DAE_URL));

            addChild(new AwayStats());
            
            addEventListener(Event.ENTER_FRAME, update);
        }


        /**
         * Listener function for asset complete event on loader
         */
        private function onAssetComplete(event:AssetEvent):void
        {
            if (event.asset.assetType == AssetType.MESH) {
                var mesh:Mesh = event.asset as Mesh;
                
                var mat:ColorMaterial = new ColorMaterial(MAIN_COLOR * Math.random() , 0.85);
                mat.lightPicker = _lightPicker;
                mat.shadowMethod = new FilteredShadowMapMethod(light);
                
                var model:Mesh = new Mesh(mesh.geometry, mat);
                model.scale(100);
                model.y -= 100;
                scene.addChild(model);
                _meshes.push(model);


                var max:int = model.geometry.subGeometries[0].vertexData.length;
                var _defs:Vector.<Number> = new Vector.<Number>(max);
                var _angs:Vector.<Number> = new Vector.<Number>(max);
                _defsArray.push(_defs);
                _angsArray.push(_angs);
                
                for (var i:int = 0; i < _defs.length; i++)
                {
                    _defs[i] = model.geometry.subGeometries[0].vertexData[i];
                    _angs[i] = 0;//Math.random()*1-0.5//_defs[i];//(360 / _defs.length * i );
                }

                if (_tf && _tf.parent) _tf.parent.removeChild(_tf);
            }
          
        }

        //
        /**
         * アップデート
         */
        private function update(event:Event):void
        {
            cameraMotion();
            // 描画
            render();
        }

        /**
         * カメラ移動
         */
        private function cameraMotion():void
        {
            var leng:int = 180;
            var range:int = 2000;
            var t:Number = getTimer() / range;

            for (var k:int = 0; k < _meshes.length; k++)
            {
                var mesh:Mesh = _meshes[k] as Mesh;
                if (mesh) {
                    
                    if (Math.random() < 0.015) {
                        var mat:ColorMaterial = mesh.material  as ColorMaterial;
                        if (mat) {
                            mat.color = Math.random() * MAIN_COLOR + ((Math.random() * 0x33) << int(Math.random() * 4));
                        }
                    }
                    var geo:SubGeometry = mesh.geometry.subGeometries[0] as SubGeometry;
                    var vlen:int = geo.vertexData.length;
                    for (var i:int = 0; i < vlen;i++ )
                    {
                        var abs:Number = (_angsArray[k][i] < 0) ? _angsArray[k][i] * -1:_angsArray[k][i];
                        _angsArray[k][i] = (abs < 0.0001) ? Math.random() * 0.6 - 0.3:_angsArray[k][i] * 0.96;
                        if (Math.random() < 0.001) _angsArray[k][i] *=2;
                        geo.vertexData[i] = _defsArray[k][i] + _angsArray[k][i];
                    }
                    geo.updateVertexData(geo.vertexData);
                }
            }
            
            camera.x = Math.sin(t) * leng;
            camera.y = Math.cos(t) * leng * 1.2;
            camera.z = -600;
            camera.lookAt(ZERO);
            
            // wonderfl capture
           if(_capture) renderer.queueSnapshot(_capture.bitmapData);

        }
    }
}