/**
 * Copyright you_KAZE ( http://wonderfl.net/user/you_KAZE )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7sKJ
 */

// forked from tomrx's なぞり消し
package 
{
    import flash.display.Sprite;
    import flash.events.*;
    /**
     * 一応パズルゲームっす
     * まずマウスでなぞるとなぞった所の玉がきえます、これは得点にはなりません
     * 玉が消えて落ちてきた玉が同じ色で横３つ以上か縦３つ以上になれば消えて得点になります
     * ２分間のスコアアタックです
     * 玉の消え方は某パズルゲームをまねてます
     */
    [SWF(width = "465", height = "465", backgroundColor = "0x000000", frameRate = "60")]
 
    public class Main extends Sprite 
    {
        
        private var _scene:Scene;
        private var _nazoriDisplay:Sprite;
        public function Main():void 
        {
            _scene=new Scene();
            addChild(_scene);
            addEventListener(MouseEvent.MOUSE_DOWN, mousedown);
            addEventListener(MouseEvent.MOUSE_UP, mouseup);
            addEventListener(MouseEvent.MOUSE_MOVE, mousemove);
            _nazoriDisplay = new Sprite();
            addChild(_nazoriDisplay);
            
        }
        private function mousedown(e:Event):void
        {
            _scene._field._mouseflag = 1;
            if (_scene._field._gamemode == 0) { 
                _scene._field._gamemode = 1;    //ゲームスタート
                _scene._field._timer.start();
            }
            //なぞり線開始
            _nazoriDisplay.graphics.lineStyle(1, 0xffffff);
            _nazoriDisplay.graphics.moveTo(mouseX, mouseY);
        }
        private function mouseup(e:Event):void 
        {
            _scene._field._mouseflag = 2;
            _nazoriDisplay.graphics.clear();    //なぞり線消去
        }
        private function mousemove(e:Event):void 
        {
            if(_scene._field._mouseflag==1 && _scene._field._gamemode==1){
                _nazoriDisplay.graphics.lineTo(mouseX, mouseY);    //なぞり線を描く
            }
        }
    }
    
}
import flash.display.*;
import flash.events.*;
import flash.filters.BlurFilter;
import flash.text.TextField;
import flash.text.TextFormat;
import com.bit101.components.PushButton;
import flash.net.URLRequest;
import flash.system.LoaderContext;
import flash.net.navigateToURL;
import flash.geom.Rectangle;
import flash.utils.escapeMultiByte;
import flash.geom.Point;
class Scene extends Sprite
{
        private var my_loader:Loader
        private var bmp_data:BitmapData;
        private var bmp_obj:Bitmap;
        private var miniball_bmp:BitmapData;
        private var miniball_obj:Bitmap
        private var ballgraphic:Vector.<BitmapData>;
        private var miniballgraphic:Vector.<BitmapData>;
        private var chaingraphic:Vector.<BitmapData>
        private var chaingraphic2:Vector.<BitmapData>
        private var chaingraphic3:Vector.<BitmapData>
        private static var blur:BlurFilter;
        public var _field:field = new field();
        private var _scoretxt:TextField = new TextField();
        private var _scoretxt2:TextField = new TextField();
        private var _timetxt:TextField = new TextField();
        private var _txtformat:TextFormat = new TextFormat();
        private var _centertxt:TextField = new TextField();
        private var _delaytime:int = -100;
        private var _scoredelay:Array = [];
        private var _retryButton:PushButton;
        private var _postButton:PushButton;
        public function Scene() 
        {
            my_loader=new Loader;
            my_loader.contentLoaderInfo.addEventListener(Event.COMPLETE,compLoad);
            my_loader.load(new URLRequest("http://assets.wonderfl.net/images/related_images/2/20/2098/20988632c234e518b589aa1caac401e7ea676391"),new LoaderContext(true));
            bmp_obj = new Bitmap(Global._canvas,PixelSnapping.AUTO,true);
            addChild(bmp_obj);
            miniball_bmp = new BitmapData(465, 465, true, 0x00000000);
            miniball_obj = new Bitmap(miniball_bmp, PixelSnapping.AUTO, true);
            addChild(miniball_obj); 
            miniball_obj.blendMode=BlendMode.ADD;
            blur = new BlurFilter(2, 2, 3);
            
            _txtformat.size = 25;
            _txtformat.color = 0xffffff;
            _txtformat.align = "right";
            _scoretxt.defaultTextFormat=_txtformat;
            _scoretxt2.defaultTextFormat = _txtformat;
            _timetxt.defaultTextFormat = _txtformat;
            _txtformat.align = "center";
            _centertxt.defaultTextFormat = _txtformat;
            _scoretxt.width = 100;
            _scoretxt.x =310;
            _scoretxt.y = 5;
            _scoretxt2.x = 230;
            _scoretxt2.y = 5;
            _scoretxt2.text = "SCORE";
            _timetxt.width = 150;
            _timetxt.y = 5;
            
            _centertxt.text = "CLICK TO START";
            _centertxt.width = 200;
            _centertxt.x = 130;
            _centertxt.y = 200;
            _centertxt.visible = true;
            
            addChild(_scoretxt);
            addChild(_scoretxt2);
            addChild(_timetxt);
            addChild(_centertxt);
            _retryButton = new PushButton(this, 0, 0, "retry", onMouseClick);
            _retryButton.x = 120;
            _retryButton.y = 250;
            _retryButton.visible = false;
            _postButton = new PushButton(this, 0, 32, "post Twitter", postTwitter);        
            _postButton.visible = false;
            _postButton.x = 240;
            _postButton.y = 250;
            for (var i:int = 0; i < 100; i++) { _scoredelay[i] = 0;}
        }
        private function onMouseClick(e:MouseEvent):void {
            for (var i:int = 0; i < 100; i++) { _scoredelay[i] = 0;}
            _field.init();
            _retryButton.visible = false;
            _postButton.visible = false;
        }
        private function postTwitter(e:MouseEvent):void {
            var comment:String = "なぞり消し 最大連鎖"+(_field._maxchain+1) +" SCORE "+ _field._score ;
            var post:String = comment + " " + "http://wonderfl.net/c/irRW/" + " " + "#wonderfl ";
            navigateToURL(new URLRequest("http://twitter.com/home?status=" + escapeMultiByte(post)), "_blank");
 
        }
        public function compLoad(e:Event):void {
            var bmp:Bitmap = e.target.content as Bitmap;
            var buf:BitmapData = new BitmapData(384, 128, true, 0x0);
            buf.threshold(bmp.bitmapData,new Rectangle(0,0,384,128),new Point(0,0),"==",0xc2c2c2,0x0,0xffffff,true);
            ballgraphic = new Vector.<BitmapData>();
            miniballgraphic = new Vector.<BitmapData>();
            chaingraphic = new Vector.<BitmapData>();        //１桁
            chaingraphic2 = new Vector.<BitmapData>();        //２桁
            chaingraphic3 = new Vector.<BitmapData>();        //３桁
            //玉の画像
            for (var i:int = 0; i < 12; i++) {
                ballgraphic[i] = new BitmapData(24, 24);
                ballgraphic[i].copyPixels(buf, new Rectangle(i * 24, 0, i * 24 + 24, 24), new Point(0, 0));
                
            }
            //連鎖用画像
            for (i = 0; i < 11; i++) {
                chaingraphic[i] = new BitmapData(24, 24);
                chaingraphic[i].copyPixels(buf, new Rectangle(i*24, 72, i*24+24, 96), new Point(0, 0));
            }
            for (i = 0; i < 10; i++) {
                chaingraphic2[i] = new BitmapData(12, 24);        
                chaingraphic2[i].copyPixels(buf, new Rectangle(i * 12, 48, i * 12 + 12, 72), new Point(0, 0));
                chaingraphic3[i] = new BitmapData(8, 24);
                chaingraphic3[i].copyPixels(buf, new Rectangle(i * 8, 24, i * 8 + 8, 48), new Point(0, 0));
            }
            for (i = 0; i < 6; i++) {
                miniballgraphic[i] = new BitmapData(5, 5);
                miniballgraphic[i].copyPixels(buf, new Rectangle(i * 5+79, 24, i * 5 + 79+5, 29), new Point(0, 0));
            }
            addEventListener(Event.ENTER_FRAME, render);
            _field.init();
        }
        public function render(e:Event):void {
            var c:int;
            var _alpha:int;
            _field.fall();            //落下
            _field.ballClear();        //玉をけす
            Global._canvas.lock();
            Global._canvas.fillRect(new Rectangle(0, 0, 640, 480), 0x0);
            for (var j:int = 1; j < 18;j++){
                for (var i:int = 0; i < 18; i++) {
                    _alpha = 255;
                    c = _field._data[j][i];
                    if (_field._ballAlpha[j][i] != 0) { _alpha =255-(_field._ballAlpha[j][i])*18;}
                    
                    var bmd:BitmapData = new BitmapData(24, 24, true, (_alpha) << 24);
                    
                    
                    if ((_field._flag1[j][i] & 0x10) > 0) { 
                        if((_field._ballCount[j][i] & 2) == 0) {    //玉点滅
                            c = 0; 
                        }
                        _field._ballCount[j][i]++;
                    }
                    if ((_field._flag1[j][i] & 0x04) > 0) {
                        c = c + 5;
                    }
                    if ((_field._flag2[j][i] & 0x10) > 0) { c = 0; }
                    Global._canvas.copyPixels(ballgraphic[c], new Rectangle(0,0,24, 24), new Point(i*24, j*24+24),bmd);

                }
            }
            //連鎖数表示
            var l:int = _field._chainPanels.length;
            var n:int
            while (l--) {
                if(_field._chainPanels[l]._visible==true){
                    n = _field._chainPanels[l]._num;
                    if(n<11 && n>=1){
                        Global._canvas.copyPixels(chaingraphic[n-1], new Rectangle(0, 0, 24, 24), new Point(_field._chainPanels[l]._x,_field._chainPanels[l]._y), bmd);
                    }
                    if (n >= 10 && n < 100) {
                        Global._canvas.copyPixels(chaingraphic[0], new Rectangle(0, 0, 24, 24), new Point(_field._chainPanels[l]._x , _field._chainPanels[l]._y), bmd);
                        Global._canvas.copyPixels(chaingraphic2[n % 10], new Rectangle(0, 0, 12, 24), new Point(_field._chainPanels[l]._x+12, _field._chainPanels[l]._y), bmd);
                        Global._canvas.copyPixels(chaingraphic2[Math.floor(n / 10)], new Rectangle(0, 0, 12, 24), new Point(_field._chainPanels[l]._x, _field._chainPanels[l]._y), bmd);
                    }
                    if (_field._chainPanels[l]._num >= 100) {
                        Global._canvas.copyPixels(chaingraphic[0], new Rectangle(0, 0, 24, 24), new Point(_field._chainPanels[l]._x , _field._chainPanels[l]._y), bmd);
                        Global._canvas.copyPixels(chaingraphic3[n % 10], new Rectangle(0, 0, 12, 24), new Point(_field._chainPanels[l]._x+16, _field._chainPanels[l]._y), bmd);
                        Global._canvas.copyPixels(chaingraphic3[Math.floor(n / 100)], new Rectangle(0, 0, 8, 24), new Point(_field._chainPanels[l]._x, _field._chainPanels[l]._y), bmd);
                        Global._canvas.copyPixels(chaingraphic3[Math.floor(n / 10)%10], new Rectangle(0, 0, 8, 24), new Point(_field._chainPanels[l]._x+8, _field._chainPanels[l]._y), bmd);
                    }
                }
            }
            for (i = 0; i < 1000; i++) {
                    miniball_bmp.copyPixels(miniballgraphic[_field._miniballs[i].color],new Rectangle(0,0,5,5),new Point(_field._miniballs[i].x, _field._miniballs[i].y),bmd);
            }
            miniball_bmp.applyFilter(miniball_bmp, new Rectangle(0,0,465,465),new Point(0,0), blur);
            Global._canvas.unlock();
            
            for (i = 0; i < 99; i++) {
                _scoredelay[i] = _scoredelay[i + 1];
            }
            _scoredelay[99] = _field._score;
            _scoretxt.text = _scoredelay[0].toString();
            var _st:String;
            _st = Math.floor(_field._timecount / 60).toString()+":";
            if ((_field._timecount % 60) < 10) { _st = _st + "0"; }
            _st += _field._timecount % 60;
            _timetxt.text = "TIME " + _st;
            if (_field._timecount == 0) { _centertxt.visible = true; _centertxt.text = "Time's up"; }
            if (_field._gamemode == 1) { _centertxt.visible = false; }
            if (_field._gamemode == 0) { _centertxt.visible = true; _centertxt.text = "CLICK TO START"; }
            if (_field._gamemode == 3) { _postButton.visible = true; _retryButton.visible = true; }
        }
}

class Global
{
    public static var _canvas:BitmapData = new BitmapData ( 465 , 465 , false , 0x0 ) ;    
}
import flash.utils.Timer;
class field extends Sprite
{
        public var _data:Array = [];
        public var _ballAlpha:Array = [];
        public var _ballCount:Array = [];
        public var _flag1:Array = [];
        public var _flag2:Array = [];
        private var _fallwait:Array = [];
        private var _ballClearMode:Array = [];
        private var _ballClearCountStock:Array = [];
        private var _ballClearLocateStockx:Array = [];
        private var _ballClearLocateStocky:Array = [];
        private var _ballClearCount:int;
        private var _ballClearCount2:Array = [];
        private var _ballClearTotal:Array = [];
        private var _ballClearTotal2:Array = [];
        private var _nazorix:Array = [];
        private var _nazoriy:Array = [];
        private var _nazoriflag:Array = [];
        private var _total:int;
        private var _chainCheck:int;
        private var _chainCount:int;
        public var _maxchain:int;
        private var _chainPanelcount:int = 0;
        public var _mouseflag:int = 0;
        public var _score:int = 0;
        private var _checkx:int = 0;
        private var _checky:int = 0;
        private var _ch:Boolean;
        private var _mini_ballCount:int = 0;
        private const NAZORIFLAG:int = 0x01;
        private const CLEARCHECK:int = 0x02;
        private const CLEAR_flag1:int = 0x08;
        private const CLEAR_flag2:int = 0x10;
        private const BLINKFLAG:int = 0x10;
        private const WAITFLAG:int = 0x04;    
        private const FALLFLAG:int = 0x04;
        private const CHAIN_flag1:int = 0x40;
        private const CHAIN_flag2:int = 0x80;
        private const CHAINFLAG3:int = 0x20;
        public var _chainPanels:Vector.<ChainPanel>;
        public var _miniballs:Vector.<Particle>
        public var _miniball:Particle;
        public var _chainPanel:ChainPanel
        public var _timer : Timer = new Timer(1000,0);
        public var _timecount:int = 120;
        public var _gamemode:int = 0;
        public function field() 
        {
            _chainPanels = new Vector.<ChainPanel>();
            _miniballs = new Vector.<Particle>();
            for (var i:int = 0; i < 1000; i++) 
            {
                _miniball = new Particle();    
                _miniballs.push(_miniball);
            }
            for (i = 0; i < 20; i++) {
                _chainPanel = new ChainPanel();
                _chainPanels.push(_chainPanel);
            }
            _timer.addEventListener(TimerEvent.TIMER,function(e:TimerEvent):void{
                if(_gamemode==1){_timecount--;}
                if (_timecount <= 0) { 
                    _gamemode = 2; _timer.stop(); _timecount = 0; 
                    
                }
            });
        }
        public function init():void 
        {
            var x:int;
            var y:int;
            var r:int;
            var i:int;
            for (i = 0; i < 19;i++){        
                _data[i]     =   [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];
                _fallwait[i] =   [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];
                _flag1[i] =      [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];
                _flag2[i] =      [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];
                _ballCount[i] =  [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];
                _ballAlpha[i] =  [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];
                _nazoriflag[i] = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];
            }
            _data[18] = [6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6];    
            for (i = 0; i < 30; i++) {
                _ballClearMode[i] = 0;
                _ballClearTotal[i] = 0;
            }    
            for (y = 17; y >= 0; y--) {
                for (x = 18; x > 0; x--) {
                    r = Math.random() * 5+1
                    while (_data[y + 1][x] == r || _data[y][x+1]==r) { r = Math.random() * 5+1;}
                    _data[y][x] = r;
                }
            }

            _timecount = 120;
            _score = 0;
            _gamemode = 0;
            _maxchain = 0;
            _ballClearCount = 0;
            var l:int = _nazorix.length;
            while (l--) { 
                _nazoriflag[_nazoriy[l]][_nazorix[l]] = 0;
                _nazorix.pop();
                _nazoriy.pop();
            }
            for (i = 0; i < 30; i++) {
                _ballClearCountStock[i] = 0;
            }
        }

        public function ballClear():void 
        {
            nazori();
            ballClearCheck();
            ballClearLocate();
            ballClearMain();
            chainMissCheck();
            for each(var panel:ChainPanel in _chainPanels)
            {
                panel.move();
                if (panel._visible == true) { c = true;; }
                if (panel._count > 48) {
                    panel._visible = false;
                }
            }
            var c:Boolean = false;
            for each(var ball:Particle in _miniballs)
            {
                if (ball._visible == true) {
                    c = true;
                    ball.x += ball.vx 
                    ball.y += ball.vy 
                    ball.vx += ball.vx2;
                    ball.vy += ball.vy2;
                    ball.count--;
                    if (ball.count<0) {
                        ball._visible = false;
                        ball.x = -10;
                        ball.y = 0;
                    }
                }
            }
            for (var i:int= 0; i < 30; i++) {
                if (_ballClearMode[i] != 0) { c = true;}
            }
            for (var y:int = 0; y < 18; y++) {
                for (var x:int = 1; x < 18; x++) {
                    if (_data[y][x] == 0) { c = true;}
                }
            }
            if (_gamemode == 2 && _timecount == 0 && c == false) { _gamemode = 3; }

        }
        
        private function nazori():void {
            
            if (_gamemode != 1) { return;}
            var i:int;
            var ii:int;
            var a:int;
            var x:int = Math.floor(mouseX / 24);
            var y:int = Math.floor((mouseY-24) / 24);
            if (_mouseflag == 1) {
                if ((_checkx != x || _checky != y) && y>0 && y<18) {
                    if(_data[y][x]!=0 && _data[y][x]!=6 && (_flag2[y][x] & 0x1c)==0 && (_flag1[y][x] & 0x14) == 0 && _nazoriflag[y][x]==0){
                    _nazorix.push(x);
                    _nazoriy.push(y);
                    _ch = true;
                    _checkx = x;
                    _checky = y;
                    _nazoriflag[y][x] = 1;
                    }
                }
            }
            if (_mouseflag == 2) {
                _checkx = -1;
                _checky = 0;
                if (_ch == true) { _ch = false;
                var check:Boolean = false;
                for (i = 0; i < 30; i++) {
                    if (_ballClearMode[i] == 0) { ii = i; check = true; }
                }
                if (check == false) { return; }
                _ballClearCountStock[ii] = _ballClearCount;
                a = _ballClearCount;
                var l:int = _nazorix.length;
                _total = 0;
                for (i = 0; i < l; i++) {

                    if (_data[_nazoriy[i]][_nazorix[i]]!=0 && _data[_nazoriy[i]][_nazorix[i]]!=6 && (_flag2[_nazoriy[i]][_nazorix[i]] & 0x1c) == 0 && (_flag1[_nazoriy[i]][_nazorix[i]] & 0x14) == 0) {
                        _ballClearLocateStockx[a] = _nazorix[i];
                        _ballClearLocateStocky[a] = _nazoriy[i];
                        _flag2[_nazoriy[i]][_nazorix[i]] = _flag2[_nazoriy[i]][_nazorix[i]] | CLEAR_flag1
                        a = (a + 1) % 1000;
                        _total++;
                    }
                }
                while (l--) { 
                    _nazoriflag[_nazoriy[l]][_nazorix[l]] = 0;
                    _nazorix.pop();
                    _nazoriy.pop();
                }
                if (_total != 0) {
                    _ballClearLocateStockx[a] = 0xff;
                    _ballClearCount = (_ballClearCount + _total + 1)%1000;
                    _ballClearMode[ii] = 1;
                    _ballClearCount2[ii] = 0;
                    _ballClearTotal[ii] = 0;
                    _ballClearTotal2[ii] = _total;
                    _mouseflag = 0;
                    }
                }
            }
        }
        private function chainMissCheck():void {
            var check:Boolean = false;
            var x:int;
            var y:int;
            for (y = 0; y < 18; y++) {
                for (x = 0; x < 18; x++) {
                    if ((_flag2[y][x] & 0xc0) != 0 && (_flag2[y][x]&0x1e)==0) {
                        _flag2[y][x] = _flag2[y][x] & 0x1e;
                    }
                }
            }
            for (y = 0; y < 18; y++) {
                for (x = 0; x < 18; x++) {
                    if ((_flag2[y][x] & 0xc4) != 0) { check = true; }
                }
            }
            if (check == false) { _chainCount = 0;}
        }
        private function ballClearMain():void {
            var a:int;
            var x:int;
            var y:int;
            var h:int = 0;
            var y2:int;
            for (var i:int = 0; i < 30; i++) {
                a = _ballClearCountStock[i];
                switch(_ballClearMode[i]) {
                    case 0:
                    break;
                    case 1:
                        while (_ballClearLocateStockx[a] != 0xff) {
                            x = _ballClearLocateStockx[a];
                            y = _ballClearLocateStocky[a];
                            _flag1[y][x] = _flag1[y][x] | BLINKFLAG;
                            _ballCount[y][x] = 0;
                            a = (a + 1) % 1000;
                        }
                        _ballClearMode[i] = 2;
                    break;
                    case 2:
                        _ballClearCount2[i]++;
                        if (_ballClearCount2[i] > 45) {
                            _ballClearCount2[i] = 0;
                            _ballClearMode[i] = 3;
                            while (_ballClearLocateStockx[a] != 0xff) {
                                x = _ballClearLocateStockx[a];
                                y = _ballClearLocateStocky[a];
                                _flag1[y][x] = _flag1[y][x] ^ BLINKFLAG;
                                _flag1[y][x] = _flag1[y][x] | WAITFLAG;
                                a = (a + 1) % 1000;
                            }
                        }
                    break;
                    case 3:
                        _ballClearCount2[i]++;
                        if (_ballClearCount2[i] > 14) {
                            _ballClearCount2[i] = 0;
                            _ballClearMode[i] = 4;
                        }
                    break;
                    case 4:
                        _ballClearCount2[i]++; 
                        
                        x = _ballClearLocateStockx[(_ballClearTotal[i] + a)%1000];
                        y = _ballClearLocateStocky[(_ballClearTotal[i] + a) % 1000];
                        
                        _ballAlpha[y][x] = _ballClearCount2[i];
                        if (_ballClearCount2[i]++ > 14) {
                            trace(i.toString()+":"+_ballClearTotal[i].toString() + "-" +_ballClearTotal2[i].toString()+"-"+ a.toString());
                            _ballClearCount2[i] = 0;
                            if (x != 0xff) {
                                _flag2[y][x] = _flag2[y][x] | CLEAR_flag2;
                                _flag1[y][x] = _flag1[y][x] ^ WAITFLAG;                                    
                                if ((_flag2[y][x] & CHAINFLAG3) > 0) {
                                    for (var j:int = 0; j < 8+Math.floor(_chainCount/6); j++) {
                                    var co:Number = Math.cos(Math.PI / 180 * (j * (360/(8+Math.floor(_chainCount/6)))));
                                    var si:Number = Math.sin(Math.PI / 180 * (j * (360/(8+Math.floor(_chainCount/6)))));
                                    var bx:Number = x * 24 + 12 + (co * 10);
                                    var by:Number = y * 24 + 12 + (si * 10);
                                    _score++;                                    
                                    _miniballs[_mini_ballCount]._visible = true;
                                    _miniballs[_mini_ballCount].count = 100;
                                    _miniballs[_mini_ballCount].color = _data[y][x];
                                    _miniballs[_mini_ballCount].x = bx
                                    _miniballs[_mini_ballCount].y = by+24
                                    _miniballs[_mini_ballCount].vx = co * (2+_chainCount/40);
                                    _miniballs[_mini_ballCount].vy = si * (2+_chainCount/40);
                                    _miniballs[_mini_ballCount].vx2 = (2 * (405 - bx ) -2*(co*(2+_chainCount/40)*100)) / 10000; 
                                    _miniballs[_mini_ballCount].vy2 = -(2 * (by+24 - 20) + 2*(si*(2+_chainCount/40)*100)) / 10000;
                                    _mini_ballCount++;
                                    if (_mini_ballCount >=1000) { _mini_ballCount = 0; }
                                    }
                                }
                                
                            }
                            
                            _ballClearTotal[i]++;
                            
                            if (_ballClearTotal2[i] == _ballClearTotal[i]) {
                                _ballClearMode[i] = 0;
                                a = _ballClearCountStock[i];
                                while (_ballClearLocateStockx[a] != 0xff) {
                                    x = _ballClearLocateStockx[a];
                                    y = _ballClearLocateStocky[a];
                                    _data[y][x] = 0;
                                    _flag2[y][x] = 0;
                                    h = 0;
                                    for (y2 = y; y2 > 0; y2--) {
                                        if (y2 > 0 && h == 0) {
                                            if ((_flag2[y2-1][x]&CLEAR_flag1)==0) {
                                                if (_data[y2 - 1][x] != 0 && (_flag2[y2 - 1][x]&FALLFLAG) == 0) {
                                                    _flag2[y2 - 1][x] = _flag2[y2 - 1][x] | CHAIN_flag1 | FALLFLAG;
                                                    _fallwait[y2 - 1][x] = 30;
                                                }
                                            }else { h = 1;}
                                        }
                                    }
                                    a = (a + 1) % 1000;
                                }
                            }
                        }
                    break;
                }
            }
        }
        private function ballClearLocate():void {
            //玉の消える場所を保存
            var i:int;
            var ii:int;
            var a:int;
            var check:Boolean = false;
            var check2:int;
            for (i = 0; i < 30; i++) {
                if (_ballClearMode[i] == 0) { ii = i; check = true; }
            }
            if (check == false) { return; }
            
            _ballClearCountStock[ii] = _ballClearCount;
            a = _ballClearCount;
            _total = 0;
            check2 = 0;
            for (var y:int = 0; y < 18; y++) {
                for (var x:int = 0; x < 18; x++) {
                    if ((_flag2[y][x] & CHAIN_flag2) != 0) { check2 = 1;}
                }
            }
            for (y = 0; y < 18; y++) {
                for (x= 0; x < 18; x++) {
                    if ((_flag2[y][x] & CLEARCHECK) != 0) {
                        _ballClearLocateStockx[a] = x;
                        _ballClearLocateStocky[a] = y;
                        a = (a + 1) % 1000;
                        _flag2[y][x] = _flag2[y][x] ^ CLEARCHECK ;
                        _flag2[y][x] = _flag2[y][x] | CLEAR_flag1;
                        if (check2 == 1) { _flag2[y][x] = _flag2[y][x] | CHAINFLAG3; }
                        _total++;
                    }
                }
            }
            
            if (_total != 0) {
                _ballClearLocateStockx[a] = 0xff;
                _ballClearCount = (_ballClearCount + _total + 1)%1000;
                _ballClearMode[ii] = 1;
                _ballClearCount2[ii] = 0;
                _ballClearTotal[ii] = 0;
                _ballClearTotal2[ii] = _total;
                
            }
        }
        private function ballClearCheck():void {
            //同じ色の玉が３つ以上並んだか
            var i:int;
            var x:int;
            var y:int;
            var l:int=_chainPanels.length;
            _chainCheck = 0;
            for (y = 1; y < 18; y++) {
                for (x = 1; x < 16; x++) { 
                    if ((_flag2[y][x] & 0x1c) == 0 && (_flag2[y][x + 1] & 0x1c) == 0 && (_flag2[y][x + 2] & 0x1c) == 0) { 
                    if ((_flag1[y][x] & 0x14) == 0 && (_flag1[y][x + 1] & 0x14) == 0 && (_flag1[y][x + 2] & 0x14) == 0) {    
                        if (_data[y][x] != 0 && _data[y][x + 1] != 0 && _data[y][x + 2] != 0) {
                            if (_data[y][x] == _data[y][x + 1] && _data[y][x] == _data[y][x + 2]) {
                                for (i= 0; i < 3;i++){
                                    if ((_flag2[y][x + i] & CLEARCHECK) == 0) {
                                        if ((_flag2[y][x+i] & CHAIN_flag1) == 0) {
                                            _flag2[y][x+i] = _flag2[y][x+i] | CLEARCHECK;
                                        }else {
                                            _flag2[y][x + i] = _flag2[y][x + i] ^ CHAIN_flag1 ;
                                            _flag2[y][x + i] = _flag2[y][x + i] | CHAIN_flag2 | CLEARCHECK;
                                            if (_chainCheck == 0) {
                                                _chainCheck++;
                                                _chainCount++;
                                                if (_maxchain < _chainCount) { _maxchain = _chainCount;}
                                                if (_chainCount > 998) { _chainCount = 998; }
                                                _chainPanels[_chainPanelcount]._num = _chainCount +1;
                                                _chainPanels[_chainPanelcount]._x = x*24;
                                                _chainPanels[_chainPanelcount]._y = y * 24;
                                                _chainPanels[_chainPanelcount]._count = 0;
                                                _chainPanels[_chainPanelcount]._visible = true;
                                                _chainPanelcount = (_chainPanelcount + 1) % 20;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    }
                }
            }
            for (y = 1; y < 16; y++) {
                for (x = 1; x < 18; x++) {
                    if ((_flag2[y][x] & 0x1c) == 0 && (_flag2[y + 1][x] & 0x1c) == 0 && (_flag2[y + 2][x] & 0x1c) == 0) { 
                    if ((_flag1[y][x] & 0x14) == 0 && (_flag1[y + 1][x] & 0x14) == 0 && (_flag1[y + 2][x] & 0x14) == 0) { 
                        if (_data[y][x] != 0 && _data[y + 1][x] != 0 && _data[y + 2][x] != 0) {
                            if (_data[y][x] == _data[y + 1][x] && _data[y][x] == _data[y + 2][x]) { 
                                for (i = 0; i < 3;i++){
                                    if ((_flag2[y + i][x] & CLEARCHECK) == 0) {
                                        if ((_flag2[y+i][x] & CHAIN_flag1) == 0) {
                                            _flag2[y+i][x] = _flag2[y+i][x] | CLEARCHECK;
                                        }else {
                                            _flag2[y + i][x] = _flag2[y + i][x] ^ CHAIN_flag1 ;
                                            _flag2[y + i][x] = _flag2[y + i][x] | CHAIN_flag2 | CLEARCHECK;
                                            if (_chainCheck == 0) {
                                                _chainCheck++;
                                                _chainCount++;
                                                if (_maxchain < _chainCount) { _maxchain = _chainCount;}
                                                if (_chainCount > 998) { _chainCount = 998; }
                                                _chainPanels[_chainPanelcount]._num = _chainCount + 1;
                                                _chainPanels[_chainPanelcount]._x = x * 24;
                                                _chainPanels[_chainPanelcount]._y = y * 24;
                                                _chainPanels[_chainPanelcount]._count = 0;
                                                _chainPanels[_chainPanelcount]._visible = true;
                                                _chainPanelcount = (_chainPanelcount + 1) % 20;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    }
                }
            }
        }
        public function fall():void
        {
            var x:int;
            var y:int;
            for (x = 1; x < 18; x++){ 
                if (_data[0][x] == 0) {
                    var r:int = Math.floor(Math.random() * 5) + 1;
                    while (_data[y + 1][x] == r || _data[y][x+1]==r) { r = Math.random() * 5+1;}
                    _data[0][x] = r
                    _flag2[0][x] = FALLFLAG|CHAIN_flag1|CHAIN_flag2;
                }
            }
            for (y = 0; y < 18; y++) {
                for (x = 0; x < 18; x++){
                    if (_fallwait[y][x] > 0) { _fallwait[y][x]--;}
                }
            }
            for (y = 17; y >= 0; y--) {
                for (x = 18; x > 0; x--){
                    if (_data[y][x] != 0) { 
                        if ((_flag2[y][x] & 0x08) == 0){ 
                            if ((_flag2[y][x] & FALLFLAG) == 0){
                                if (_fallwait[y + 1][x] != 0) {
                                    _flag2[y][x] = _flag2[y][x] | FALLFLAG;
                                    _fallwait[y][x] = _fallwait[y + 1][x];
                                }else {
                                    if (_data[y + 1][x] == 0){
                                        _flag2[y][x] = _flag2[y][x] | FALLFLAG;
                                        _fallwait[y][x] = 30;
                                    }
                                }
                            }else { 
                                if (_fallwait[y][x] == 0){
                                    if (_fallwait[y + 1][x] == 0) {
                                        if ((_flag2[y + 1][x] & FALLFLAG) == 0) {
                                            if (_data[y + 1][x] == 0) {
                                                _data[y + 1][x] = _data[y][x];
                                                _flag1[y + 1][x] = _flag1[y][x];
                                                _flag2[y + 1][x] = _flag2[y][x];
                                                _data[y][x] = 0;
                                                _flag1[y][x] = 0;
                                                _flag2[y][x] = 0;
                                            }else {
                                                _flag2[y][x] = _flag2[y][x] & CHAIN_flag1;
                                                _ballCount[y][x] = 0;
                                            }
                                        }else {
                                            _flag2[y][x] = _flag2[y][x] | FALLFLAG;
                                            _ballCount[y][x] = 0;
                                        }
                                    }else {
                                        _fallwait[y][x] = _fallwait[y + 1][x];
                                    }                                    
                                }
                            }
                        }
                    }
                }
            }            
        }
}
class ChainPanel
{
        public var _num:int;
        public var _x:int;
        public var _y:int;
        public var _count:int;
        public var _visible:Boolean = false;
        public function ChainPanel() 
        {
            _num = 0;
            _x = 0;
            _y = 0;
            _count = 0;
        }
        public function move():void {
            _y--;
            _count++;
        }
}
class Particle
{
        public var x:Number;
        public var y:Number;
        public var vx:Number = 0;
        public var vy:Number = 0;
        public var vx2:Number = 0;
        public var vy2:Number = 0;
        public var color:uint;
        public var _visible:Boolean = false;
        public var count:int;
        public function Particle() 
        {
            
        }
        
}