/**
 * Copyright actionscriptbible ( http://wonderfl.net/user/actionscriptbible )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7sDa
 */

package {
  import com.actionscriptbible.Example;
  import flash.events.Event;

  public class ch20ex2 extends Example {
    public function ch20ex2() {
      var t:Thermometer = new Thermometer();
      t.addEventListener(Thermometer.TEMP_CHANGED, onTempChanged);
      
      var warn:TempWarning = new TempWarning(t);
      warn.x = stage.stageWidth - warn.width;
      addChild(warn);
      
      t.debugSimulateCrazyWeather();
    }
    
    protected function onTempChanged(event:Event):void {
      var t:Thermometer = Thermometer(event.target);
      trace("It's now " + t.temp.toFixed(1) + "°F");
    }
  }
}

import flash.display.Sprite;
import flash.geom.ColorTransform;
class TempWarning extends Sprite {
  public function TempWarning(t:Thermometer) {
    graphics.beginFill(0xffff00);
    graphics.drawRect(0, 0, 50, 50);
    graphics.endFill();
    t.addEventListener(Thermometer.TEMP_CHANGED, onTempChanged);
  }
  
  protected function onTempChanged(event:Event):void {
    var t:Thermometer = Thermometer(event.target);
    var ctx:ColorTransform = new ColorTransform();
    var hotness:Number = mapRange(t.temp, 60, 100);
    ctx.redMultiplier = hotness;
    ctx.greenMultiplier = 1 - hotness;
    this.transform.colorTransform = ctx;
  }
  
  //map a range of values from min->max to 0->1 (and clamp)
  protected function mapRange(value:Number, min:Number, max:Number):Number {
    return Math.min(1, Math.max(0, (value - min) / (max - min)));
  }
}

import flash.events.*;
import flash.utils.setInterval;
class Thermometer extends EventDispatcher {
  protected var _temp:Number = 72;
  public static const TEMP_CHANGED:String = "tempChanged";

  public function set temp(newTemp:Number):void {
    _temp = newTemp;
    dispatchEvent(new Event(TEMP_CHANGED));
  }
  
  public function get temp():Number {
    return _temp;
  }
  
  internal function debugSimulateCrazyWeather():void {
    //tweak the weather to trend continuously higher (to see our handiwork)
    setInterval(function():void {temp += 3 * (Math.random() - 0.4);}, 500);
  }
}