/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7rtw
 */

package {
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.utils.getTimer;
    // @see http://projecteuler.net/index.php?section=problems&id=293
    public class Euler293 extends Sprite {
        private var _tf : TextField;
  
        public function Euler293() {
            _tf = new TextField();
            _tf.width = 465;
            _tf.height = 465;
            addChild(_tf);
            
            var s : int = getTimer();
            tr(solve());
            var g : int = getTimer();
            tr((g - s) + " ms");
        }

        // admissibleな個数がすくないので試し割りの素数判定でも余裕
        private function solve() : Number
        {
			rec([2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31], 0, 1);
			var ret : Number = 0;
			for each(var val : Number in _o){
				ret += val;
			}
			return ret;
        }
        
        private var ct : uint = 0;
        
        private function rec(primes : Array, pos : uint, prev : Number) : void
        {
        		prev *= primes[pos];
        		while(prev < 1E9){
        			check(prev);
        			rec(primes, pos + 1, prev);
        			prev *= primes[pos];
        		}
        }
        
        private function check(n : Number) : void
        {
        		ct++;
        		for(var m : uint = 3;!isPrime(n + m);m += 2);
        		_o[m] = m;
        }
        
        private var _o : Object = {};

        private function isPrime(n : Number) : Boolean
        {
            if(n <= 1)return false;
            if(n % 2 == 0)return n == 2;
            
            var sq : int = Math.sqrt(n);
            for(var i : int = 3;i <= sq;i+=2){
                if(n % i == 0){
                    return false;
                }
            }
            return true;
        }        
        
        private function tr(...o : Array) : void
        {
            _tf.appendText(o + "\n");
            _tf.scrollV = _tf.maxScrollV;
        }
    }
}
