/**
 * Copyright gameegg ( http://wonderfl.net/user/gameegg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7qoO
 */

package {
    import flash.geom.ColorTransform;
    import flash.geom.Point;
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Shape;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.ColorMatrixFilter;
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;
    
    public class Lightning_1 extends Sprite {
        
        private var _bitd:BitmapData;
        private var _bit:Bitmap;
        private var _flash:Shape;
        private var _ground:Shape;
        private var _cmf:ColorMatrixFilter = new ColorMatrixFilter([0.95,0,0,0,0,
                                                                    0,0.97,0,0,0,
                                                                    0,0,1,0,0,
                                                                    0,0,0,1,0]);
        private var _cmf2:ColorMatrixFilter = new ColorMatrixFilter([0.9,0,0,0,0,
                                                                    0,0.9,0,0,0,
                                                                    0,0,1,0,0,
                                                                    0,0,0,1,0]);
        private var _bf:BlurFilter = new BlurFilter(16,16,2);
        private var _ctf:ColorTransform = new ColorTransform(1,1,1,0.95);
        private var _startPoint:Point = new Point(250,200);
        private var _r:Number = 0;
                
        public function Lightning_1() {
            _bitd = new BitmapData(465,465,false,0x000000);
            _bit = new Bitmap(_bitd);
            _ground = new Shape();
            _flash = new Shape();
            _flash.graphics.beginFill(0xffffff);
            _flash.graphics.drawRect(0,0,465,465);
            _flash.alpha = 0;
            
            
            addChild(_bit);
            addChild(_flash);
            
            stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDown);
            stage.addEventListener(Event.ENTER_FRAME, enterFrame);
            
        }
        
        
        private function mouseDown(e:MouseEvent):void {
            drawLines(_startPoint.x,_startPoint.y,mouseX,mouseY,true);
        }
        
        private function pit(PointA:Point, PointB:Point):Number{
            return Math.sqrt((PointA.x - PointB.x)*(PointA.x - PointB.x) + (PointA.y - PointB.y)*(PointA.y - PointB.y));
        }

        
        private function drawLines(sx:Number,sy:Number,ex:Number,ey:Number,mainRoot:Boolean):void{
            var _currentPoint:Point = new Point(sx,sy);
            var _endPoint:Point = new Point(ex,ey);
            var distance:Number = pit(_currentPoint,_endPoint);
            var random:Number;
            _ground.graphics.moveTo(sx,sy);
            
            while(distance > 10){
                _ground.graphics.lineStyle(distance/90+0.05,0xffffff);
                _r = Math.atan2(_endPoint.y - _currentPoint.y, _endPoint.x - _currentPoint.x) + Math.random()*2.4 - 1.2;
                random = Math.random()*(distance/50)
                _currentPoint.x += Math.cos(_r)*random;
                _currentPoint.y += Math.sin(_r)*random;
                
                _ground.graphics.lineTo(_currentPoint.x,_currentPoint.y);
                distance = pit(_currentPoint,_endPoint);
                if(Math.random() > 0.95 && mainRoot || Math.random()>0.99){

                    var _rofchild:Number = _r + Math.random() - 0.5;
                    drawLines(_currentPoint.x,_currentPoint.y,
                    _currentPoint.x + Math.cos(_rofchild)*Math.random()*distance/1.5,_currentPoint.y + Math.sin(_rofchild)*Math.random()*distance/1.5,false);

                }
                _ground.graphics.moveTo(_currentPoint.x,_currentPoint.y)

            }
            if(mainRoot){
                _startPoint.x = _endPoint.x;
                _startPoint.y = _endPoint.y;
                _bitd.draw(_ground);
                _bitd.applyFilter(_bitd,_bitd.rect,new Point(0,0),_bf);
                _bitd.applyFilter(_bitd,_bitd.rect,new Point(0,0),_cmf2);
                _flash.alpha = 1;
                _bitd.draw(_ground);
                _ground.graphics.clear();
            }
        }
        
        private function enterFrame(e:Event):void{
            if(_flash.alpha < 0.6)_bitd.applyFilter(_bitd,_bitd.rect,new Point(0,0),_cmf);
            if(_flash.alpha < 0.6)_bitd.colorTransform(_bitd.rect,_ctf);
            _flash.alpha -= _flash.alpha/4;
        }

    }
}