/**
 * Copyright alumican_net ( http://wonderfl.net/user/alumican_net )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7qGe
 */

package
{
    import flash.events.MouseEvent;
    import com.bit101.components.InputText;
    import com.bit101.components.Label;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    
    public class SpringTester extends Sprite
    {
        private var _uiSpring:InputText;
        private var _uiFriction:InputText;
        private var _circle:Sprite;
        private var _cross:Sprite;
        private var _x:Number;
        private var _y:Number;
        private var _tx:Number;
        private var _ty:Number;
        private var _vx:Number;
        private var _vy:Number;
        private var _spring:Number;
        private var _friction:Number;
        
        public function SpringTester()
        {
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            _circle = Sprite(addChild(new Sprite()));
            _circle.mouseEnabled = false;
            _circle.graphics.beginFill(0x0);
            _circle.graphics.drawCircle(0, 0, 10);
            _circle.graphics.endFill();
            
            _cross = Sprite(addChild(new Sprite()));
            _cross.mouseEnabled = false;
            _cross.graphics.lineStyle(1, 0xff0000);
            _cross.graphics.moveTo(-5, 0);
            _cross.graphics.lineTo(5, 0);
            _cross.graphics.moveTo(0, -5);
            _cross.graphics.lineTo(0, 5);
            
            new Label(this, 10, 8, "SPRING:");
            new Label(this, 10, 28, "FRICTION:");
            _uiSpring = new InputText(this, 60, 10, "0.6", _uiSpringChangeHandler);
            _uiFriction = new InputText(this, 60, 30, "0.9", _uiFrictionChangeHandler);
            _uiSpring.width = _uiFriction.width = 50;
            _uiSpringChangeHandler();
            _uiFrictionChangeHandler();
            
            _x = _tx = int(465 / 2);
            _y = _ty = int(465 / 2);
            _vx = 0;
            _vy = 0;
            
            _cross.x = _tx;
            _cross.y = _ty;
            _circle.x = _x;
            _circle.y = _y;
            
            addEventListener(Event.ENTER_FRAME, _enterFrameHandler);
            stage.addEventListener(MouseEvent.CLICK, _clickHandler);
        }
        
        private function _enterFrameHandler(e:Event):void
        {
            _vx += (_tx - _x) * _spring;
            _vy += (_ty - _y) * _spring;
            
            _vx *= _friction;
            _vy *= _friction;
            
            _x += _vx;
            _y += _vy;
            
            _circle.x = _x;
            _circle.y = _y;
        }
        
        private function _clickHandler(e:MouseEvent):void
        {
            _tx = mouseX;
            _ty = mouseY;
            
            _cross.x = _tx;
            _cross.y = _ty;
        }
        
        private function _updateParams():void
        {
            _vx = 0;
            _vy = 0;
        }

        private function _uiSpringChangeHandler(e:Event = null):void
        {
            var value:Number = parseFloat(_uiSpring.text);
            if (!isNaN(value)) _spring = value;
            _updateParams();
        }
        
        private function _uiFrictionChangeHandler(e:Event = null):void
        {
            var value:Number = parseFloat(_uiFriction.text);
            if (!isNaN(value)) _friction = value;
            _updateParams();
        }
    }
}