/**
 * Copyright kotobuki ( http://wonderfl.net/user/kotobuki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7pvz
 */

package {
  import flash.display.Sprite;
  import flash.events.Event;
  import flash.text.TextField;
  import funnel.*;

  public class MeasureDistanceByPSD extends Sprite {
    // センサの測距範囲内に対象物がないと判断する閾値
    private static const THRESHOLD:Number = 0.08;

    private var arduino:Arduino;

    // センサに接続したピン
    private var sensorPin:Pin;

    private var textField:TextField;

    public function MeasureDistanceByPSD() {
      // Arduinoのインスタンスを生成してsensorPinを初期化
      arduino = new Arduino(Arduino.FIRMATA);
      sensorPin = arduino.analogPin(0);

      // 距離を表示するフィールドを追加し、フレームイベントのリスナをセット
      textField = new TextField();
      addChild(textField);
      addEventListener(Event.ENTER_FRAME, onEnterFrame);
    }

    private function onEnterFrame(e:Event):void {
      // センサの値を読み取る
      var value:Number = sensorPin.value;
      if (value > THRESHOLD) {
        // 読み取った値が閾値よりも大きければ距離に変換して表示
        var range:Number = (6787 / (value * 1023 - 3)) - 4;
        textField.text = "Range: " + Math.round(range) 
                         + " cm";
      } else {
        // 読み取った値が閾値以下であれば「OFF」と表示
        textField.text = "Range: OFF";
      }
    }
  }
}
