/**
 * Copyright nausicaa ( http://wonderfl.net/user/nausicaa )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7oUT
 */

package {
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.filters.DropShadowFilter;
    import caurina.transitions.Tweener;
    import caurina.transitions.properties.FilterShortcuts;
    
    public class FlashTest extends Sprite {
    		public static const STD_POINT:Number = 150;
    		public static const STD_DISTANCE:Number = 32;
    		public static const STD_BLUR:Number = 32;
    		
    		private var light:Sprite;
    		private var ball:Sprite;
    		
        public function FlashTest() {
            // FilterShortcutsを有効化
            FilterShortcuts.init();
            
            // lightを作成
            light = new Sprite();
            light.x = stage.stageWidth/2;
            light.y = stage.stageHeight/2;
            
            light.graphics.beginFill(0xff0000);
            light.graphics.drawCircle(0, 0, 20);
            light.graphics.endFill();
            
            addChild(light);
            
            // ballを作成
            ball = new Sprite();
            ball.x = light.x;
            ball.y = light.y;
            ball.filters = [new DropShadowFilter(0, 0, 0, .5, 0, 0)];
            
            ball.graphics.beginFill(0);
            ball.graphics.drawCircle(0, 0, 20);
            ball.graphics.endFill();
            
            addChild(ball);
            
            stage.addEventListener(MouseEvent.CLICK, function(e:MouseEvent):void{
            		var dx:Number = mouseX - light.x;
        			var dy:Number = mouseY - light.y;
        			var dp:Number = Math.sqrt(dx*dx + dy*dy) / STD_POINT;
        			var degrees:Number = Math.atan2(dy, dx) / Math.PI*180;
        		
        			Tweener.addTween(ball, {
        				x:mouseX,
        				y:mouseY,
        				_DropShadow_angle:degrees,
        				_DropShadow_distance:dp*STD_DISTANCE,
        				_DropShadow_blurX:dp*STD_BLUR,
        				_DropShadow_blurY:dp*STD_BLUR,
        				time:1,
        				transition:"easeInOutCublic"
        			});
            	
            	});
        }
        
       
    }
}