/**
 * Copyright Naohiko.Ueno ( http://wonderfl.net/user/Naohiko.Ueno )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7oDZ
 */

// forked from Naohiko.Ueno's Starling RenderTextureScene
package 
{
    //    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.system.Capabilities;    
    
    import starling.core.Starling;
    
    [SWF(width="465", height="465", frameRate="60", backgroundColor="#222222")]
    public class Startup extends flash.display.Sprite
    {
        private var mStarling:Starling;
        
        public function Startup()
        {
            // Wonderflのプレピュー用にキャプチャ撮りたいときだけ第1引数をtrueにする。
            // 第2引数はキャプチャを撮るまでの秒数。
            WonderflCaptureUtil.init(false, 10);
            
            Starling.multitouchEnabled = false; // useful on mobile devices
            Starling.handleLostContext = true; // deactivate on mobile devices (to save memory)            
            
            mStarling = new Starling(RenderTextureScene, stage);
            mStarling.simulateMultitouch = true;
            mStarling.enableErrorChecking = Capabilities.isDebugger;
            mStarling.showStats = true;
            mStarling.start();            
            
            // Wonderflのプレピュー用キャプチャを撮るときだけStarlingの画面をビットマップ化してstage最前面に追加する。
            if (WonderflCaptureUtil.captureEnabled)
            {
                mStarling.juggler.delayCall(function():void
                {
                    captureStarling(stage);
                }, WonderflCaptureUtil.captureDelay - 0.5);
            }
            
            // this event is dispatched when stage3D is set up
            mStarling.stage3D.addEventListener(Event.CONTEXT3D_CREATE, onContextCreated);
        }
        
        private function onContextCreated(event:Event):void
        {
            // set framerate to 30 in software mode
            if (Starling.context.driverInfo.toLowerCase().indexOf("software") != -1)
                Starling.current.nativeStage.frameRate = 30;
        }
    }
}

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Sprite;
import flash.display.Stage;
import flash.events.MouseEvent;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;
import flash.text.TextFormat;

import starling.core.RenderSupport;
import starling.core.Starling;

function captureStarling(stage:Stage, starlingInstance:Starling=null):void
{
    if (starlingInstance == null)
        starlingInstance = Starling.current;
    
    if (starlingInstance == null)
        throw new IllegalOperationError("Starling instance is missing");
    if (starlingInstance.context == null)
        throw new IllegalOperationError("Contex3D is missing");
        
    var captchaData:BitmapData = new BitmapData(465, 465, false);
    
    var support:RenderSupport = new RenderSupport();
    RenderSupport.clear(starlingInstance.stage.color, 1.0);
    support.setOrthographicProjection(0, 0, captchaData.width, captchaData.height);
    starlingInstance.stage.render(support, 1.0);
    support.finishQuadBatch();
    
    starlingInstance.context.drawToBitmapData(captchaData);
    
    var textField:flash.text.TextField = new flash.text.TextField();
    textField.defaultTextFormat = new TextFormat("Arial", 10, 0xFFFFFF);
    textField.text = "This is captured image for winderfl preview.";
    textField.autoSize = TextFieldAutoSize.CENTER;
    textField.x = 465 - textField.width - 4;
    textField.y = 465 - textField.height - 4;
    var sprite:flash.display.Sprite = new flash.display.Sprite();
    sprite.graphics.beginFill(0x000000, 0.5);
    sprite.graphics.drawRoundRect(textField.x - 2, textField.y - 2, textField.width + 2, textField.height + 2, 6);
    sprite.addChild(textField);
    captchaData.draw(sprite);
    
    var captcha:Bitmap = new Bitmap(captchaData);
    stage.addChild(captcha);
    stage.addEventListener(MouseEvent.CLICK, stage_clickHandler);
    
    function stage_clickHandler(event:MouseEvent):void
    {
        stage.removeEventListener(MouseEvent.CLICK, stage_clickHandler);
        stage.removeChild(captcha);
        captchaData.dispose();
    }
}

import flash.errors.IllegalOperationError;
import flash.utils.getDefinitionByName;

class WonderflCaptureUtil
{
    // Wonderfl default setting @see http://wonderfl.net/help#help_capture
    private static var _capture:Boolean = true;
    private static var _captureDelay:Number = 3;
    
    private static var _inited:Boolean = false;
    private static var _wonderflClassChecked:Boolean = false;
    private static var _wonderflClass:Class;
    
    public static function get captureEnabled():Boolean
    {
        return wonderflClass ? _capture : false;
    }
    
    public static function get captureDelay():Number
    {
        return _captureDelay;
    }
    
    public static function get wonderflClass():Class
    {
        if (_wonderflClassChecked)
            return _wonderflClass;
        else
        {
            try
            {
                _wonderflClassChecked = true;
                _wonderflClass = getDefinitionByName("Wonderfl") as Class
                return _wonderflClass;
            }
            catch (e:Error) {}
        }
        
        return null;
    }
    
    public static function init(capture:Boolean=false, captureDelay:Number=3):void
    {
        if (_inited)
            throw new IllegalOperationError("WonderflCaptureUtil is already inited.");
        
        _inited = true;
        _capture = capture;
        _captureDelay = captureDelay;
        
        if (wonderflClass)
        {
            if (capture)
                wonderflClass["capture_delay"](captureDelay);
            else
                wonderflClass["disable_capture"]();
        }
    }
}

import flash.geom.Point;
import flash.utils.Dictionary;

import starling.core.Starling;
import starling.display.BlendMode;
import starling.display.Button;
import starling.display.Image;
import starling.display.Quad;
import starling.display.Sprite;
import starling.events.Event;
import starling.events.Touch;
import starling.events.TouchEvent;
import starling.events.TouchPhase;
import starling.filters.BlurFilter;
import starling.text.BitmapChar;
import starling.text.BitmapFont;
import starling.text.TextField;
import starling.textures.RenderTexture;
import starling.textures.Texture;

class RenderTextureScene extends starling.display.Sprite
{
    private var mRenderTexture:RenderTexture;
    private var mCanvas:Image;
    private var mBrush:Image;
//    private var mButton:Button;
    private var mButton:starling.text.TextField;
    private var mColors:Dictionary;

    private var stageWidth:int;
    private var stageHeight:int;
    
    public function RenderTextureScene()
    {
        stageWidth = Starling.current.stage.stageWidth;
        stageHeight = Starling.current.stage.stageHeight;
        
        mColors = new Dictionary();
        mRenderTexture = new RenderTexture(stageWidth - 20, stageHeight - 40);
        
        var background:Quad = new Quad(mRenderTexture.width, mRenderTexture.height, 0xCCCCCC);
        background.setVertexColor(0, 0xDDDDDD);
        background.setVertexColor(3, 0xBBBBBB);
        background.x = 10;
        background.y = 30;
        addChild(background);
        
        mCanvas = new Image(mRenderTexture);
        mCanvas.x = background.x;
        mCanvas.y = background.y;
        mCanvas.filter = BlurFilter.createDropShadow();
        mCanvas.addEventListener(TouchEvent.TOUCH, onTouch);
        addChild(mCanvas);        
        
        var mini:BitmapFont = new BitmapFont();
        var charID:int = "*".charCodeAt(0);
        var char:BitmapChar = mini.getChar(charID);
        
        //mBrush = new Image(Assets.getTexture("Brush"));
        mBrush = char.createImage();
        mBrush.pivotX = mBrush.width / 2;
        mBrush.pivotY = mBrush.height / 2;
        mBrush.scaleX = 4;
        mBrush.scaleY = 4;
        mBrush.blendMode = BlendMode.NORMAL;
        
        var infoText:starling.text.TextField = new starling.text.TextField(256, 128, "Touch the screen\nto draw!");
        infoText.color = 0xFFFFFF;
        infoText.fontSize = 24;
        infoText.x = mCanvas.width - infoText.width >> 1;
        infoText.y = mCanvas.height - infoText.height >> 1;
        mRenderTexture.draw(infoText);  
        
        mButton = new starling.text.TextField(150, 21, "Mode: Draw");
        mButton.fontName = BitmapFont.MINI;
        mButton.color = 0xCCCCCC;
        mButton.fontSize = BitmapFont.NATIVE_SIZE * 2;
        mButton.border = true;
        mButton.x = stageWidth - mButton.width >> 1;
        mButton.y = 5;
        mButton.addEventListener(TouchEvent.TOUCH, onButtonTriggered);
        addChild(mButton);
    }
    
    private function onTouch(event:TouchEvent):void
    {
        // touching the canvas will draw a brush texture. The 'drawBundled' method is not
        // strictly necessary, but it's faster when you are drawing with several fingers
        // simultaneously.
        
        mRenderTexture.drawBundled(function():void
        {
            var touches:Vector.<Touch> = event.getTouches(mCanvas);
            
            for each (var touch:Touch in touches)
            {
                if (touch.phase == TouchPhase.BEGAN)
                    mColors[touch.id] = Math.random() * uint.MAX_VALUE;
                
                if (touch.phase == TouchPhase.HOVER || touch.phase == TouchPhase.ENDED)
                    continue;
                
                var location:Point = touch.getLocation(mCanvas);
                mBrush.x = location.x;
                mBrush.y = location.y;
                mBrush.color = mColors[touch.id];
                mBrush.rotation = Math.random() * Math.PI * 2.0;
                
                mRenderTexture.draw(mBrush);
            }
        });
    }
    
    private function onButtonTriggered(event:TouchEvent):void
    {
        var touch:Touch = event.getTouch(mButton, TouchPhase.ENDED);
        
        if (!touch) return;
        
        if (mBrush.blendMode == BlendMode.NORMAL)
        {
            mBrush.blendMode = BlendMode.ERASE;
            mButton.text = "Mode: Erase";
        }
        else
        {
            mBrush.blendMode = BlendMode.NORMAL;
            mButton.text = "Mode: Draw";
        }
    }
    
    public override function dispose():void
    {
        mRenderTexture.dispose();
        super.dispose();
    }
}
