/**
 * Copyright set0 ( http://wonderfl.net/user/set0 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7mld
 */

package  
{
	import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.geom.*;
	
    [SWF(width=465, height=465, frameRate=60, backgroundColor=0x000000)]
    public class FlashTest22 extends Sprite
	{
        Wonderfl.capture_delay( 10 );
		private var spark_list:Array = [];
		private var line_list:Array = [];
		private var buffer:BitmapData = new BitmapData(465, 465, false, 0x000000);
		private var screen:Bitmap = new Bitmap(buffer);
		
		private var spark_shape:Shape;
		private var mouse_down:Boolean = false;
		
		private var old_x:Number;
		private var old_y:Number;
		
		public function FlashTest22()
		{
			spark_shape = new Shape()
			spark_shape.graphics.beginFill(0xffffff, 1.0);
			spark_shape.graphics.drawCircle(20, 20, 2);
			spark_shape.filters = [new GlowFilter(0xff2200, 0.8, 16, 16, 4)];
			
			addChild(screen);
			stage.addEventListener(MouseEvent.MOUSE_DOWN, function():void { mouse_down = true; old_x = stage.mouseX; old_y = stage.mouseY; } );
			stage.addEventListener(MouseEvent.MOUSE_UP, function():void{mouse_down = false});
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
		
		private function onEnterFrame(e:Event):void
		{
			if(mouse_down == true) {
				spark_list.push(new Spark(stage.mouseX, stage.mouseY, spark_shape));
				line_list.push(new Line(old_x, old_y, stage.mouseX, stage.mouseY));
				old_x = stage.mouseX;
				old_y = stage.mouseY;
			}
			
			var max:int = spark_list.length;
			
			buffer.lock();
			buffer.applyFilter(buffer, buffer.rect, new Point(0, 0), new BlurFilter(32, 32));
			
			for (var i:int = 0; i < max; i++) {
				if (spark_list[i].move() === false) {
					spark_list.splice(i, 1);
					i--;
					max--;
					continue;
				}
				
				buffer.copyPixels(spark_list[i].bmp, spark_list[i].bmp.rect, new Point(spark_list[i].x, spark_list[i].y));
			}
			
			max = line_list.length;
			for (i = 0; i < max; i++) {
				if (line_list[i].move() === false) {
					line_list.splice(i, 1);
					i--;
					max--;
					continue;
				}
				
				buffer.copyPixels(line_list[i].bottom_bmp, line_list[i].bottom_bmp.rect, new Point(line_list[i].x, line_list[i].y));
			}
			
			for (i = 0; i < max; i++) {
				buffer.copyPixels(line_list[i].top_bmp, line_list[i].top_bmp.rect, new Point(line_list[i].x, line_list[i].y));
			}
			
			buffer.unlock();
		}
    }
}

import flash.display.*;
import flash.geom.*;
import flash.filters.*;

class Spark
{
    public var bmp:BitmapData;
	public var x:Number;
	public var y:Number;
	public var x0:Number;
	public var y0:Number;
	public var vx0:Number;
	public var vy0:Number;
	public var g:Number;
	public var dt:Number;
	public var t:Number;

    public function Spark(x:Number, y:Number, shape:Shape)
    {
        this.bmp = new BitmapData(40, 40, true, 0xffffff);
		this.bmp.draw(shape);
		
		this.x0 = x - 20;
		this.y0 = y - 20;
		this.vx0 = Math.random() * 15;
		this.vy0 = -60 + Math.random() * 40;
		this.g = 9.8;
		this.t = 0;
		this.dt = 0.2;
		
		this.x = this.x0;
		this.y = this.y0;
    }
	
	public function move():Boolean
	{
		this.t += this.dt;
		this.x = this.vx0 * this.t + this.x0;
		this.y = this.vy0 * this.t + 0.5 * this.g * this.t * this.t + this.y0;
		
		if (this.x >= 465 || this.y >= 465) {
			return false;
		}
		
		return true;
	}
}

class Line
{
    public var top_bmp:BitmapData;
	public var bottom_bmp:BitmapData;
	public var x:Number;
	public var y:Number;
	public var life:Number = 120;

    public function Line(old_x:Number, old_y:Number, x:Number, y:Number)
    {
		var width:Number = Math.abs(old_x - x) + 10;
		var height:Number = Math.abs(old_y - y) + 10;
		var from_x:Number;
		var from_y:Number;
		var to_x:Number;
		var to_y:Number;
		
		if (x > old_x) {
			this.x = old_x - (old_x / Math.abs(old_x));
		} else {
			this.x = x - (x / Math.abs(x));
		}
		
		if (y > old_y) {
			this.y = old_y - (old_y / Math.abs(old_y));
		} else {
			this.y = y - (y / Math.abs(y));
		}
		
        this.top_bmp = new BitmapData(width, height, true, 0xffffff);
		
		from_x = x - this.x + 1;
		from_y = y - this.y + 1;
		to_x = old_x -this.x + 1;
		to_y = old_y -this.y + 1;
		
		var top_shape:Shape = new Shape();
		top_shape.graphics.lineStyle(1, 0xffffff);
		top_shape.graphics.moveTo(from_x, from_y);
		top_shape.graphics.lineTo(to_x , to_y);

		this.top_bmp.draw(top_shape);
		
		var bottom_shape:Shape = new Shape();
		bottom_shape.graphics.lineStyle(2, 0xffffff);
		bottom_shape.graphics.moveTo(from_x, from_y);
		bottom_shape.graphics.lineTo(to_x , to_y);
		bottom_shape.filters = [new GlowFilter(0xff2200, 0.8, 2, 2)];
		
		this.bottom_bmp = new BitmapData(width, height, true, 0x000000);
		this.bottom_bmp.draw(bottom_shape);

    }
	
	public function move():Boolean
	{
		life--;
		
		if (life <= 0) {
			return false;
		}
		
		return true;
	}
}
