/**
 * Copyright Aquioux ( http://wonderfl.net/user/Aquioux )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7miq
 */

// forked from checkmate's adobe challenge 1
/**
 * 
 * "Use Flash Player 10 drawing API,
 *  specifically drawTriangles.
 *  My favorite part of the new capabilities
 *  is the ability to specify
 *  UVT texture mapping data."
 *                     by Justin Everett-Church
 *  
 * This code is a example of drawTriangle.
 */

/**
 * http://wonderfl.net/code/ab463259dc49234ed8b3871548a18fbd221ac20d
 * 上記を参考に、縦と横で異なるセグメント数を指定できるようにしました。
 * あと drawGraphicsData 使用しています。
 */

package {
    
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.GraphicsBitmapFill;
    import flash.display.GraphicsEndFill;
    import flash.display.GraphicsTrianglePath;
    import flash.display.IGraphicsData;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Point;
    import flash.net.URLRequest;
    import flash.system.Security;
    
    [SWF(width="600", height="600", backgroundColor="0xFFFFFF", frameRate="20")]

    public class drawTriangleTest extends Sprite{
    
        // セグメント数関連
        private const SEGMENT_W:uint = 2;
        private const SEGMENT_H:uint = 4;
        
        // イメージの BitmapData
        private var imageBitmapData:BitmapData;
        
        // セグメント化クラス
        private var segmentation:Segmentation;
        
        // コンテナ
        private var anchorContainer:Sprite;
        private var imageContainer:Sprite;

        // アンカー格納 Vector
        private var anchorVector:Vector.<Dragpoint>;
        
        // for GraphicsData, drawTriangle
        private var graphicsData:Vector.<IGraphicsData>;
        private var trianglePath:GraphicsTrianglePath;
        private var verticies:Vector.<Number>;

        public function drawTriangleTest() {
            imageBitmapData = new BitmapData(300, 300);
            imageBitmapData.perlinNoise(150, 150, 6, Math.random()*10+1, true, true, 7, false, null);

            // セグメント化クラスのインスタンス生成
            segmentation = new Segmentation(SEGMENT_W, SEGMENT_H);
            
            // コンテナの生成
            imageContainer  = new Sprite();
            anchorContainer = new Sprite();
            addChild(imageContainer);
            addChild(anchorContainer);

            // GraphicsTrianglePath 用 Vector の生成
            var indicies:Vector.<int>   = segmentation.getIndicies();	// inducides の生成
            var uvDatas:Vector.<Number> = segmentation.getUvDatas();	// uvDatas の生成
            
            // アンカーの生成（↑で作った uvDatas を使う）
            var n:uint = uvDatas.length / 2;
            anchorVector = new Vector.<Dragpoint>(n);
            var imageWidth:uint  = imageBitmapData.width;
            var imageHeight:uint = imageBitmapData.height;
            var offsetX:Number = (stage.stageWidth  - imageWidth)  / 2;
            var offsetY:Number = (stage.stageHeight - imageHeight) / 2;
            for (var i:uint = 0; i < n; i++) {
                var posX:Number = imageWidth  * uvDatas[i * 2]     + offsetX;
                var posY:Number = imageHeight * uvDatas[i * 2 + 1] + offsetY;
                var anchor:Dragpoint = new Dragpoint(posX, posY);
                anchorContainer.addChild(anchor);
                anchorVector[i] = anchor;
            }
            
            // graphicsData の生成
            graphicsData = new Vector.<IGraphicsData>();
            graphicsData.push(new GraphicsBitmapFill(imageBitmapData));
            graphicsData.push(trianglePath = new GraphicsTrianglePath(verticies, indicies, uvDatas));
            graphicsData.push(new GraphicsEndFill());
            
            // ENTER_FRAME
            addEventListener(Event.ENTER_FRAME, enterFramehandler);
        }
        
        private function enterFramehandler(event:Event):void {
            // vertics の更新
            trianglePath.vertices = segmentation.getVerticies(anchorVector);
            // 描画
            imageContainer.graphics.clear();
            imageContainer.graphics.drawGraphicsData(graphicsData);
        }
    }
}

import flash.geom.Point;

class Segmentation {
    private var segW:uint;
    private var segH:uint;
    private var uvDatas:Vector.<Number>;
    
    // コンストラクタ
    public function Segmentation(segW:uint, segH:uint) {
        this.segW = segW;
        this.segH = segH;

        // uvtData を即座に生成
        uvDatas = new Vector.<Number>((segW + 1) * (segH + 1) * 2);
        var cnt:uint = 0;
        for (var i:uint = 0; i < segH + 1; i++) {
            for (var j:uint = 0; j < segW + 1; j++) {
                uvDatas[cnt++] = j / segW;
                uvDatas[cnt++] = i / segH;
            }
        }
    }
    
    // verticies の生成（updata のたびに呼ばれる）
    public function getVerticies(anchorVector:Vector.<Dragpoint>):Vector.<Number> {
        var n:uint = (segW + 1) * (segH + 1);
        var verticies:Vector.<Number> = new Vector.<Number>(n * 2);
        for (var i:int = 0; i < n; i++) {
            verticies[i * 2]     = anchorVector[i].x;
            verticies[i * 2 + 1] = anchorVector[i].y;
        }
        return verticies;
    }
    
    // indicies の生成（最初に一度だけ呼ばれる）
    public function getIndicies():Vector.<int> {
        var indicies:Vector.<int> = new Vector.<int>(segW * segH * 6);
        var cnt:uint = 0;
        for (var i:uint = 0; i < segH; i++) {
            for (var j:uint = 0; j < segW; j++) {
                var leftTop:uint  = i * (segW + 1) + j;
                var rightTop:uint = i * (segW + 1) + j + 1;
                var leftBottom:uint  = (i + 1) * (segW + 1) + j;
                var rightBottom:uint = (i + 1) * (segW + 1) + j + 1;
                indicies[cnt]     = leftTop;
                indicies[cnt + 1] = rightTop;
                indicies[cnt + 2] = leftBottom;
                indicies[cnt + 3] = rightTop;
                indicies[cnt + 4] = rightBottom;
                indicies[cnt + 5] = leftBottom;
                cnt += 6;
            }
        }
        return indicies;
    }
    
    // getUvDatas の return （最初に一度だけ呼ばれる）
    public function getUvDatas():Vector.<Number> {
        return uvDatas;
    }
}

import flash.display.Sprite;
import flash.events.MouseEvent;
import flash.display.Graphics;

class Dragpoint extends Sprite{
    public function Dragpoint (xPos:Number,yPos:Number){
        this.graphics.beginFill(0x000000);
        this.graphics.drawCircle(0,0,7.5);
        this.graphics.endFill();
        this.x=xPos;
        this.y=yPos;
        this.buttonMode=true;
        this.addEventListener(MouseEvent.MOUSE_DOWN,downHandler);
        this.addEventListener(MouseEvent.MOUSE_UP,upHandler);
    }
    private function downHandler(e:MouseEvent):void{
        this.startDrag();
    }
    private function upHandler(e:MouseEvent):void {
        this.stopDrag();
    }
}
