/**
 * Copyright kaiho ( http://wonderfl.net/user/kaiho )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7mhp
 */

/*
 * 十字架パズルもどきVer0.3
 * ver0.2:全パーツ反転可能に修正
 *        (パーツの上を不用意に横切ると大変なことになります)
 * ver0.3:回転反転ボタンによる回転と反転の切替
 *        課題点１機能追加(解答例を8つ追加)
 * 
 * 操作方法：
 * パーツ移動				・・・ドラッグ
 * パーツの45度回転（時計回り）・・・クリック（回転反転ボタンによって切替）
 * パーツ反転				・・・クリック（回転反転ボタンによって切替）
 * 
 * 今後の課題点(追加予定機能)
 * 1.画面中央に解答例を表示させる。
 * 	・ボタンによって解答例が切り替えられるようにする。
 * 2.パーツ上でMouseDownを行ったときに、そのパーツを最前へ表示させる。
 * 3.パーツをフレームの枠内からはみ出さないようにする。
 * 　・パーツごとにサイズが異なるので要注意。
 * 4.パーツ同士が接触したときにパーツをくっつける。
 * 　･パーツ同士をきれいに連結させること。
 * 	・連結したパーツを切り離すアクションの追加。
 * 5.答合せができるようにする。
 */
package 
{
	import __AS3__.vec.Vector;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.text.TextField;
	import flash.text.TextFormat;

	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	
	//[SWF(width=500, height=300, backgroundColor=0xffffff, frameRate=200)]
	 
	public class Main extends Sprite 
	{
		private var W:Number = 500;
		private var H:Number = 400;
		
		private var partsList:Vector.<Parts>; //パーツリスト
		private var ansList:Vector.<Answers>; //解答例リスト
		
		private var ans:Answers; //解答例
		
		private var partsFrame:Sprite;  
		private var partsBmp:Bitmap;
		private var partsBmpData:BitmapData;
		
		//ボタン
		private var btnW:int = 70;
		private var btnH:int = 20;
		
		//回転反転切替ボタン
		private var invBtn:button;
		private var invText:TextField;
		private var INVESPIN:String = "回転/反転";
		private var invX:int = (W / 2) - (btnW / 2);
		private var invY:int = (H / 10);
		
		//解答例切替ボタン
		private var backBtn:button;
		private var backText:TextField;
		private var BACK:String = "BACK";
		private var backX:int = (W / 4) - (btnW / 2);
		private var backY:int = (H / 10) * 9;
		
		private var nextBtn:button;
		private var nextText:TextField;
		private var NEXT:String = "NEXT";
		private var nextX:int = ((W / 4) * 3) - (btnW / 2);
		private var nextY:int = (H / 10) * 9;
		
		//操作方法メッセージ
		private var mtext:TextField;
		private var MANUAL:String = "操作方法";
		private var mDtext:TextField;
		private var DRAG:String = "・ドラッグ・・・パーツをつかんで移動";
		private var mCtext:TextField;
		private var SPIN:String = "・クリック・・・パーツを回転";
		private var INVE:String = "・クリック・・・パーツを反転";
		
		private var answerNum:int = 0;
		private var ansNumText:TextField;
		
		public function Main():void 
		{
			init();
		}
		
		private function init():void 
		{
			//createFrame();
			createManual();
			createAnswer();
			createButton();
			createParts();
		}
		
		private function createFrame():void {
			partsBmpData = new BitmapData(W, H, true, 0x00FF00);
			partsBmp = new Bitmap(partsBmpData);
			
			addChild(partsBmp);
			partsFrame = new Sprite();
			partsBmpData.draw(partsFrame);
		}
		
		//操作方法
		private function createManual():void {
			mtext = new TextField();
			mtext.defaultTextFormat = new TextFormat("", 10, 0x0, true);
			mtext.autoSize = "left";
			mtext.y = 0;
			mtext.text = MANUAL;
			
			mDtext = new TextField();
			mDtext.defaultTextFormat = new TextFormat("", 10, 0x0, true);
			mDtext.autoSize = "left";
			mDtext.y = 10;
			mDtext.text = DRAG;
			
			mCtext = new TextField();
			mCtext.defaultTextFormat = new TextFormat("", 10, 0x0, true);
			mCtext.autoSize = "left";
			mCtext.y = 20;
			mCtext.text = SPIN;
			
			ansNumText = new TextField();
			ansNumText.defaultTextFormat = new TextFormat("", 10, 0x0, true);
			ansNumText.autoSize = "left";
			ansNumText.y = 50;
			ansNumText.text = "第" + answerNum + "問";
			
			addChild(mtext);
			addChild(mDtext);
			addChild(mCtext);
			addChild(ansNumText);
		}
		
		//解答例作成
		private function createAnswer():void {
			
			ansList = new Vector.<Answers>();
			
			var a:Answers;
			a= new ans000(this, W /2, H / 2);
			ansList.push(a);
			
			a = new ans001(this, W /2, H / 2);
			ansList.push(a);
			
			a = new ans002(this, W /2, H / 2);
			ansList.push(a);
			
			a = new ans003(this, W /2, H / 2);
			ansList.push(a);
			
			a = new ans004(this, W /2, H / 2);
			ansList.push(a);
			
			a = new ans005(this, W /2, H / 2);
			ansList.push(a);
			
			a = new ans006(this, W /2, H / 2);
			ansList.push(a);
			
			a = new ans007(this, W /2, H / 2);
			ansList.push(a);
			
			a = new ans008(this, W /2, H / 2);
			ansList.push(a);
			
			//初回表示
			for (var i:int = 0; i < ansList.length; i++) {
				stage.addChild(ansList[i]);
				ansList[i].graphics.clear();
			}
			ansList[0].draw();
		}
		
		//ボタン作成
		private function createButton():void
		{
			
			//反転・回転ボタン
			invBtn = new button(btnW, btnH);
			invBtn.x = invX;
			invBtn.y = invY;
			invText = new TextField();
			invText.text = INVESPIN;
			invText.selectable = false;
			invText.width = btnW - 10;
			invText.height = 20;
			invText.x = invX + 7;
			invText.y = invY;
			invBtn.addEventListener(MouseEvent.CLICK, onINVBtnClick);
			
			stage.addChild(invText);
			stage.addChild(invBtn);
			
			//解答例切替ボタン
			backBtn = new button(btnW, btnH);
			backBtn.x = backX;
			backBtn.y = backY;
			backText = new TextField();
			backText.text = BACK;
			backText.selectable = false;
			backText.width = btnW - 10;
			backText.height = 20;
			backText.x = backX + 15;
			backText.y = backY;
			backBtn.addEventListener(MouseEvent.CLICK, onBACKBtnClick);
			
			stage.addChild(backText);
			stage.addChild(backBtn);
			
			nextBtn = new button(btnW, btnH);
			nextBtn.x = nextX;
			nextBtn.y = nextY;
			nextText = new TextField();
			nextText.text = NEXT;
			nextText.selectable = false;
			nextText.width = btnW - 10;
			nextText.height = 20;
			nextText.x = nextX + 15;
			nextText.y = nextY;
			nextBtn.addEventListener(MouseEvent.CLICK, onNEXTBtnClick);
			
			stage.addChild(nextText);
			stage.addChild(nextBtn);
		}
		
		//パーツ作成
		private function createParts():void
		{
			partsList = new Vector.<Parts>();
			
			var color:uint=0x0000ff;
			var p:Parts;
			for (var i:int = 0; i < 6; i++)
			{
				color *= 0xf;
				
				switch(i) {
					case 0:
						p = new PartA(this, (W / 2) - (Math.sqrt(50 * 50 * 2) / 2), (H / 2) - (Math.sqrt(50*50*2) / 2), 45, color);
						stage.addChild(p);
						partsList.push(p);
						break;
					case 1:
						p = new PartA(this, W / 2, (H / 2) + Math.sqrt(50*50*2), 45, color);
						stage.addChild(p);
						partsList.push(p);
						break;
					case 2:
						p = new PartA(this, (W / 2) + Math.sqrt(50*50*2), (H / 2) + Math.sqrt(50*50*2), -45, color);
						stage.addChild(p);
						partsList.push(p);
						break;
					case 3:
						p = new PartB(this, (W / 2) - (Math.sqrt(50 * 50 * 2) / 2), 
										(H / 2) + (Math.sqrt(50*50*2) / 2), -45, color);
						stage.addChild(p);
						partsList.push(p);
						break;
					case 4:
						p = new PartC(this, (W / 2) + Math.sqrt(50*50*2), H / 2, 135,color);
						stage.addChild(p);
						partsList.push(p);
						break;
					case 5:
						p = new PartD(this, W /2, H / 2, 225, color);
						stage.addChild(p);
						partsList.push(p);
						break;
					default:
						p = new PartA(this, Math.random() * W, Math.random() * H, 0, color);
						stage.addChild(p);
						partsList.push(p);
				}
				
			}
			
		}

		//回転反転ボタンイベント
		public function onINVBtnClick(event:MouseEvent):void {
			if (mCtext.text == SPIN) {
				mCtext.text = INVE;
				for (var i:int = 0; i < partsList.length; i++)
				{
					partsList[i].inversionFlg = true;
				}
			} else {
				mCtext.text = SPIN;
				for (var j:int = 0; j < partsList.length; j++)
				{
					partsList[j].inversionFlg = false;
				}
			}
		}
		
		public function onBACKBtnClick(event:MouseEvent):void {
			ansList[answerNum].graphics.clear();
			answerNum--;
			if (answerNum < 0) {
				answerNum = ansList.length - 1;
			}
			ansNumText.text = "第" + answerNum + "問";
			ansList[answerNum].draw();
		}
		
		public function onNEXTBtnClick(event:MouseEvent):void {
			ansList[answerNum].graphics.clear();
			answerNum++;
			if (answerNum == ansList.length) {
				answerNum = 0;
			}
			ansNumText.text = "第" + answerNum + "問";
			ansList[answerNum].draw();
		}

	}
}

import __AS3__.vec.Vector;
import flash.display.Shape;
import flash.display.DisplayObject;
import flash.display.SimpleButton;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.filters.GlowFilter;
import flash.geom.Matrix;
import flash.display.Sprite;
import flash.geom.Point;

class Parts extends Sprite
{
	protected var field:Main;
	protected var color:uint;
	
	public var inversionFlg:Boolean = false;
	
	private var mX:Number = 0;
	private var mY:Number = 0;
	
	public function Parts(field:Main)
	{
		this.field = field;
		
		addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
		addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
	}

	protected function enterFrame(event:Event):void
	{
		
	}
	
	protected function onMouseDown(event:MouseEvent): void
	{
		this.startDrag();
		
		mX = x;
		mY = y;
	}

	protected function onMouseUp(event:MouseEvent): void
	{
		this.stopDrag();
		
		if(mX == x && mY == y) {
			if(inversionFlg) {
				inversion();
			} else {
				spin();
			}
		}
		
		mX = 0;
		mY = 0;
	}
	
	//図形回転
	public function spin():void
	{
		this.rotation += 45;
	}	
	//図形反転
	public function inversion():void
	{
		if (this.scaleX == -1) {
			this.scaleX = 1;
		} else {
			this.scaleX = -1;
		}
	}
	
	protected function draw():void
	{
	}

}

//パーツA
class PartA extends Parts
{
	
	
	public function PartA(field:Main, x:Number, y:Number, z:Number, c:uint)
	{
		super(field);
		this.x = x;
		this.y = y;
		this.rotation = z;
		this.color = c;
		this.field = field;
		
		draw();
		
	}
	
	//パーツ描写
	override protected function draw():void
	{
		graphics.lineStyle(1, color, 1);
		graphics.beginFill(color);
		graphics.lineTo(0, -50);
		graphics.lineTo(50, -50);
		graphics.lineTo(0, 0);
		graphics.endFill();
	}

}

//パーツB
class PartB extends Parts
{
	public function PartB(field:Main, x:Number, y:Number, z:Number, c:uint)
	{
		super(field);
		this.x = x;
		this.y = y;
		this.rotation = z;
		this.color = c;
		this.field = field;
		
		draw();
	}
	
	//パーツ描写
	override protected function draw():void
	{
		graphics.lineStyle(1, color, 1);
		graphics.beginFill(color);
		graphics.lineTo(0, 50);
		graphics.lineTo(-50, 0);
		graphics.lineTo(0,-50);
		graphics.lineTo(50, 0);
		graphics.lineTo(0, 0);
		graphics.endFill();
	}

}

//パーツC
class PartC extends Parts
{
	public function PartC(field:Main, x:Number, y:Number, z:Number, c:uint)
	{
		super(field);
		this.x = x;
		this.y = y;
		this.rotation = z;
		this.color = c;
		this.field = field;
		
		draw();
	}
	
	//パーツ描写
	override protected function draw():void
	{
		graphics.lineStyle(1, color, 1);
		graphics.beginFill(color);
		graphics.lineTo(0, 50);
		graphics.lineTo(50, 100);
		graphics.lineTo(100, 100);
		graphics.lineTo(0, 0);
		graphics.endFill();
	}

}

//パーツD
class PartD extends Parts
{
	public function PartD(field:Main, x:Number, y:Number, z:Number, c:uint)
	{
		super(field);
		this.x = x;
		this.y = y;
		this.rotation = z;
		this.color = c;
		this.field = field;
		
		draw();
	}
	
	//パーツ描写
	override protected function draw():void
	{
		graphics.lineStyle(1, color, 1);
		graphics.beginFill(color);
		graphics.lineTo(0, -50);
		graphics.lineTo(50, -50);
		graphics.lineTo(50,50);
		graphics.lineTo(0, 0);
		graphics.endFill();
		this.scaleX = -1;
	}
	
}

class button extends SimpleButton {
	
	private var upUint:uint = 0xaaaaaa;
	private var downUint:uint = 0x0;
	private var overUint:uint = 0xffffff;
	
	private var r:int = 10;
	
	public function button (w:int, h:int):void {
		upState = makeState(upUint, w, h, r);
		downState = makeState(downUint, w, h, r);
		overState = makeState(overUint, w, h, r);
		hitTestState = upState;
	}
	
	public function makeState(color:uint, width:int, height:int, round:int):Sprite  
	{  
		var s:Sprite = new Sprite();  
		s.graphics.lineStyle(2);  
		s.graphics.beginFill(color);  
		s.graphics.drawRoundRect(0, 0, width, height, round);  
		s.graphics.endFill();  
		s.alpha = 0.3;  
		return s;  
	}  

}

class Answers extends Shape
{
	protected var field:Main;
	protected var color:uint = 0x000000;//黒固定
		
	public function Answers(field:Main)
	{
		this.field = field;
	}

	public function draw():void
	{
	}
	
	public function deleteObj():void
	{
		parent.removeChild(this);
	}
	
}

//十字架
class ans000 extends Answers
{
	public function ans000(field:Main, x:Number, y:Number)
	{
		super(field);
		
		this.x = x - 25;
		this.y = y - 50;
		
		draw();
	}
	
	//解答例描写
	override public function draw():void
	{
		graphics.lineStyle(1, color, 1);
		graphics.beginFill(color);
		graphics.lineTo(0, -50);
		graphics.lineTo(50, -50);
		graphics.lineTo(50, 0);
		graphics.lineTo(100,0);
		graphics.lineTo(100, 50);
		graphics.lineTo(50, 50);
		graphics.lineTo(50, 150);
		graphics.lineTo(0,150);
		graphics.lineTo(0, 50);
		graphics.lineTo(-50, 50);
		graphics.lineTo(-50, 0);
		graphics.lineTo(0, 0);
		graphics.endFill();
	}
}

//U字
class ans001 extends Answers
{
	public function ans001(field:Main, x:Number, y:Number)
	{
		super(field);
		
		this.x = x - 25;
		this.y = y;
		draw();
	}
	
	//解答例描写
	override public function draw():void
	{
		graphics.lineStyle(1, color, 1);
		graphics.beginFill(color);
		graphics.lineTo(50, 0);
		graphics.lineTo(50, -100);
		graphics.lineTo(100, -100);
		graphics.lineTo(100,0);
		graphics.lineTo(50, 50);
		graphics.lineTo(0, 50);
		graphics.lineTo(-50, 0);
		graphics.lineTo(-50, -100);
		graphics.lineTo(0, -100);
		graphics.lineTo(0, 0);
		graphics.endFill();
	}

}

//F字
class ans002 extends Answers
{
	public function ans002(field:Main, x:Number, y:Number)
	{
		super(field);
		
		this.x = x;
		this.y = y;
		
		draw();
	}
	
	//解答例描写
	override public function draw():void
	{
		graphics.lineStyle(1, color, 1);
		graphics.beginFill(color);
		graphics.lineTo(50, 0);
		graphics.lineTo(50, 50);
		graphics.lineTo(0, 50);
		graphics.lineTo(0,100);
		graphics.lineTo(-50, 100);
		graphics.lineTo(-50, -100);
		graphics.lineTo(50, -100);
		graphics.lineTo(50, -50);
		graphics.lineTo(0, -50);
		graphics.lineTo(0, 0);
		graphics.endFill();
	}
}

//O字
class ans003 extends Answers
{
	public function ans003(field:Main, x:Number, y:Number)
	{
		super(field);
		
		this.x = x - 25;
		this.y = y - 25;
		
		draw();
	}
	
	//解答例描写
	override public function draw():void
	{
		graphics.lineStyle(1, color, 1);
		graphics.beginFill(color);
		graphics.moveTo(0, -50);
		graphics.lineTo(50, -50);
		graphics.lineTo(100, 0);
		graphics.lineTo(100, 50);
		graphics.lineTo(50,100);
		graphics.lineTo(0, 100);
		graphics.lineTo(-50, 50);
		graphics.lineTo(-50, 0);
		graphics.lineTo(0, -50);
		graphics.moveTo(0, 0);
		graphics.lineTo(50, 0);
		graphics.lineTo(50, 50);
		graphics.lineTo(0, 50);
		graphics.lineTo(0, 0);
		graphics.endFill();
	}
}

//壺
class ans004 extends Answers
{
	public function ans004(field:Main, x:Number, y:Number)
	{
		super(field);
		
		this.x = x - 25;
		this.y = y;
		
		draw();
	}
	
	//解答例描写
	override public function draw():void
	{
		graphics.lineStyle(1, color, 1);
		graphics.beginFill(color);
		graphics.lineTo(0, -100);
		graphics.lineTo(50,-100);
		graphics.lineTo(50, 0);
		graphics.lineTo(100,50);
		graphics.lineTo(50, 100);
		graphics.lineTo(0, 100);
		graphics.lineTo(-50, 50);
		graphics.lineTo(0, 0);
		graphics.endFill();
	}
}

//
class ans005 extends Answers
{
	public function ans005(field:Main, x:Number, y:Number)
	{
		super(field);
		
		this.x = x - 25;
		this.y = y - 50;
		
		draw();
	}
	
	//解答例描写
	override public function draw():void
	{
		graphics.lineStyle(1, color, 1);
		graphics.beginFill(color);
		graphics.lineTo(0, -50);
		graphics.lineTo(50,-50);
		graphics.lineTo(50, 0);
		graphics.lineTo(100,50);
		graphics.lineTo(50, 100);
		graphics.lineTo(50, 150);
		graphics.lineTo(0, 150);
		graphics.lineTo(0, 100);
		graphics.lineTo(-50, 50);
		graphics.lineTo(0, 0);
		graphics.endFill();
	}
}

//Y字
class ans006 extends Answers
{
	public function ans006(field:Main, x:Number, y:Number)
	{
		super(field);
		
		this.x = x - 25;
		this.y = y - 50;
		
		draw();
	}
	
	//解答例描写
	override public function draw():void
	{
		graphics.lineStyle(1, color, 1);
		graphics.beginFill(color);
		graphics.lineTo(50, 0);
		graphics.lineTo(50,-50);
		graphics.lineTo(100, -50);
		graphics.lineTo(100,0);
		graphics.lineTo(50, 50);
		graphics.lineTo(50, 150);
		graphics.lineTo(0, 150);
		graphics.lineTo(0, 50);
		graphics.lineTo(-50, 0);
		graphics.lineTo(-50, -50);
		graphics.lineTo(0, -50);
		graphics.lineTo(0, 0);
		graphics.endFill();
	}
}

//
class ans007 extends Answers
{
	public function ans007(field:Main, x:Number, y:Number)
	{
		super(field);
		
		this.x = x - 25;
		this.y = y - 50;
		
		draw();
	}
	
	//解答例描写
	override public function draw():void
	{
		graphics.lineStyle(1, color, 1);
		graphics.beginFill(color);
		graphics.lineTo(0, -50);
		graphics.lineTo(50,-50);
		graphics.lineTo(50, 50);
		graphics.lineTo(100,50);
		graphics.lineTo(100, 150);
		graphics.lineTo(50, 150);
		graphics.lineTo(50, 100);
		graphics.lineTo(0, 100);
		graphics.lineTo(0, 50);
		graphics.lineTo(-50, 50);
		graphics.lineTo(-50, 0);
		graphics.lineTo(0, 0);
		graphics.endFill();
	}
}

//
class ans008 extends Answers
{
	public function ans008(field:Main, x:Number, y:Number)
	{
		super(field);
		
		this.x = x - 25;
		this.y = y - 50;
		
		draw();
	}
	
	//解答例描写
	override public function draw():void
	{
		graphics.lineStyle(1, color, 1);
		graphics.beginFill(color);
		graphics.lineTo(0, -50);
		graphics.lineTo(50,-50);
		graphics.lineTo(50, 50);
		graphics.lineTo(100,50);
		graphics.lineTo(100, 100);
		graphics.lineTo(50, 100);
		graphics.lineTo(50, 150);
		graphics.lineTo(0, 150);
		graphics.lineTo(0, 50);
		graphics.lineTo(-50, 50);
		graphics.lineTo(-50, 0);
		graphics.lineTo(0, 0);
		graphics.endFill();
	}
}
