/**
 * Copyright kotobuki ( http://wonderfl.net/user/kotobuki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7mBl
 */

package {
  import flash.display.Sprite;
  import flash.events.Event;
  import funnel.*;

  [SWF(backgroundColor="0xCCCCCC")]

  public class MeasureBend extends Sprite {
    // Arduino
    private var arduino:Arduino;

    // 曲げセンサに接続したピン
    private var sensorPin:Pin;

    // 入力を確認するためのシグナルスコープ
    private var signalScope:SignalScope;

    public function MeasureBend() {
      // Arduinoのインスタンスを生成し、曲げセンサに接続したピンを初期化
      arduino = new Arduino(Arduino.FIRMATA);
      sensorPin = arduino.analogPin(0);

      // シグナルスコープを生成
      signalScope = new SignalScope(20, 20, 200, 
                                    "Flex sensor");
      addChild(signalScope);

      addEventListener(Event.ENTER_FRAME, onEnterFrame);
    }

    // 毎フレームごとに以下を実行
    private function onEnterFrame(e:Event):void {
      // シグナルスコープを更新
      signalScope.update(sensorPin);
    }
  }
}
