/**
 * Copyright hktechno ( http://wonderfl.net/user/hktechno )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7m3M
 */

package
{
    import flash.display.Sprite;
    import flash.geom.Point;
    
    public class BSpline extends Sprite
    {
        private var points : Array;
        
        public function BSpline()
        {
            points = new Array();
            
            graphics.lineStyle(1.0, 0xff0000);
            this.addPoint(new Point(10, 10));
            this.addPoint(new Point(10, 10));
            this.addPoint(new Point(10, 10));
            this.addPoint(new Point(100, 300));
            this.addPoint(new Point(200, 200));
            this.addPoint(new Point(300, 10));
            this.addPoint(new Point(400, 200));
            this.addPoint(new Point(400, 200));
            this.addPoint(new Point(400, 200));
            this.draw();
        }
        
        public function addPoint(p:Point) : void
        {
            points.push(p);
            graphics.beginFill(0);
            graphics.drawCircle(p.x, p.y, 5);
            graphics.endFill();
        }
        
        public function draw() : void
        {
            var i:int;            
            var a:Point, b:Point, c:Point, d:Point, j1:Point, j2:Point;
            
            d = null;
            j2 = null;
            
            for(i = 1; i < points.length - 2; i++) {
                if(d != null && j2 != null) {
                    j1 = j2;
                    b = d;
                }
                else {
                    // first junction point
                    a = Point.interpolate(points[i], points[i - 1], 2 / 3);
                    b = Point.interpolate(points[i + 1], points[i], 1 / 3);
                    j1 = Point.interpolate(a, b, 0.5);
                }
                
                // second junction point
                c = Point.interpolate(points[i + 1], points[i], 2 / 3);
                d = Point.interpolate(points[i + 2], points[i + 1], 1 / 3);
                j2 = Point.interpolate(c, d, 0.5);
                
                graphics.moveTo(j1.x, j1.y);
                graphics.cubicCurveTo(b.x, b.y, c.x, c.y, j2.x, j2.y);
            }
        }
    }
}
