/**
 * Copyright WLAD ( http://wonderfl.net/user/WLAD )
 * GNU General Public License, v3 ( http://www.gnu.org/licenses/quick-guide-gplv3.html )
 * Downloaded from: http://wonderfl.net/c/7m18
 */

// forked from tnRaro's flash on 2014-12-16
package {
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.utils.Timer;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.TimerEvent;
    
    [SWF(width="465", height="465", backgroundColor="0", frameRate="60")]
    public class CollapsingParticales extends Sprite {
        
        
        static private const colorTopLeft:Number = 0xA5A514;
        static private const colorBottomLeft:Number = 0x1FA514;
        static private const colorTopRight:Number = 0xA61313;
        static private const colorBottomRight:Number = 0x1484A5;
        
        
        private var sx:int;
        private var sy:int;
        
        private var world:BitmapData;
        private var bitmap:Bitmap;
        
        private var timer:Timer;
        
        private var mx:int;
        private var my:int;
        
        private var ps:Vector.<Poi>;
        
        public function CollapsingParticales() {
            resize(null);
           
            var initClick:Function = function(e:MouseEvent):void
            {
                me(e);
                stage.addEventListener('enterFrame', te);
                stage.removeEventListener('click', initClick);
                stage.addEventListener('mouseDown', me);
            };
            stage.addEventListener('click', initClick);
            stage.addEventListener(Event.RESIZE, resize);
            
            world = new BitmapData(sx, sy, false, 0);
            bitmap = new Bitmap(world);
            
            ps = new Vector.<Poi>();
            
            addChild(bitmap);
            
            mx = sx*.5;
            my = sy*.5;
            
            var sx2:int = int( sx / 2 );
            var sy2:int = int( sy / 2 );
            var c:uint;
            
            for ( var iy:int= 0; iy < sy; iy+=2)
            for ( var ix:int = 0; ix < sx; ix+=2)
            {
                // TOP LEFT 
                if ( ix < sx2 && iy < sy2 )
                    c = colorTopLeft;
                
                // BOTTOM LEFT
                else if ( ix < sx2 && iy >= sy2 )
                    c = colorBottomLeft;
                
                // TOP RIGHT 
                else if ( ix >= sx2 && iy < sy2 )
                    c = colorTopRight;
                
                // BOTTOM RIGHT
                else 
                    c = colorBottomRight;
                
                ps.push(new Poi(ix, iy, c));
            }
            
            te();
        }
        
        private function me(e:MouseEvent):void{
            mx = e.stageX;
            my = e.stageY;
            new Blink( mx, my, this );
        }
        
        public function te(e:*=null ):void {
            world.fillRect(world.rect, 0);
            
            var l:int = ps.length;
            for(var i:int=0;i<l;i++){
                var p:Poi = ps[i];
                
                var t:Number = Math.atan2(my-p.y, mx-p.x);
                
                p.vx += Math.cos(t);
                p.vy += Math.sin(t);
                
                p.x += p.vx;
                p.y += p.vy;
                
                world.setPixel(p.x, p.y, add(world.getPixel(p.x, p.y), p.c));
            }
        }
        
        private function add(p:int, v:int):int{
            var r:int = Math.min(0xff, (p>>16&0xff) + (v>>16&0xff));
            var g:int = Math.min(0xff, (p>>8&0xff) + (v>>8&0xff));
            var b:int = Math.min(0xff, (p&0xff) + (v&0xff));
            return (r<<16^g<<8^b);
        }
        
        public function resize(e:Event):void{
            sx = stage.stageWidth;
            sy = stage.stageHeight;
        }
    }
}
import flash.display.Sprite;
    
    class Poi{
        public var x:Number;
        public var y:Number;
        public var vx:Number;
        public var vy:Number;
        public var c:uint;
        
        public function Poi(_x:int, _y:int, _c:uint){
            x = _x;
            y = _y;
            c = _c;
            vx = 0;
            vy = 0;
        }
    }
    
    class Blink extends Sprite{
        public function Blink( x:Number, y:Number, container:Sprite):void
        {
            this.x = x;
            this.y = y;
            container.addChild( this );
            graphics.beginFill(0xFFFFFF, 0.8);
            graphics.drawCircle(0, 0, 10);
            graphics.endFill();
            addEventListener('enterFrame', hide);
        }
        
        private function hide(e:*):void
        {
            this.alpha -= 0.07;
            scaleX = scaleY = alpha;
            
            if ( this.alpha <= 0 ) 
            {
                removeEventListener('enterFrame', hide);
                parent.removeChild( this );
            }
        }
        
    }