/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7lsB
 */

/*
Matrix3D.prepend();
と同じ機能の関数を作ってみる。
MAC 10,0,2,54,MAC 10,0,12,36,MAC 10,0,22,87で動作確認。

◆処理内容
appendとは左右の順番が入れ替わっただけ。

◆確認方法
各要素をrandomで-100〜100の値を入れて、prependする。
小数点2桁目の誤差が出る場合がある。

ところどころ20倍しているところがあるけど、なんでこうなるかはよくわかんない。
【追記】
10,0,22,87で20倍のバグは無くなった模様。

prepend()
http://help.adobe.com/ja_JP/AS3LCR/Flash_10.0/flash/geom/Matrix3D.html#prepend()
*/
package {
	import flash.display.Sprite;
	import flash.geom.Matrix3D;
	import flash.text.TextField;
	import flash.system.Capabilities;
	import flash.geom.Vector3D;
	public class Main extends Sprite {
		public function Main() {
			var txt:String="◆同機能関数Mtrx3D.prepend　"+Capabilities.version+"での実行結果\n\n";

			//確認用の値を用意
			var entity:Matrix3D=new Matrix3D(Util.random16());
			var parameter:Matrix3D=new Matrix3D(Util.random16());
			var entity1:Matrix3D=entity.clone();
			var entity2:Matrix3D=entity.clone();
			var parameter1:Matrix3D=parameter.clone();
			var parameter2:Matrix3D=parameter.clone();
			
			//実行			
			entity1.prepend(parameter1);
			Mtrx3D.prepend(entity2,parameter2);
			
			//確認
			var entity1RawData:Vector.<Number>=entity1.rawData;
			txt+="↓Matrix3D.prependの結果\n"+entity1RawData+"\n";
			var entity2RawData:Vector.<Number>=entity2.rawData;
			txt+="\n↓同機能関数Mtrx3D.prependの結果\n"+entity2RawData+"\n\n";
			txt+=Util.hikaku(entity1RawData,entity2RawData);
			
			
			//テキストフィールドを作りtxtを流し込み。
			var tf:TextField = new TextField();
			tf.width=stage.stageWidth;
			tf.height=stage.stageHeight;
			tf.wordWrap=true;
			stage.addChild(tf);
			tf.text=txt;


		}
	}
}
import flash.display.Sprite;
class Mtrx3D extends Sprite {
	import flash.geom.Matrix3D;
	public static function prepend(entity:Matrix3D,rhs:Matrix3D):void{
		var r:Vector.<Number> = rhs.rawData;
		var e:Vector.<Number> = entity.rawData;
		var er:Vector.<Number> = new Vector.<Number>();
		
		//バグ対応。10,0,22,87未満の場合バグを含むように。
		var bug:int = 1;
		if(Util.version() <1000022087){
			bug = 20;
		}
		
		er[0] = e[0]*r[0]+e[4]*r[1]+e[8]*r[2]+e[12]*r[3]*bug;
		er[1] = e[1]*r[0]+e[5]*r[1]+e[9]*r[2]+e[13]*r[3]*bug;
		er[2] = e[2]*r[0]+e[6]*r[1]+e[10]*r[2]+e[14]*r[3]*bug;
		er[3] = e[3]*r[0]+e[7]*r[1]+e[11]*r[2]+e[15]*r[3];
		
		er[4] = e[0]*r[4]+e[4]*r[5]+e[8]*r[6]+e[12]*r[7]*bug;
		er[5] = e[1]*r[4]+e[5]*r[5]+e[9]*r[6]+e[13]*r[7]*bug;
		er[6] = e[2]*r[4]+e[6]*r[5]+e[10]*r[6]+e[14]*r[7]*bug;
		er[7] = e[3]*r[4]+e[7]*r[5]+e[11]*r[6]+e[15]*r[7];
		
		er[8] = e[0]*r[8]+e[4]*r[9]+e[8]*r[10]+e[12]*r[11]*bug;
		er[9] = e[1]*r[8]+e[5]*r[9]+e[9]*r[10]+e[13]*r[11]*bug;
		er[10] = e[2]*r[8]+e[6]*r[9]+e[10]*r[10]+e[14]*r[11]*bug;
		er[11] = e[3]*r[8]+e[7]*r[9]+e[11]*r[10]+e[15]*r[11];
		
		er[12] = e[0]*r[12]+e[4]*r[13]+e[8]*r[14]+e[12]*r[15];
		er[13] = e[1]*r[12]+e[5]*r[13]+e[9]*r[14]+e[13]*r[15];
		er[14] = e[2]*r[12]+e[6]*r[13]+e[10]*r[14]+e[14]*r[15];
		er[15] = e[3]*r[12]*bug+e[7]*r[13]*bug+e[11]*r[14]*bug+e[15]*r[15];
		entity.rawData = er;
	}
}
class Util {
	import flash.system.Capabilities;	
	public static function version():uint{
		//例10,0,22,87→10+00+022+087→1000022087
		var ver_array:Array = Capabilities.version.substr(4).split(",");
		return int(ver_array[0])*100000000+int(ver_array[1])*1000000+int(ver_array[2])*1000+int(ver_array[3]);
	}
	
	public static function hikaku(v0:Vector.<Number>,v1:Vector.<Number>):String {
		var _str:String="↓二つのMatrixの要素毎の差\n";
		var _n:int=v0.length;
		for (var i:int=0; i<_n; i++) {
			_str += "["+i+"]:"+(v0[i]-v1[i])+"\n";
		}
		return _str;
	}

	public static function random16():Vector.<Number> {
		var _v:Vector.<Number>=new Vector.<Number>(16,true);
		for (var i:int=0; i<16; i++) {
			_v[i]=Math.random()*200-100;
		}
		return _v;
	}
}
