/**
 * Copyright ratoontoon ( http://wonderfl.net/user/ratoontoon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7lga
 */

// forked from fzmn's forked from: fladdict challenge for professionals
// forked from checkmate's fladdict challenge for professionals
/**
 * Theme:
 * Play with BitmapPatterBuilder.
 * Purpose of this trial is to find the possibility of the dot pattern.
 *
 * by Takayuki Fukatsu aka fladdict
 **/
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.geom.Matrix;
    
    public class Professional extends Sprite {
        protected const g:Graphics = graphics;
        protected const dot:Array = [['010','111','010'],['232','333','232']];
        protected const chars:Array = [_char(0x69bd96),_char(0x262222),_char(0x69248f),
                                     _char(0x692196),_char(0xaaaf22),_char(0xf8e11e),
                                     _char(0x69e996),_char(0xf92244),_char(0x696996),
                                     _char(0x699796),_char(0x010010,1),_char(0x000700,3),
                                     _char(0x000000,1)];
        protected var pattern:BitmapData;
        protected var colors:Array;
        protected var hue:Number = int(Math.random()*10)/10;
        protected var matrix:Matrix = new Matrix();
        protected var date:Date = new Date();
        protected var string:String;
        
        public function Professional() {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            //generate bitmap pattern.
            build();
            draw();
            addEventListener(Event.ENTER_FRAME,enterFrame);
        }
        
        protected function enterFrame(ev:Event):void {
            var d:Date = new Date();
            if(d.time-date.time>1000) {
                date = d;
                build();
            } else if(d.time-date.time>500) {
                string = string.replace(/:/g,' ');
            } else {
                return;
            }
            draw();
        }
        
        protected function build():void {
            string = (date.fullYear+'-'+(date.month+1)+'-'+date.date+' '+
                      date.hours+':'+date.minutes+':'+date.seconds+'  ').replace(/(-|:|\s)(\d)(?=-|:|\s)/g,"$10$2");
            
            if(date.seconds%4==0 || !pattern) {
                var s:Number = 1+int(Math.random()*5);
                matrix.identity();
                matrix.scale(s,s);
                matrix.rotate(360*Math.random());
                hue += 1/10;
                var c:uint = _color(hue);
                colors = [0x00000000|c,0x22000000|c,0xdd000000|c,0xff000000|c];
                if(date.seconds%6==0) colors = colors.reverse();
            }
        }
        
        protected function draw():void {
            var pixels:Array = [];
            for(var i:int=0;i<string.length;i++) {
                var char:String = string.substr(i,1);
                var index:uint;
                switch(char) {
                    case ':':
                        index = 10;
                        break;
                    case '-':
                        index = 11;
                        break;
                    case ' ':
                        index = 12;
                        break;
                    default:
                        index = parseInt(char);
                }
                for(var j:int=0;j<21;j++) {
                    if(pixels[j]==null) pixels[j] = [];
                    pixels[j] = pixels[j].concat(chars[index][j]);
                }
            }
            
            for(i=0;i<21;i++) {
                pixels[i+21] = pixels[i].slice(87).concat(pixels[i].slice(0,87));
                pixels[i+42] = pixels[i].slice(171).concat(pixels[i].slice(0,171));
            }
            
            pattern = BitmapPatternBuilder.build(pixels,colors);
            
            g.clear();
            g.beginBitmapFill(pattern,matrix,true,true);
            g.drawRect(0,0,480,480);
            g.endFill();
        }
    	
        protected function _color(hue:Number):uint {
            var rgb:Array = [];
            var h:Number = (hue-int(hue))*6;
            var f:Number = h-int(h);
            var q:Number = 0xff*4/5*(1-f);
            var t:Number = 0xff*4/5*f;
            
            switch(int(h)) {
                case 0 :
                    rgb = [0xcc,t,0];
                    break;
                case 1 :
                    rgb = [q,0xcc,0];
                    break;
                case 2 :
                    rgb = [0,0xcc,t];
                    break;
                case 3 :
                    rgb = [0,q,0xcc];
                    break;
                case 4 :
                    rgb = [t,0,0xcc];
                    break;
                case 5 :
                    rgb = [0xcc,0,q];
                    break;
            }
            return rgb[0]<<16|rgb[1]<<8|rgb[2]<<0;
        }
        
        protected function _char(value:uint,len:int=4):Array {
            var array:Array = [];
            for(var i:int=0;i<7;i++) {
                var a:int = (value>>((6-i)*4)&0xf)<<1;
                for(var j:int=0;j<3;j++) {
                    var str:String = '';
                    for(var k:int=0;k<len+1;k++) str += dot[a>>(len-k)&1][j];
                    array.push(str.match(/\d/g));
                }
            }
            return array;
        }
    }
}

/**-----------------------------------------------------
 * Use following BitmapPatternBuilder class 
 * 
 * DO NOT CHANGE any codes below this comment.
 *
 * -----------------------------------------------------
*/
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Graphics;
    
class BitmapPatternBuilder{
    /**
     * creates BitmapData filled with dot pattern.
     * First parameter is 2d array that contains color index for each pixels;
     * Second parameter contains color reference table.
     *
     * @parameter pattern:Array 2d array that contains color index for each pixel.
     * @parameter colors:Array 1d array that contains color table.
     * @returns BitmapData
     */
    public static function build(pattern:Array, colors:Array):BitmapData{
        var bitmapW:int = pattern[0].length;
        var bitmapH:int = pattern.length;
        var bmd:BitmapData = new BitmapData(bitmapW,bitmapH,true,0x000000);
        for(var yy:int=0; yy<bitmapH; yy++){
            for(var xx:int=0; xx<bitmapW; xx++){
                var color:int = colors[pattern[yy][xx]];
                bmd.setPixel32(xx, yy, color);
            }
        }
        return bmd;
    }
    
    /**
     * short cut function for Graphics.beginBitmapFill with pattern.
     */
    public static function beginBitmapFill(pattern:Array, colors:Array, graphics:Graphics):void{
        var bmd:BitmapData = build(pattern, colors);
        graphics.beginBitmapFill(bmd);
        bmd.dispose();        
    }
}