/**
 * Copyright y_tama ( http://wonderfl.net/user/y_tama )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7leW
 */

// forked from ProjectNya's マウスを追う (1)
////////////////////////////////////////////////////////////////////////////////
// マウスを追う (1)
//
// マウスの動きとムービークリップ (2)
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=94
// [AS3.0] マウスの動きを追尾する (1)
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1268
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.events.Event;
    import net.hires.debug.Stats;

    [SWF(backgroundColor="#FFFFFF", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private static var max:uint = 3;
        private var circles:Array;

        public function Main() {
            //Wonderfl.capture_delay(1);
            init();
            //addChild(new Stats());
        }

        private function init():void {
            var cx:uint = stage.stageWidth/2;
            var cy:uint = stage.stageHeight/2;
            var leader:Leader = new Leader(0x3366FF);
            addChild(leader);
            leader.x = cx;
            leader.y = cy;
            circles = new Array();
            var circle1:Circle = new Circle(0x33CC00, leader);
            addChild(circle1);
            circle1.x = stage.stageWidth/2;
            circle1.y = stage.stageHeight/2;
            var circle2:Circle = new Circle(0xFF9900, circle1);
            addChild(circle2);
            circle2.x = stage.stageWidth/2;
            circle2.y = stage.stageHeight/2;
            var circle3:Circle = new Circle(0xFF6699, circle2);
            addChild(circle3);
            circle3.x = stage.stageWidth/2;
            circle3.y = stage.stageHeight/2;
            circles = new Array();
            circles.push(leader);
            circles.push(circle1);
            circles.push(circle2);
            circles.push(circle3);
            addEventListener(Event.ENTER_FRAME, update, false, 0, true);
        }
        private function update(evt:Event):void {
            for (var n:uint = 0; n < circles.length; n++) {
                var circle:Object = circles[n];
                circle.update();
            }
        }
        
    }

}


//////////////////////////////////////////////////
// Leaderクラス
//////////////////////////////////////////////////

import flash.display.Sprite;

class Leader extends Sprite {
    private static var radius:uint = 20;
    private var color:uint = 0xFFFFFF;
    private var target:Object = {x: 0, y: 0};
    private static var deceleration:Number = 0.06;

    public function Leader(c:uint) {
        color = c;
        draw();
    }

    private function draw():void {
        graphics.beginFill(color);
        graphics.drawCircle(0, 0, radius);
        graphics.endFill();
    }
    public function update():void {
        x += (stage.mouseX - x)*deceleration;
        y += (stage.mouseY - y)*deceleration;
    }

}


//////////////////////////////////////////////////
// Circleクラス
//////////////////////////////////////////////////

//import flash.display.Sprite;

class Circle extends Sprite {
    private static var radius:uint = 20;
    private var color:uint = 0xFFFFFF;
    private var target:Object = {x: 0, y: 0};
    private static var deceleration:Number = 0.06;

    public function Circle(c:uint, t:Object) {
        color = c;
        target = t;
        draw();
    }

    private function draw():void {
        graphics.beginFill(color);
        graphics.drawCircle(0, 0, radius);
        graphics.endFill();
    }
    public function update():void {
        x += (target.x - x)*deceleration;
        y += (target.y - y)*deceleration;
    }

}
