/**
 * Copyright you_KAZE ( http://wonderfl.net/user/you_KAZE )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7kTo
 */

// forked from okoi's AQUAFLARE
package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    
    import flash.geom.Point;
    import flash.filters.BlurFilter;
    import flash.filters.ColorMatrixFilter;
    import flash.geom.Matrix;
    
    [SWF(width = "465", height = "465", frameRate = "60")]
    
    
    /**
     * ...
     * @author 
     */
    public class Main extends Sprite 
    {
        public static const WIDTH:int = 465;
        public static const HEIGHT:int = 465;
        
        private var back:BitmapData;
        private var canvas:BitmapData;
        
        private var particles:/*SparkParticle*/Array;
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            var mat:Matrix = new Matrix();
            mat.createGradientBox(WIDTH, HEIGHT,Math.PI/2);
            //graphics.beginFill(0);
            graphics.beginGradientFill(
                        "linear",
                        [0, 0x555555, 0],
                        [1, 1, 1],
                        [50, 200, 255],
                        mat
                        );
            graphics.drawRect(0, 0, WIDTH, HEIGHT);
            graphics.endFill();
            
            back = new BitmapData( WIDTH, HEIGHT, true, 0 );
            addChild( new Bitmap(back) );
            
            canvas = new BitmapData( WIDTH, HEIGHT, true, 0 );
            addChild( new Bitmap(canvas) );
            
            particles = [];
            
            addEventListener( Event.ENTER_FRAME, EnterFrameHandler );
        }
        
        private function EnterFrameHandler( e:Event ) : void
        {
            var i:int;
            
            var colorMat:ColorMatrixFilter = new ColorMatrixFilter([
                1, 0, 0, 0, 0,
                0, 1, 0, 0, 0,
                0, 0, 1, 0, 0,
                0, 0, 0, 0.5, 0
            ]);
            
            canvas.lock();
            //canvas.fillRect(canvas.rect, 0);
            canvas.applyFilter( canvas, canvas.rect, new Point(), colorMat );
            for ( i = particles.length - 1; i >= 0; i-- )
            {
                particles[i].Move();
                var x:Number = particles[i].x + WIDTH / 2;
                var y:Number = 350 - particles[i].y;
                var z:Number = particles[i].z * 0.3;
                
                canvas.setPixel32( x, y + z, 0xFF00bfff );
                
                if ( particles[i].life <= 0 )    particles.splice( i, 1 );
            }
            canvas.unlock();
            
            
            back.lock();
            back.applyFilter( back, back.rect, new Point(), new BlurFilter(4,4) );
            back.draw( canvas, null, null, "add" );
            back.unlock();
            
            for ( i = 0; i < 7; i++ )
            {
                AddSpark();
            }
        }
        
        private function AddSpark() : void
        {
            particles.push( new SparkParticle( (Math.random()*100 - 50), (Math.random()*10 - 5) ) );
        }
    }
    
}

class SparkParticle {
    
    public var x:Number = 0;
    public var y:Number = 0;
    public var z:Number = 0;
    
    private var _vx:Number = 0;
    private var _vy:Number = 0;
    private var _vz:Number = 0;
    
    public var life:int;
    
    public function SparkParticle( x:Number, y:Number ) {
        this.x = x;
        this.y = y;
        
        _vx = Math.random() * 5 - 2.5;
        _vz = Math.random() * 5 - 2.5;
        _vy = Math.random() * 10;
        
        life = int(Math.random() * 300);
    }
    
    public function Move() : void {
        
        if ( y + _vy < 0 )
        {
            var rate:Number = y / Math.abs(_vy);
            
            x = x + _vx * rate;
            y = y + _vy * rate;
            z = z + _vz * rate;

            _vx = Math.random() * 5 - 2.5;
            _vz = Math.random() * 5 - 2.5;            
            _vy = (_vy * -1) * 0.4;
            
        }else
        {
            x = x + _vx;
            y = y + _vy;
            z = z + _vz;
            
            _vy -= 0.2;
        }

        var sin:Number = Math.sin( 90 / 180 * Math.PI );
        var cos:Number = Math.cos( 90 / 180 * Math.PI );
        var xx:Number = x * cos + z * -sin;
        var zz:Number = x * sin + z * cos;
        var r:Number = Math.sqrt( xx * xx + zz * zz );
        xx /= r;
        zz /= r;
        x += xx/2;
        z += zz/2;
        
        life--;
    }

}