/**
 * Copyright devm ( http://wonderfl.net/user/devm )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7kAM
 */

//not optimized, thrown together pretty quick
//just a proof of concept, do what you want with it

package {
	
	import flash.utils.Timer;
	import flash.text.TextField;
	import flash.text.TextFieldType;
	import flash.events.MouseEvent;
	import flash.events.SampleDataEvent;
	import flash.events.TimerEvent;
	import flash.media.Sound;
	import flash.media.SoundChannel;
    import flash.display.Sprite;
    
    public class MorseCode extends Sprite {
    	
    		private var snd:Sound;
    		private var ch:SoundChannel;
    		private var codes:Array;
    		private var t:TextField;
    		private var b:Sprite;
    		public var tone:Number;
    		
    		public const DOT:Number = 50;
    		public const DASH:Number = 150;
    		
    		private var codeArray:Array;
    		private var cursor:int = 0;
    		
    		private var timer:Timer;
    	
		public function MorseCode() {
        		t = new TextField();
        		t.width = 200;
			t.height = 50;
			t.x = (stage.stageWidth-t.width)/2;
			t.y = (stage.stageHeight-t.textHeight)/2;
			t.text = 'hello world';
			t.type = TextFieldType.INPUT;
			t.border = true;
			addChild(t);
			
			b = new Sprite();
			b.graphics.beginFill(0xFF0000);
			b.graphics.drawRect(0, 0, 100, 50);
			b.graphics.endFill();
			b.y = t.y + t.height + 10;
			b.x = t.x;
			addChild(b);
			b.addEventListener(MouseEvent.CLICK, onMouseClick);
        		
        		codes = new Array();
			codes['a'] = [".", "-"];
			codes['b'] = ["-", ".", ".", "."];
			codes['c'] = ["-", ".", "-", "."];
			codes['d'] = ["-", ".", "."];
			codes['e'] = ["."];
			codes['f'] = [".", ".", "-", "."];
			codes['g'] = ["-", "-", "."];
			codes['h'] = [".", ".", ".", "."];
			codes['i'] = [".", "."];
			codes['j'] = [".", "-", "-", "-"];
			codes['k'] = ["-", ".", "-"];
			codes['l'] = [".", "-", ".", "."];
			codes['m'] = ["-", "-"];
			codes['n'] = ["-", "."];
			codes['o'] = ["-", "-", "-"];
			codes['p'] = [".", "-", "-", "."];
			codes['q'] = ["-", "-", ".", "-"];
			codes['r'] = [".", "-", "."];
			codes['s'] = [".", ".", "."];
			codes['t'] = ["-"];
			codes['u'] = [".", ".", "-"];
			codes['v'] = [".", ".", ".", "-"];
			codes['w'] = [".", "-", "-"];
			codes['y'] = ["-", ".", "-", "-"];
			codes['z'] = ["-", "-", ".", "."];
			
			codes['1'] = [".", "-", "-", "-", "-"];
			codes['2'] = [".", ".", "-", "-", "-"];
			codes['3'] = [".", ".", ".", "-", "-"];
			codes['4'] = [".", ".", ".", ".", "-"];
			codes['5'] = [".", ".", ".", ".", "."];
			codes['6'] = ["-", ".", ".", ".", "."];
			codes['7'] = ["-", "-", ".", ".", "."];
			codes['8'] = ["-", "-", "-", ".", "."];
			codes['9'] = ["-", "-", "-", "-", "."];
			codes['0'] = ["-", "-", "-", "-", "-"];
			
			snd = new Sound();
			snd.addEventListener(SampleDataEvent.SAMPLE_DATA, onSampleData);
			
			
        }
        
        private function onMouseClick( evt:MouseEvent ):void{
        		createCodeArray();
        }
        
        private function createCodeArray():void{
			if(ch) ch.stop();        	
        		if(timer) timer.stop();
        		cursor = 0;
        		var textArray:Array = t.text.toLowerCase().split("");
        		codeArray = new Array();
        		for(var i:int = 0; i < textArray.length; i++){
        			if(textArray[i] != " "){
	        			for( var j:int = 0; j < codes[textArray[i]].length; j++){
	        				
	        				if(codes[textArray[i]][j] == "-"){
	        					codeArray.push({tone:0.4, code:DASH});
	        				}else{
	        					codeArray.push({tone:0.4, code:DOT});
	        				}
	        			}
	        			
	        			//space between two letters
	        			codeArray.push({tone:0, code:DOT});
	        			codeArray.push({tone:0, code:DOT});
	        		}else{
	        			//four dots plus three spaces = one word seperation
	        			codeArray.push({tone:0, code:DOT});
	        			codeArray.push({tone:0, code:DOT});
	        			codeArray.push({tone:0, code:DOT});
	        			codeArray.push({tone:0, code:DOT});
	        		}
        		}
        		doMorse();
        }
        
        
        private function doMorse():void{
        		tone = codeArray[cursor].tone;
        		timer = new Timer(codeArray[cursor].code, 1);
        		timer.addEventListener(TimerEvent.TIMER_COMPLETE, onTimerComplete);
        		if(ch) ch.stop();
        		ch = snd.play();
        		timer.start();
        		
        		cursor++;
        }
        
        
        private function onTimerComplete( evt:TimerEvent ):void{
        		ch.stop();
        		
        		if(cursor < codeArray.length){
        			timer.removeEventListener(TimerEvent.TIMER_COMPLETE, onTimerComplete);
        			timer = new Timer( DOT, 1 );
        			timer.addEventListener(TimerEvent.TIMER_COMPLETE, onSpaceComplete);
        			timer.start();
        		}
        }
        
        private function onSpaceComplete( evt:TimerEvent ):void{
        		timer.removeEventListener(TimerEvent.TIMER_COMPLETE, onSpaceComplete);
        		doMorse();
        }
        
        
		private function onSampleData(event:SampleDataEvent):void  {
			for (var c:int = 0; c < 8192; c++) {
				var rad:Number = (Number( c + event.position )*tone/Math.PI);
				var amp:Number = Math.sin(rad) / 4;
				event.data.writeFloat(amp);
				event.data.writeFloat(amp);
			}
		}
    }
}