/**
 * Copyright _wonder ( http://wonderfl.net/user/_wonder )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7jxh
 */

// forked from _wonder's Papervision3D練習
package {
    import org.papervision3d.materials.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.view.*;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    [SWF(backgroundColor=0)]
    public class Sample extends BasicView {
        private var sphere:Sphere;
        private var pastPosX:Number = 0;
        private var pastPosY:Number = 0;
        private var moveflag:Boolean = false;
        private var speedX:Number = 0;
        private var speedY:Number = 0;
        private var dec:Number = 0.1;
        
        public function Sample() {
            var material:WireframeMaterial = new WireframeMaterial(0XFF0000);
            sphere = new Sphere(material, 300, 10, 10);
            scene.addChild( sphere );
            startRendering();
            
            addEventListener(Event.ENTER_FRAME, enterframe);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, mousedown);
            stage.addEventListener(MouseEvent.MOUSE_UP, mouseup);
        }
        
        private function mousedown(e:MouseEvent):void {
            moveflag = true;
        }
        
        private function mouseup(e:MouseEvent):void {
            moveflag = false;
        }
        
        private function enterframe(e:Event):void {
            if( moveflag ){
                speedY = mouseX - pastPosY;
                pastPosY = mouseX;
                
                speedX = mouseY - pastPosX;
                pastPosX = mouseY;
            }
            
            speedX = speedX - (speedX * dec);
            speedY = speedY - (speedY * dec);
            sphere.rotationY -= speedY;
            sphere.rotationX += speedX;
        }
    }
}