/**
 * Copyright mmlemon_ ( http://wonderfl.net/user/mmlemon_ )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7jNH
 */

package
{
	import flash.accessibility.Accessibility;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.events.TimerEvent;
	import flash.geom.Point;
	import flash.media.Sound;
	import flash.media.SoundChannel;
	import flash.media.SoundMixer;
	import flash.net.URLRequest;
	import flash.utils.ByteArray;
	import flash.utils.Timer;
	
	/**
	 * マウスを使って線を書きます。
     * 書いた線がうごきます。
    * どこかでみたような感じですね。
	 */
	[SWF(backgroundColor=0x0,frameRate=60,width=465,height=465)]
	public class ShakeLine extends Sprite
	{
		
		private var m_strokes:Vector.<Vector.<Point>>;
		private var m_isDown:Boolean = false;
		private var m_timer:Timer;
		private var m_snd:Sound;
		private var m_sndChannel:SoundChannel;
		private var m_sndVolume:Number;
		
		private function init():void
		{
			m_strokes = new Vector.<Vector.<Point>>();
			stage.addEventListener(MouseEvent.MOUSE_DOWN, startDraw, false, 0, false);
			stage.addEventListener(MouseEvent.MOUSE_UP, stopDraw, false, 0, false);
			m_timer = new Timer(100);
			m_timer.addEventListener(TimerEvent.TIMER, timerHandler, false, 0, false);
		}
		private function timerHandler(event:TimerEvent):void
		{
			var len:uint = m_strokes.length;
			graphics.clear();
			graphics.lineStyle(1, 0xffffff, 1);
			var rx:Number;
			var ry:Number;
			for(var i:uint=0; i < len; i++)
			{
				var inner:Vector.<Point> = m_strokes[i];
				var innerlen:uint = m_strokes[i].length;
				rx = Math.random()*5-10;
				ry = Math.random()*5-10;
				graphics.moveTo(inner[0].x+rx, inner[0].y+ry);
				for(var j:uint = 1; j < innerlen; j++)
				{
					var pt:Point = inner[j];
					rx = Math.random()*5-10;
					ry = Math.random()*5-10;
					graphics.lineTo(pt.x+rx, pt.y+ry);
				}
			}
			graphics.endFill();
		}
		private function startDraw(event:MouseEvent):void
		{
			m_isDown = true;
			
			var newVec:Vector.<Point> = new Vector.<Point>();
			var pt:Point = new Point(event.stageX, event.stageY);
			if(m_strokes.length > 0){
				m_strokes.push(new Vector.<Point>());
			}
			else{
				m_strokes[0] = new Vector.<Point>();
			}
			m_strokes[m_strokes.length-1].push(pt);
			stage.addEventListener(MouseEvent.MOUSE_MOVE, draw, false, 0, false);
			if(!m_timer.running){
				m_timer.start();
			}
		}
		private function draw(event:MouseEvent):void
		{
			m_strokes[m_strokes.length-1].push(new Point(event.stageX, event.stageY));
		}
		private function stopDraw(event:MouseEvent):void
		{
			stage.removeEventListener(MouseEvent.MOUSE_MOVE, draw, false);
			m_isDown = false;
		}
		public function ShakeLine()
		{
			init();
		}
	}
}