/**
 * Copyright ulrichz14 ( http://wonderfl.net/user/ulrichz14 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7irT
 */

// forked from ganad's gravitation
package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.MovieClip;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.ColorTransform;
    import flash.display.Sprite;
    /**
     * ...
     * @author ganad
     */
    public class Main extends Sprite 
    {
        public var sun:Planet = new Planet(1000, 0, 0);
        public var planetArr:Array = new Array();
        public var planet:Planet;
        public var bmp:Bitmap = new Bitmap(new BitmapData(stage.stageWidth, stage.stageHeight, true,0xff000000));
        public const G:int = 5;
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            var mc:MovieClip = new MovieClip();
            mc.graphics.beginFill(0xffff00, 1);
            mc.graphics.drawCircle(275,200, 10);
            mc.graphics.endFill();
            removeEventListener(Event.ADDED_TO_STAGE, init);
            stage.addChild(bmp);
            stage.addChild(mc);
            sun.x = 275;
            sun.y = 200;
            planet = new Planet(1, 10, -10);
            planet.x = 275;
            planet.y = 150;
            planetArr.push(planet);
            planet = new Planet(1, 7, 3);
            planet.x = 275;
            planet.y = 150;
            planetArr.push(planet);
            planet = new Planet(40, 5, 5);
            planet.x = 275;
            planet.y = 100;
            planetArr.push(planet);
            planet = new Planet(30, 40, 9);
            planet.x = 275;
            planet.y = 150;
            planetArr.push(planet);
            addEventListener(Event.ENTER_FRAME, ent);
            // entry point
        }
        private function ent(e:Event = null):void {
            bmp.bitmapData.colorTransform(bmp.bitmapData.rect, new ColorTransform(.8,.8,.8));
            for (var i:int = 0; i < planetArr.length; i++) {
                var planet:Planet = planetArr[i];
                var tmpx:Number = planet.x;
                var tmpy:Number = planet.y;
                var dx:Number = sun.x-planet.x;
                var dy:Number = sun.y-planet.y;
                var dist:Number = dx * dx + dy * dy;
                var angle:Number = Math.atan2(dy, dx);
                var F:Number = G * sun.mass / dist;
                var vx:Number = F * Math.cos(angle);
                var vy:Number = F * Math.sin(angle);
                planet.vx += vx;
                planet.vy += vy;
                planet.x += planet.vx;
                planet.y += planet.vy;
                lineTo(bmp.bitmapData, tmpx, tmpy, planet.x, planet.y, 0xffff0000);
            }
        }
        public function lineTo(bmp:BitmapData,startX:int,startY:int,tx:int,ty:int,color:uint=0xffffff):void {
            var sx:Number=startX;
            var sy:Number=startY;
            var dx:int=Math.abs(tx-startX);
            var dy:int=Math.abs(ty-startY);
            if (dx>dy) {
                for (var i:int=0; i<dx; i++) {
                    bmp.setPixel32(sx,sy,color);
                    sx>tx?sx--:sx++;
                    sy=startY+(dy/dx)*i*((sy<ty)?1:-1);
                }
            }else{
                for (i=0; i<dy; i++) {
                    bmp.setPixel32(sx,sy,color);
                    sx<tx?sx=startX+(dx/dy)*i:sx=startX-(dx/dy)*i;
                    sy>ty?sy--:sy++;
                }
            }
        }
        
    }
    
}

    /**
     * ...
     * @author ganad
     */
    class Planet
    {
        public var x:Number=0;
        public var y:Number = 0;
        public var vx:Number;
        public var vy:Number;
        private var Mass:int;
        public function Planet(mass:int=100, vx:Number=80,vy:Number=0) :void
        {
            this.Mass = mass;
            this.vx = vx;
            this.vy = vy;
        }
        public function get mass():int {
            return Mass;
        }
        
    }

