/**
 * Copyright yooyke ( http://wonderfl.net/user/yooyke )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7hkU
 */

// forked from paq's VoiceChat
package 
{
    import com.bit101.components.ComboBox;
    import com.bit101.components.InputText;
    import com.bit101.components.PushButton;
    import com.bit101.components.RadioButton;
    import com.bit101.components.Text;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.media.Sound;
    import flash.net.URLLoader;
    import flash.net.URLRequest;
    import flash.net.URLRequestHeader;
    import flash.net.URLRequestMethod;
    import flash.net.URLVariables;
    import flash.ui.Keyboard;
    import net.user1.reactor.IClient;
    import net.user1.reactor.Reactor;
    import net.user1.reactor.ReactorEvent;
    import net.user1.reactor.Room;
    import net.user1.reactor.RoomEvent;
    
    /**
     * Union と Google TTS を使ったチャット
     * 日本語は使えない
     * 
     * @author paq89
     */
    [SWF(width="465", height="465", backgroundColor="0xFFFFFF", frameRate="60")]
    public class Main extends Sprite 
    {
        private var _reactor:Reactor;
        private var _room:Room;
        private var _sound:Sound;
        private var _header:URLRequestHeader;
        private var _request:URLRequest;
        private var _inputText:InputText;
        private var _outputText:Text;
        private var _variable:URLVariables;
        private var _languages:Array = ["en", "de", "fr", "es", "ru", "it"];
        private var _comboBox:ComboBox;
        
        // Constructor
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
            graphics.beginFill(0xFFFFFF);
            graphics.drawRect(0, 0, 465, 465);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            // init google tts
            _request = new URLRequest("http://paq-web.appspot.com/proxy");
            _request.method=URLRequestMethod.POST;
            _variable = new URLVariables();
            _request.data = _variable;
            
            // init union reactor
            _reactor = new Reactor();
            _reactor.addEventListener(ReactorEvent.READY, _onReady);
            _reactor.connect("tryunion.com", 80);
            
            // build ui
            _inputText = new InputText(this, 0, 465 - 20, "");
            _inputText.width = 465 - 100;
            _inputText.height = 20;
            _inputText.addEventListener(KeyboardEvent.KEY_UP, _onKeyUp);
            
            _outputText = new Text(this, 0, 0);
            _outputText.width = 465;
            _outputText.height = 465 - 20;
            
            new PushButton(this, 465 - 100, 465 - 20, "SEND", _onSend);
            _comboBox = new ComboBox(this, 465 - 40, 0, "", _languages);
            _comboBox.width = 40;
            _comboBox.selectedIndex = 0;
        }
        
        private function _onKeyUp(e:KeyboardEvent):void 
        {
            if (e.keyCode == Keyboard.ENTER) {
                _onSend(e);
            }
        }
        
        private function speak(text:String):void
        {
            _sound = new Sound();
            _sound.addEventListener(Event.COMPLETE, _onComplete);
            _variable.url = "http://translate.google.com/translate_tts?tl=" + text.slice(0,2) + "&q=" + encodeURI(text.slice(2));
            // _request.url = "http://translate.google.com/translate_tts?tl=" + text.slice(0,2) + "&q=" + encodeURI(text.slice(2));
            // _request.url = "http://paq-web.appspot.com/proxy?url=" +  encodeURIComponent("http://translate.google.com/translate_tts?tl=" + text.slice(0, 2) + "&q=" + text.slice(2));
            _sound.load(_request);
        }
        
        private function displayMessage(text:String):void
        {
            _outputText.text = text + "\n" + _outputText.text;
        }
        
        private function _onReady(e:ReactorEvent):void 
        {
            _reactor.self().setAttribute("USERNAME", this.root.loaderInfo.parameters["viewer.displayName"]);
            
            _room = _reactor.getRoomManager().createRoom("wonderfl_paq_voice_chat");
            _room.addEventListener(RoomEvent.ADD_OCCUPANT, _onAddOccupant)
            _room.addEventListener(RoomEvent.REMOVE_OCCUPANT, _onRemoveOccupant);
            _room.addMessageListener("CHAT_MESSAGE", _onChatMessage);
            _room.join();
        }
        
        private function _onAddOccupant(e:RoomEvent):void 
        {
            displayMessage(e.getClient().getAttribute("USERNAME") + " joined the chat.");
        }
        
        private function _onRemoveOccupant(e:RoomEvent):void 
        {
            displayMessage(e.getClient().getAttribute("USERNAME") + " left the chat.");
        }
        
        private function _onChatMessage(client:IClient, message:String):void 
        {
            speak(message);
            displayMessage(client.getAttribute("USERNAME") + ": " + message.slice(2));
        }
        
        private function _onComplete(e:Event):void 
        {
            _sound.play();
        }
        
        private function _onSend(e:Event):void
        {
            if (_inputText.text == "") return;
            if (_inputText.text.length > 100)
            {
                displayMessage("!!error!!");
                return;
            }
            _room.sendMessage("CHAT_MESSAGE", true, null, _languages[_comboBox.selectedIndex] + _inputText.text);
            _inputText.text = "";
        }
    }
    
}